/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model.idp;

import java.util.ArrayList;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.service.IdentityProviderService;
import org.picketlink.identity.federation.core.config.IDPConfiguration;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.KeyValueType;

public class TrustDomainRemoveHandler
extends AbstractRemoveStepHandler {
    public static final TrustDomainRemoveHandler INSTANCE = new TrustDomainRemoveHandler();

    private TrustDomainRemoveHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String alias = ((Property)operation.get("address").asPropertyList().get(2)).getValue().asString();
        String domain = operation.get(ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN_NAME.getName()).asString();
        IdentityProviderService service = IdentityProviderService.getService(context.getServiceRegistry(true), alias);
        KeyProviderType keyProvider = ((IDPConfiguration)service.getConfiguration()).getKeyProvider();
        if (keyProvider != null) {
            for (KeyValueType validatinAlias : new ArrayList(keyProvider.getValidatingAlias())) {
                if (!validatinAlias.equals(domain)) continue;
                keyProvider.remove(validatinAlias);
            }
        }
        ((IDPConfiguration)service.getConfiguration()).removeTrustDomain(domain);
    }
}

