/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.service;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.ext.WebContextFactory;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.picketlink.as.subsystem.PicketLinkLogger;
import org.picketlink.as.subsystem.metrics.PicketLinkSubsystemMetrics;
import org.picketlink.as.subsystem.service.DomainModelConfigProvider;
import org.picketlink.as.subsystem.service.FederationService;
import org.picketlink.as.subsystem.service.PicketLinkService;
import org.picketlink.as.subsystem.service.PicketLinkWebContextFactory;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.config.PicketLinkConfigUtil;
import org.picketlink.identity.federation.core.config.PicketLinkType;
import org.picketlink.identity.federation.core.config.ProviderConfiguration;
import org.picketlink.identity.federation.core.config.ProviderType;
import org.picketlink.identity.federation.core.config.STSConfiguration;
import org.picketlink.identity.federation.core.config.TokenProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.handler.config.Handler;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.web.handlers.saml2.RolesGenerationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2AuthenticationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2EncryptionHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2IssuerTrustHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2LogOutHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2SignatureValidationHandler;

public abstract class AbstractEntityProviderService<T extends PicketLinkService<T>, C extends ProviderConfiguration>
implements PicketLinkService<T> {
    private PicketLinkType picketLinkType;
    private C configuration;
    private FederationService federationService;
    private PicketLinkSubsystemMetrics metrics;
    private static List<Class> commonHandlersList = new ArrayList<Class>();

    public AbstractEntityProviderService(OperationContext context, ModelNode operation) {
        this.federationService = FederationService.getService(context.getServiceRegistry(true), operation);
        this.configuration = this.toProviderType(operation);
        this.configuration.setKeyProvider(this.federationService.getKeyProvider());
    }

    protected abstract C toProviderType(ModelNode var1);

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    @Override
    public void configure(DeploymentUnit deploymentUnit) {
        this.configureHandlers();
        this.configureWarMetadata(deploymentUnit);
        this.configurePicketLinkWebContextFactory(deploymentUnit);
        this.doConfigureDeployment(deploymentUnit);
    }

    private void configureTokenProviders() {
        STSConfiguration samlConfig = this.getFederationService().getSamlConfig();
        if (samlConfig != null) {
            int tokenTimeout = samlConfig.getTokenTimeout();
            int clockSkew = samlConfig.getClockSkew();
            this.picketLinkType.getStsType().setTokenTimeout(Integer.valueOf(tokenTimeout));
            this.picketLinkType.getStsType().setClockSkew(Integer.valueOf(clockSkew));
            List tokenProviders = this.picketLinkType.getStsType().getTokenProviders().getTokenProvider();
            for (TokenProviderType tokenProviderType : tokenProviders) {
                if (!tokenProviderType.getTokenType().equals(JBossSAMLURIConstants.ASSERTION_NSURI.get())) continue;
                KeyValueType keyValueTypeTokenTimeout = new KeyValueType();
                keyValueTypeTokenTimeout.setKey("ASSERTIONS_VALIDITY");
                keyValueTypeTokenTimeout.setValue(String.valueOf(tokenTimeout));
                KeyValueType keyValueTypeClockSkew = new KeyValueType();
                keyValueTypeClockSkew.setKey("CLOCK_SKEW");
                keyValueTypeClockSkew.setValue(String.valueOf(clockSkew));
                tokenProviderType.add(keyValueTypeTokenTimeout);
                tokenProviderType.add(keyValueTypeClockSkew);
            }
        }
    }

    private void configureHandlers() {
        List handlers = this.getPicketLinkType().getHandlers().getHandler();
        for (Class commonHandlerClass : commonHandlersList) {
            for (Handler handler : new ArrayList(handlers)) {
                if (!handler.getClazz().equals(commonHandlerClass.getName())) continue;
                this.getPicketLinkType().getHandlers().remove(handler);
            }
        }
        this.getPicketLinkType().setHandlers(new Handlers());
        this.doAddHandlers();
        for (Handler handler : handlers) {
            this.getPicketLinkType().getHandlers().add(handler);
        }
    }

    protected void doAddHandlers() {
        for (Class commonHandlerClass : commonHandlersList) {
            PicketLinkConfigUtil.addHandler(commonHandlerClass, this.getPicketLinkType());
        }
    }

    private void configureWarMetadata(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        warMetaData.getMergedJBossWebMetaData().setSecurityDomain(this.getConfiguration().getSecurityDomain());
    }

    private void configurePicketLinkWebContextFactory(DeploymentUnit deploymentUnit) {
        deploymentUnit.putAttachment(WebContextFactory.ATTACHMENT, (Object)this.createPicketLinkWebContextFactory());
    }

    private PicketLinkWebContextFactory createPicketLinkWebContextFactory() {
        return new PicketLinkWebContextFactory(new DomainModelConfigProvider(this.getPicketLinkType()), this.getMetrics());
    }

    @Override
    public PicketLinkSubsystemMetrics getMetrics() {
        if (this.metrics == null) {
            try {
                this.metrics = new PicketLinkSubsystemMetrics(this.configuration.getSecurityDomain());
            }
            catch (ConfigurationException e) {
                PicketLinkLogger.ROOT_LOGGER.error("Error while configuring the metrics collector. Metrics will not be collected.", e);
            }
        }
        return this.metrics;
    }

    protected abstract void doConfigureDeployment(DeploymentUnit var1);

    public T getValue() throws IllegalStateException, IllegalArgumentException {
        return (T)this;
    }

    public C getConfiguration() {
        this.configuration.setKeyProvider(this.getFederationService().getKeyProvider());
        if (this.configuration.getKeyProvider() != null) {
            this.configuration.getKeyProvider().setClassName("org.picketlink.identity.federation.core.impl.KeyStoreKeyManager");
        }
        return this.configuration;
    }

    public void setConfiguration(C configuration) {
        this.configuration = configuration;
    }

    public FederationService getFederationService() {
        return this.federationService;
    }

    public PicketLinkType getPicketLinkType() {
        if (this.picketLinkType == null) {
            this.picketLinkType = new PicketLinkType();
            this.picketLinkType.setStsType(PicketLinkConfigUtil.createSTSType());
            this.picketLinkType.setHandlers(new Handlers());
            this.picketLinkType.setEnableAudit(true);
        }
        this.picketLinkType.setIdpOrSP((ProviderType)this.getConfiguration());
        this.configureTokenProviders();
        return this.picketLinkType;
    }

    static {
        commonHandlersList.add(SAML2IssuerTrustHandler.class);
        commonHandlersList.add(SAML2LogOutHandler.class);
        commonHandlersList.add(SAML2AuthenticationHandler.class);
        commonHandlersList.add(RolesGenerationHandler.class);
        commonHandlersList.add(SAML2EncryptionHandler.class);
        commonHandlersList.add(SAML2SignatureValidationHandler.class);
    }
}

