/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.service;

import java.io.InputStream;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.PicketLinkType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;

public class DomainModelConfigProvider
extends AbstractSAMLConfigurationProvider {
    private PicketLinkType configuration;

    public DomainModelConfigProvider(PicketLinkType picketLinkType) {
        this.configuration = picketLinkType;
    }

    public IDPType getIDPConfiguration() throws ProcessingException {
        if (this.getPicketLinkConfiguration().getIdpOrSP() != null && this.getPicketLinkConfiguration().getIdpOrSP() instanceof IDPType) {
            return (IDPType)this.getPicketLinkConfiguration().getIdpOrSP();
        }
        return null;
    }

    public SPType getSPConfiguration() throws ProcessingException {
        if (this.getPicketLinkConfiguration().getIdpOrSP() != null && this.getPicketLinkConfiguration().getIdpOrSP() instanceof SPType) {
            return (SPType)this.getPicketLinkConfiguration().getIdpOrSP();
        }
        return null;
    }

    public PicketLinkType getPicketLinkConfiguration() throws ProcessingException {
        if (this.configParsedPicketLinkType != null) {
            if (this.configParsedPicketLinkType.getHandlers() != null) {
                this.configuration.setHandlers(this.configParsedPicketLinkType.getHandlers());
            }
            if (this.configParsedPicketLinkType.getStsType() != null) {
                this.configuration.setStsType(this.configParsedPicketLinkType.getStsType());
            }
        }
        return this.configuration;
    }

    public boolean isServiceProviderConfiguration() {
        try {
            return this.getSPConfiguration() != null;
        }
        catch (ProcessingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isIdentityProviderConfiguration() {
        try {
            return this.getIDPConfiguration() != null;
        }
        catch (ProcessingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setConsolidatedConfigFile(InputStream is) throws ParsingException {
        try {
            super.setConsolidatedConfigFile(is);
        }
        catch (Exception e) {
            logger.trace("Configurations defined in picketlink.xml will be ignored.");
        }
    }
}

