/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.metrics;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.web.WebMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.picketlink.as.subsystem.metrics.PicketLinkSubsystemMetrics;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.service.PicketLinkService;

public abstract class AbstractPicketLinkMetricsOperationHandler
implements OperationStepHandler {
    protected static final SimpleAttributeDefinition CREATED_ASSERTIONS_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_CREATED_ASSERTIONS_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition RESPONSE_TO_SP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_RESPONSE_TO_SP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition ERROR_RESPONSE_TO_SP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_ERROR_RESPONSE_TO_SP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition ERROR_SIGN_VALIDATION_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_ERROR_SIGN_VALIDATION_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition ERROR_TRUSTED_DOMAIN_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_ERROR_TRUSTED_DOMAIN_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition EXPIRED_ASSERTIONS_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_EXPIRED_ASSERTIONS_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition LOGIN_INIT_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_LOGIN_INIT_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition LOGIN_COMPLETE_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_LOGIN_COMPLETE_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition REQUEST_FROM_IDP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_REQUEST_FROM_IDP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition RESPONSE_FROM_IDP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_RESPONSE_FROM_IDP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition REQUEST_TO_IDP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_REQUEST_TO_IDP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String name = address.getLastElement().getValue();
                    String attributeName = operation.require("name").asString();
                    ServiceController controller = context.getServiceRegistry(false).getService(AbstractPicketLinkMetricsOperationHandler.this.createServiceName(name));
                    if (controller != null) {
                        try {
                            AbstractPicketLinkMetricsOperationHandler.this.doPopulateResult(((PicketLinkService)controller.getValue()).getMetrics(), context.getResult(), attributeName);
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(new ModelNode().set(WebMessages.MESSAGES.failedToGetMetrics(e.getMessage())));
                        }
                    } else {
                        context.getResult().set(WebMessages.MESSAGES.noMetricsAvailable());
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        } else {
            context.getResult().set(WebMessages.MESSAGES.noMetricsAvailable());
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void doPopulateResult(PicketLinkSubsystemMetrics metrics, ModelNode result, String attributeName) {
    }

    protected abstract ServiceName createServiceName(String var1);
}

