/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.util.Base64;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;

public abstract class SAMLTokenFromHttpRequestAbstractLoginModule
extends AbstractServerLoginModule {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected String tokenEncoding = "none";
    private String samlTokenHttpHeader = null;
    private String samlTokenHttpHeaderRegEx = null;
    private Pattern pattern = null;
    private int samlTokenHttpHeaderRegExGroup = 0;
    public static final String TOKEN_ENCODING_TYPE_KEY = "tokenEncodingType";
    public static final String GZIP_TOKEN_ENCODING = "gzip";
    public static final String NONE_TOKEN_ENCODING = "none";
    public static final String BASE64_TOKEN_ENCODING = "base64";
    public static final String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
    public static final String REG_EX_PATTERN_KEY = "samlTokenHttpHeaderRegEx";
    public static final String REG_EX_GROUP_KEY = "samlTokenHttpHeaderRegExGroup";
    public static final String SAML_TOKEN_HTTP_HEADER_KEY = "samlTokenHttpHeader";

    protected SamlCredential getCredentialFromHttpRequest() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY);
        String encodedSamlToken = null;
        if (this.samlTokenHttpHeaderRegEx != null && !this.samlTokenHttpHeaderRegEx.equals("")) {
            String content = request.getHeader(this.samlTokenHttpHeader);
            if (logger.isTraceEnabled()) {
                this.log.trace((Object)("http header with SAML token [" + this.samlTokenHttpHeader + "]=" + content));
            }
            this.log.trace((Object)("samlTokenHttpHeaderRegEx=" + this.samlTokenHttpHeaderRegEx));
            Matcher m = this.pattern.matcher(content);
            m.matches();
            this.log.trace((Object)("samlTokenHttpHeaderRegExGroup=" + this.samlTokenHttpHeaderRegExGroup));
            encodedSamlToken = m.group(this.samlTokenHttpHeaderRegExGroup);
        } else {
            encodedSamlToken = request.getHeader(this.samlTokenHttpHeader);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("encodedSamlToken=" + encodedSamlToken);
        }
        String samlToken = null;
        if (this.tokenEncoding.equals(NONE_TOKEN_ENCODING) || this.tokenEncoding == null) {
            samlToken = encodedSamlToken;
        } else {
            byte[] decompressed = Base64.decode((String)encodedSamlToken);
            samlToken = new String(decompressed);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("decoded samlToken=" + samlToken);
        }
        return new SamlCredential(samlToken);
    }

    public String getTokenEncoding() {
        return this.tokenEncoding;
    }

    public String getSamlTokenHttpHeader() {
        return this.samlTokenHttpHeader;
    }

    public String getSamlTokenHttpHeaderRegEx() {
        return this.samlTokenHttpHeaderRegEx;
    }

    public int getSamlTokenHttpHeaderRegExGroup() {
        return this.samlTokenHttpHeaderRegExGroup;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String group;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.samlTokenHttpHeader = (String)this.options.get(SAML_TOKEN_HTTP_HEADER_KEY);
        String encoding = (String)this.options.get(TOKEN_ENCODING_TYPE_KEY);
        if (encoding != null) {
            this.tokenEncoding = encoding;
        }
        this.samlTokenHttpHeaderRegEx = (String)this.options.get(REG_EX_PATTERN_KEY);
        if (this.samlTokenHttpHeaderRegEx != null) {
            this.pattern = Pattern.compile(this.samlTokenHttpHeaderRegEx, 32);
        }
        if ((group = (String)this.options.get(REG_EX_GROUP_KEY)) != null) {
            this.samlTokenHttpHeaderRegExGroup = Integer.parseInt(group);
        }
    }
}

