/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.util.ArrayList;
import java.util.List;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.util.SOAPUtil;
import org.picketlink.trust.jbossws.Util;
import org.picketlink.trust.jbossws.handler.AbstractPicketLinkTrustHandler;
import org.picketlink.trust.jbossws.handler.SecurityActions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BinaryTokenHandler
extends AbstractPicketLinkTrustHandler {
    private String httpHeaderName = SecurityActions.getSystemProperty("binary.http.header", null);
    private String httpCookieName = SecurityActions.getSystemProperty("binary.http.cookie", null);
    private String encodingType = SecurityActions.getSystemProperty("binary.http.encodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
    private String valueType = SecurityActions.getSystemProperty("binary.http.valueType", null);
    private String valueTypeNamespace = SecurityActions.getSystemProperty("binary.http.valueType.namespace", null);
    private String valueTypePrefix = SecurityActions.getSystemProperty("binary.http.valueType.prefix", null);
    private boolean cleanToken = Boolean.parseBoolean(SecurityActions.getSystemProperty("binary.http.cleanToken", "false"));
    private SOAPFactory factory = null;

    public void setEncodingType(String binaryEncodingType) {
        this.encodingType = binaryEncodingType;
    }

    public void setValueType(String binaryValueType) {
        this.valueType = binaryValueType;
    }

    public void setValueTypeNamespace(String binaryValueNamespace) {
        this.valueTypeNamespace = binaryValueNamespace;
    }

    public void setValueTypePrefix(String binaryValuePrefix) {
        this.valueTypePrefix = binaryValuePrefix;
    }

    public void setHttpHeaderName(String http) {
        this.httpHeaderName = http;
    }

    public void setHttpCookieName(String http) {
        this.httpCookieName = http;
    }

    public void setCleanToken(boolean clean) {
        this.cleanToken = clean;
    }

    @Override
    protected boolean handleOutbound(MessageContext msgContext) {
        logger.trace("Handling Outbound Message");
        if (this.httpHeaderName == null && this.httpCookieName == null) {
            throw logger.injectedValueMissing("Either httpHeaderName or httpCookieName should be set");
        }
        HttpServletRequest servletRequest = this.getHttpRequest(msgContext);
        if (servletRequest == null) {
            throw logger.nullValueError("Http request");
        }
        String token = this.getTokenValue(servletRequest);
        if (token == null) {
            throw logger.nullValueError("Null Token");
        }
        SOAPElement security = null;
        try {
            security = this.create(token);
        }
        catch (SOAPException e) {
            logger.jbossWSUnableToCreateBinaryToken((Throwable)e);
        }
        if (security == null) {
            logger.jbossWSUnableToCreateSecurityToken();
            return true;
        }
        SOAPMessage sm = ((SOAPMessageContext)msgContext).getMessage();
        try {
            SOAPEnvelope envelope = sm.getSOAPPart().getEnvelope();
            SOAPHeader header = (SOAPHeader)Util.findElement((Element)envelope, new QName(envelope.getNamespaceURI(), "Header"));
            if (header == null) {
                header = (SOAPHeader)envelope.getOwnerDocument().createElementNS(envelope.getNamespaceURI(), envelope.getPrefix() + ":Header");
                envelope.insertBefore((Node)header, envelope.getFirstChild());
            }
            header.addChildElement(security);
        }
        catch (SOAPException e) {
            logger.jbossWSUnableToCreateBinaryToken((Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("SOAP Message=" + SOAPUtil.soapMessageAsString((SOAPMessage)sm));
        }
        return true;
    }

    private HttpServletRequest getHttpRequest(MessageContext msgContext) {
        HttpServletRequest request = (HttpServletRequest)msgContext.get((Object)"javax.xml.ws.servlet.request");
        if (request == null) {
            try {
                request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
            }
            catch (PolicyContextException e) {
                throw new RuntimeException(e);
            }
        }
        return request;
    }

    private String getTokenValue(HttpServletRequest http) {
        Cookie[] cookies;
        if (this.httpHeaderName != null && !this.httpHeaderName.isEmpty()) {
            if (this.httpHeaderName.contains(",")) {
                List<String> headers = this.getHeaderNames(this.httpHeaderName);
                StringBuilder builder = new StringBuilder();
                for (String header : headers) {
                    String value = this.getTokenValue(http, header);
                    if (value == null) continue;
                    builder.append(value);
                }
                String headerValue = builder.toString();
                logger.trace("Header value has been identified " + headerValue);
                return this.clean(headerValue);
            }
            String header = http.getHeader(this.httpHeaderName);
            if (header != null) {
                logger.trace("Header value has been identified " + header);
                return this.clean(header);
            }
        }
        if (this.httpCookieName != null && !this.httpCookieName.isEmpty() && (cookies = http.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.httpCookieName)) continue;
                logger.trace("Cookie value has been identified " + cookie.getValue());
                return this.clean(cookie.getValue());
            }
        }
        return null;
    }

    private String getTokenValue(HttpServletRequest http, String header) {
        String headerValue = http.getHeader(header);
        if (headerValue != null && !headerValue.isEmpty()) {
            return this.clean(headerValue);
        }
        return null;
    }

    private SOAPElement create(String token) throws SOAPException {
        if (this.factory == null) {
            this.factory = SOAPFactory.newInstance();
        }
        SOAPElement security = this.factory.createElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (this.valueTypeNamespace != null) {
            security.addNamespaceDeclaration(this.valueTypePrefix, this.valueTypeNamespace);
        }
        SOAPElement binarySecurityToken = this.factory.createElement("BinarySecurityToken", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        binarySecurityToken.addTextNode(token);
        if (this.valueType != null && !this.valueType.isEmpty()) {
            binarySecurityToken.setAttribute("ValueType", this.valueType);
        }
        if (this.encodingType != null) {
            binarySecurityToken.setAttribute("EncodingType", this.encodingType);
        }
        security.addChildElement(binarySecurityToken);
        return security;
    }

    private String clean(String value) {
        int i = -1;
        if (this.cleanToken) {
            value = value.trim();
            while ((i = value.indexOf(32)) != -1) {
                value = value.substring(i + 1);
            }
        }
        return value;
    }

    private List<String> getHeaderNames(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isNotNull((String)str)) {
            list.addAll(StringUtil.tokenize((String)str));
        }
        return list;
    }
}

