/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jetty.sp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.MultiMap;
import org.jboss.security.audit.AuditEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.AssertionExpiredException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.identity.federation.api.saml.v2.metadata.MetaDataExtractor;
import org.picketlink.identity.federation.bindings.jetty.sp.SecurityActions;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.saml.workflow.ServiceProviderSAMLWorkflow;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLRequestProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLResponseProcessor;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPFormAuthenticator
extends FormAuthenticator {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected transient String samlHandlerChainClass = null;
    protected ServletContext theServletContext = null;
    protected Map<String, Object> chainConfigOptions = new HashMap<String, Object>();
    protected SAMLConfigurationProvider configProvider = null;
    protected transient X509Certificate idpCertificate = null;
    protected int timerInterval = -1;
    protected Timer timer = null;
    public static final String EMPTY_PASSWORD = "EMPTY_STR";
    protected boolean enableAudit = false;
    public static final String FORM_PRINCIPAL_NOTE = "picketlink.form.principal";
    public static final String FORM_ROLES_NOTE = "picketlink.form.roles";
    public static final String FORM_REQUEST_NOTE = "picketlink.REQUEST";
    public static final String logoutPage = "/logout.html";
    protected transient SAML2HandlerChain chain = null;
    protected SPType spConfiguration = null;
    protected PicketLinkType picketLinkConfiguration = null;
    protected String serviceURL = null;
    protected String identityURL = null;
    protected String issuerID = null;
    protected String configFile;
    protected boolean saveRestoreRequest = true;
    protected Lock chainLock = new ReentrantLock();
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    protected PicketLinkAuditHelper auditHelper = null;
    protected TrustKeyManager keyManager;

    public SPFormAuthenticator() {
    }

    public SPFormAuthenticator(String login, String error, boolean dispatch) {
        super(login, error, dispatch);
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        super.setConfiguration(configuration);
        String contextPath = ContextHandler.getCurrentContext().getContextPath();
        this.theServletContext = ContextHandler.getCurrentContext().getContext(contextPath);
        this.startPicketLink();
    }

    public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean mandatory) throws ServerAuthException {
        String contextPath = ContextHandler.getCurrentContext().getContextPath();
        this.theServletContext = ContextHandler.getCurrentContext().getContext(contextPath);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        System.out.println("Request ID=" + servletRequest.toString());
        System.out.println("Session ID=" + session.getId());
        if (this.saveRestoreRequest && this.matchRequest(request)) {
            Principal savedPrincipal = (Principal)session.getAttribute(FORM_PRINCIPAL_NOTE);
            List savedRoles = (List)session.getAttribute(FORM_ROLES_NOTE);
            Authentication registeredAuthentication = this.register(request, savedPrincipal, savedRoles);
            if (this.restoreRequest(request, session)) {
                return registeredAuthentication;
            }
            return Authentication.UNAUTHENTICATED;
        }
        ServiceProviderSAMLWorkflow serviceProviderSAMLWorkflow = new ServiceProviderSAMLWorkflow();
        serviceProviderSAMLWorkflow.setRedirectionHandler((ServiceProviderSAMLWorkflow.RedirectionHandler)new JettyRedirectionHandler());
        boolean localLogout = serviceProviderSAMLWorkflow.isLocalLogoutRequest(request);
        if (localLogout) {
            try {
                serviceProviderSAMLWorkflow.sendToLogoutPage(request, response, session, this.theServletContext, logoutPage);
            }
            catch (ServletException e) {
                logger.samlLogoutError((Throwable)e);
                throw new RuntimeException(e);
            }
            catch (IOException e1) {
                logger.samlLogoutError((Throwable)e1);
                throw new RuntimeException(e1);
            }
            return Authentication.UNAUTHENTICATED;
        }
        String samlRequest = request.getParameter("SAMLRequest");
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        try {
            if (!(principal == null || serviceProviderSAMLWorkflow.isLocalLogoutRequest(request) || StringUtil.isNotNull((String)samlRequest) || StringUtil.isNotNull((String)samlResponse))) {
                return Authentication.SEND_SUCCESS;
            }
            if (!StringUtil.isNotNull((String)samlRequest) && !StringUtil.isNotNull((String)samlResponse)) {
                return this.generalUserRequest(servletRequest, servletResponse, mandatory);
            }
            if (StringUtil.isNotNull((String)samlResponse)) {
                return this.handleSAMLResponse(servletRequest, servletResponse, mandatory);
            }
            if (StringUtil.isNotNull((String)samlRequest)) {
                return this.handleSAMLRequest(servletRequest, servletResponse, mandatory);
            }
            return this.localAuthentication(servletRequest, servletResponse, mandatory);
        }
        catch (IOException e) {
            if (StringUtil.isNotNull((String)this.spConfiguration.getErrorPage())) {
                try {
                    request.getRequestDispatcher(this.spConfiguration.getErrorPage()).forward((ServletRequest)request, (ServletResponse)response);
                }
                catch (ServletException e1) {
                    logger.samlErrorPageForwardError(this.spConfiguration.getErrorPage(), (Throwable)e1);
                }
                catch (IOException e1) {
                    logger.samlErrorPageForwardError(this.spConfiguration.getErrorPage(), (Throwable)e1);
                }
                return Authentication.UNAUTHENTICATED;
            }
            throw new RuntimeException(e);
        }
    }

    private Authentication generalUserRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean mandatory) throws IOException, ServerAuthException {
        ServiceProviderSAMLWorkflow serviceProviderSAMLWorkflow = new ServiceProviderSAMLWorkflow();
        serviceProviderSAMLWorkflow.setRedirectionHandler((ServiceProviderSAMLWorkflow.RedirectionHandler)new JettyRedirectionHandler());
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession(false);
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext(request, response, this.theServletContext);
        Set handlers = this.chain.handlers();
        boolean postBinding = this.spConfiguration.getBindingType().equals("POST");
        SAML2HandlerResponse saml2HandlerResponse = null;
        try {
            ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(postBinding, this.serviceURL, this.picketLinkConfiguration);
            if (this.issuerID != null) {
                baseProcessor.setIssuer(this.issuerID);
            }
            baseProcessor.setIdentityURL(this.identityURL);
            baseProcessor.setAuditHelper(this.auditHelper);
            saml2HandlerResponse = baseProcessor.process(httpContext, handlers, this.chainLock);
        }
        catch (ProcessingException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ParsingException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ConfigurationException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        willSendRequest = saml2HandlerResponse.getSendRequest();
        Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
        String relayState = saml2HandlerResponse.getRelayState();
        String destination = saml2HandlerResponse.getDestination();
        String destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
        if (destination != null && samlResponseDocument != null) {
            try {
                if (this.saveRestoreRequest) {
                    this.saveRequest(request, session);
                }
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.REQUEST_TO_IDP);
                    auditEvent.setWhoIsAuditing(this.theServletContext.getContextPath());
                    this.auditHelper.audit((AuditEvent)auditEvent);
                }
                serviceProviderSAMLWorkflow.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest, destinationQueryStringWithSignature, this.isHttpPostBinding());
                return Authentication.SEND_CONTINUE;
            }
            catch (Exception e) {
                logger.samlSPHandleRequestError((Throwable)e);
                throw logger.samlSPProcessingExceptionError((Throwable)e);
            }
        }
        return this.localAuthentication(servletRequest, servletResponse, mandatory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchRequest(HttpServletRequest request) {
        HttpSession session;
        HttpSession httpSession = session = request.getSession(false);
        synchronized (httpSession) {
            String j_uri = (String)session.getAttribute("org.eclipse.jetty.security.form_URI");
            if (j_uri != null) {
                StringBuffer buf = request.getRequestURL();
                if (request.getQueryString() != null) {
                    buf.append("?").append(request.getQueryString());
                }
                if (j_uri.equals(buf.toString())) {
                    return true;
                }
            }
            return false;
        }
    }

    protected Authentication register(HttpServletRequest httpServletRequest, Principal principal, List<String> roles) {
        if (roles == null) {
            roles = new ArrayList<String>();
        }
        HttpSession session = httpServletRequest.getSession(false);
        session.setAttribute(FORM_PRINCIPAL_NOTE, (Object)principal);
        session.setAttribute(FORM_ROLES_NOTE, roles);
        Request request = (Request)httpServletRequest;
        Authentication authentication = request.getAuthentication();
        if (authentication == null) {
            Subject theSubject = new Subject();
            String[] theRoles = new String[roles.size()];
            roles.toArray(theRoles);
            DefaultUserIdentity userIdentity = new DefaultUserIdentity(theSubject, principal, theRoles);
            authentication = new UserAuthentication(this.getAuthMethod(), (UserIdentity)userIdentity);
            request.setAuthentication(authentication);
        }
        return authentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean restoreRequest(HttpServletRequest request, HttpSession session) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            String j_uri = (String)session.getAttribute("org.eclipse.jetty.security.form_URI");
            if (j_uri != null) {
                MultiMap j_post;
                StringBuffer buf = request.getRequestURL();
                if (request.getQueryString() != null) {
                    buf.append("?").append(request.getQueryString());
                }
                if ((j_post = (MultiMap)session.getAttribute("org.eclipse.jetty.security.form_POST")) != null) {
                    Request base_request = HttpChannel.getCurrentHttpChannel().getRequest();
                    base_request.setParameters(j_post);
                }
                session.removeAttribute("org.eclipse.jetty.security.form_URI");
                session.removeAttribute("org.eclipse.jetty.security.form_METHOD");
                session.removeAttribute("org.eclipse.jetty.security.form_POST");
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRequest(HttpServletRequest request, HttpSession session) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            if (session.getAttribute("org.eclipse.jetty.security.form_URI") == null) {
                StringBuffer buf = request.getRequestURL();
                if (request.getQueryString() != null) {
                    buf.append("?").append(request.getQueryString());
                }
                session.setAttribute("org.eclipse.jetty.security.form_URI", (Object)buf.toString());
                session.setAttribute("org.eclipse.jetty.security.form_METHOD", (Object)request.getMethod());
                if (MimeTypes.Type.FORM_ENCODED.is(request.getContentType()) && HttpMethod.POST.is(request.getMethod())) {
                    Request base_request = request instanceof Request ? (Request)request : HttpChannel.getCurrentHttpChannel().getRequest();
                    base_request.extractParameters();
                    session.setAttribute("org.eclipse.jetty.security.form_POST", (Object)new MultiMap(base_request.getParameters()));
                }
            }
        }
    }

    protected Authentication localAuthentication(ServletRequest servletRequest, ServletResponse servletResponse, boolean mandatory) throws IOException, ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (request.getUserPrincipal() == null) {
            logger.samlSPFallingBackToLocalFormAuthentication();
            try {
                return super.validateRequest(servletRequest, servletResponse, mandatory);
            }
            catch (NoSuchMethodError e) {
            }
        } else {
            return Authentication.SEND_SUCCESS;
        }
        return Authentication.UNAUTHENTICATED;
    }

    private Authentication handleSAMLRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean mandatory) throws IOException, ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String samlRequest = request.getParameter("SAMLRequest");
        HTTPContext httpContext = new HTTPContext(request, response, this.theServletContext);
        Set handlers = this.chain.handlers();
        try {
            ServiceProviderSAMLRequestProcessor requestProcessor = new ServiceProviderSAMLRequestProcessor(request.getMethod().equals("POST"), this.serviceURL, this.picketLinkConfiguration);
            requestProcessor.setTrustKeyManager(this.keyManager);
            boolean result = requestProcessor.process(samlRequest, httpContext, handlers, this.chainLock);
            if (this.enableAudit) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.REQUEST_FROM_IDP);
                auditEvent.setWhoIsAuditing(this.theServletContext.getContextPath());
                this.auditHelper.audit((AuditEvent)auditEvent);
            }
            if (response.isCommitted()) {
                return Authentication.UNAUTHENTICATED;
            }
            if (result) {
                return Authentication.SEND_SUCCESS;
            }
        }
        catch (Exception e) {
            logger.samlSPHandleRequestError((Throwable)e);
            throw logger.samlSPProcessingExceptionError((Throwable)e);
        }
        return this.localAuthentication(servletRequest, servletResponse, mandatory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authentication handleSAMLResponse(ServletRequest servletRequest, ServletResponse servletResponse, boolean mandatory) throws IOException, ServerAuthException {
        ServiceProviderSAMLWorkflow serviceProviderSAMLWorkflow = new ServiceProviderSAMLWorkflow();
        serviceProviderSAMLWorkflow.setRedirectionHandler((ServiceProviderSAMLWorkflow.RedirectionHandler)new JettyRedirectionHandler());
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession(false);
        String samlResponse = request.getParameter("SAMLResponse");
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext(request, response, this.theServletContext);
        Set handlers = this.chain.handlers();
        Principal principal = request.getUserPrincipal();
        if (!serviceProviderSAMLWorkflow.validate(request)) {
            throw new IOException("PL00019: Validation check failed");
        }
        try {
            ServiceProviderSAMLResponseProcessor responseProcessor = new ServiceProviderSAMLResponseProcessor(request.getMethod().equals("POST"), this.serviceURL, this.picketLinkConfiguration);
            if (this.auditHelper != null) {
                responseProcessor.setAuditHelper(this.auditHelper);
            }
            responseProcessor.setTrustKeyManager(this.keyManager);
            SAML2HandlerResponse saml2HandlerResponse = responseProcessor.process(samlResponse, httpContext, handlers, this.chainLock);
            Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
            String relayState = saml2HandlerResponse.getRelayState();
            String destination = saml2HandlerResponse.getDestination();
            willSendRequest = saml2HandlerResponse.getSendRequest();
            String destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
            if (destination == null || samlResponseDocument == null) {
                boolean sessionValidity = this.sessionIsValid(session);
                if (!sessionValidity) {
                    serviceProviderSAMLWorkflow.sendToLogoutPage(request, response, session, this.theServletContext, logoutPage);
                    return Authentication.UNAUTHENTICATED;
                }
                List roles = saml2HandlerResponse.getRoles();
                if (principal == null) {
                    principal = (Principal)session.getAttribute("picketlink.principal");
                }
                String username = principal.getName();
                String password = EMPTY_PASSWORD;
                if (logger.isTraceEnabled()) {
                    logger.trace("Roles determined for username=" + username + "=" + Arrays.toString(roles.toArray()));
                }
                Authentication registeredAuthentication = this.register(request, principal, roles);
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.RESPONSE_FROM_IDP);
                    auditEvent.setSubjectName(username);
                    auditEvent.setWhoIsAuditing(this.theServletContext.getContextPath());
                    this.auditHelper.audit((AuditEvent)auditEvent);
                }
                if (this.saveRestoreRequest) {
                    String nuri;
                    HttpSession httpSession = session;
                    synchronized (httpSession) {
                        nuri = (String)session.getAttribute("org.eclipse.jetty.security.form_URI");
                        if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                            nuri = "/";
                        }
                    }
                    response.setContentLength(0);
                    Response base_response = HttpChannel.getCurrentHttpChannel().getResponse();
                    Request base_request = HttpChannel.getCurrentHttpChannel().getRequest();
                    int redirectCode = base_request.getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
                    base_response.sendRedirect(redirectCode, response.encodeRedirectURL(nuri));
                    return registeredAuthentication;
                }
                return registeredAuthentication;
            }
            serviceProviderSAMLWorkflow.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest, destinationQueryStringWithSignature, this.spConfiguration.getBindingType().equalsIgnoreCase("POST"));
        }
        catch (ProcessingException pe) {
            Throwable t = pe.getCause();
            if (t != null && t instanceof AssertionExpiredException) {
                logger.error("Assertion has expired. Asking IDP for reissue");
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.EXPIRED_ASSERTION);
                    auditEvent.setAssertionID(((AssertionExpiredException)t).getId());
                    this.auditHelper.audit((AuditEvent)auditEvent);
                }
                return this.generalUserRequest(servletRequest, servletResponse, mandatory);
            }
            logger.samlSPHandleRequestError((Throwable)pe);
            throw logger.samlSPProcessingExceptionError((Throwable)pe);
        }
        catch (Exception e) {
            logger.samlSPHandleRequestError((Throwable)e);
            throw logger.samlSPProcessingExceptionError((Throwable)e);
        }
        return this.localAuthentication(servletRequest, servletResponse, mandatory);
    }

    protected boolean isHttpPostBinding() {
        return this.spConfiguration.getBindingType().equalsIgnoreCase("POST");
    }

    protected boolean sessionIsValid(HttpSession session) {
        try {
            long sessionTime = session.getCreationTime();
        }
        catch (IllegalStateException ise) {
            return false;
        }
        return true;
    }

    protected String savedRequestURL(HttpSession session) {
        StringBuilder builder = new StringBuilder();
        HttpServletRequest request = (HttpServletRequest)session.getAttribute(FORM_REQUEST_NOTE);
        if (request != null) {
            builder.append(request.getRequestURI());
            if (request.getQueryString() != null) {
                builder.append("?").append(request.getQueryString());
            }
        }
        return builder.toString();
    }

    protected void startPicketLink() {
        SystemPropertiesUtil.ensure();
        Handlers handlers = null;
        if (this.timerInterval > 0) {
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.timer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    SPFormAuthenticator.this.processConfiguration();
                    SPFormAuthenticator.this.initKeyProvider(SPFormAuthenticator.this.theServletContext);
                }
            }, this.timerInterval, (long)this.timerInterval);
        }
        if (StringUtil.isNullOrEmpty((String)this.samlHandlerChainClass)) {
            this.chain = SAML2HandlerChainFactory.createChain();
        } else {
            try {
                this.chain = SAML2HandlerChainFactory.createChain((String)this.samlHandlerChainClass);
            }
            catch (ProcessingException e1) {
                throw new RuntimeException(e1);
            }
        }
        this.processConfiguration();
        try {
            if (this.picketLinkConfiguration != null) {
                handlers = this.picketLinkConfiguration.getHandlers();
            } else {
                String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
                handlers = ConfigurationUtil.getHandlers((InputStream)this.theServletContext.getResourceAsStream(handlerConfigFileName));
            }
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
            this.initKeyProvider(this.theServletContext);
            this.populateChainConfig();
            this.initializeHandlerChain();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.picketLinkConfiguration == null) {
            this.picketLinkConfiguration = new PicketLinkType();
            this.picketLinkConfiguration.setIdpOrSP((ProviderType)this.spConfiguration);
            this.picketLinkConfiguration.setHandlers(handlers);
        }
    }

    protected void initKeyProvider(ServletContext context) {
        if (!this.doSupportSignature()) {
            return;
        }
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null && this.doSupportSignature()) {
            throw new RuntimeException("PL00092: Null Value:KeyProvider is null for context=" + context.getContextPath());
        }
        try {
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("PL00092: Null Value:KeyManager class name");
            }
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), keyManagerClassName);
            if (clazz == null) {
                throw new ClassNotFoundException("PL00085: Class Not Loaded:" + keyManagerClassName);
            }
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            String identityURL = this.spConfiguration.getIdentityURL();
            if (authProperties != null) {
                for (AuthPropertyType authPropertyType : authProperties) {
                    String key = authPropertyType.getKey();
                    if (!"X509CERTIFICATE".equals(key)) continue;
                    this.keyManager.addAdditionalOption("X509CERTIFICATE", (Object)authPropertyType.getValue());
                    break;
                }
            }
            this.keyManager.addAdditionalOption("idp.key", (Object)new URL(identityURL).getHost());
        }
        catch (Exception e) {
            logger.trustKeyManagerCreationError((Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        logger.trace("Key Provider=" + keyProvider.getClassName());
    }

    protected boolean doSupportSignature() {
        if (this.spConfiguration != null) {
            return this.spConfiguration.isSupportsSignature();
        }
        return false;
    }

    protected void processConfiguration() {
        InputStream is = null;
        if (StringUtil.isNullOrEmpty((String)this.configFile)) {
            this.configFile = "/WEB-INF/picketlink.xml";
            is = this.theServletContext.getResourceAsStream(this.configFile);
        } else {
            try {
                is = new FileInputStream(this.configFile);
            }
            catch (FileNotFoundException e) {
                throw logger.samlIDPConfigurationError((Throwable)e);
            }
        }
        try {
            if (this.configProvider != null) {
                try {
                    if (is == null) {
                        is = this.theServletContext.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                        if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                            ((AbstractSAMLConfigurationProvider)this.configProvider).setConfigFile(is);
                        }
                    } else if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                        ((AbstractSAMLConfigurationProvider)this.configProvider).setConsolidatedConfigFile(is);
                    }
                    this.picketLinkConfiguration = this.configProvider.getPicketLinkConfiguration();
                    this.spConfiguration = this.configProvider.getSPConfiguration();
                }
                catch (ProcessingException e) {
                    throw logger.samlSPConfigurationError((Throwable)e);
                }
                catch (ParsingException e) {
                    throw logger.samlSPConfigurationError((Throwable)e);
                }
            } else if (is != null) {
                try {
                    this.picketLinkConfiguration = ConfigurationUtil.getConfiguration((InputStream)is);
                    this.spConfiguration = (SPType)this.picketLinkConfiguration.getIdpOrSP();
                }
                catch (ParsingException e) {
                    logger.trace((Throwable)e);
                    throw logger.samlSPConfigurationError((Throwable)e);
                }
            } else {
                is = this.theServletContext.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                if (is == null) {
                    throw logger.configurationFileMissing(this.configFile);
                }
                this.spConfiguration = ConfigurationUtil.getSPConfiguration((InputStream)is);
            }
            if (this.picketLinkConfiguration != null) {
                String sysProp;
                this.enableAudit = this.picketLinkConfiguration.isEnableAudit();
                if (!this.enableAudit && !"NULL".equals(sysProp = SecurityActions.getSystemProperty("picketlink.audit.enable", "NULL"))) {
                    this.enableAudit = Boolean.parseBoolean(sysProp);
                }
                if (this.enableAudit && this.auditHelper == null) {
                    String securityDomainName = PicketLinkAuditHelper.getSecurityDomainName((ServletContext)this.theServletContext);
                    this.auditHelper = new PicketLinkAuditHelper(securityDomainName);
                }
            }
            if (StringUtil.isNotNull((String)this.spConfiguration.getIdpMetadataFile())) {
                this.processIDPMetadataFile(this.spConfiguration.getIdpMetadataFile());
            } else {
                this.identityURL = this.spConfiguration.getIdentityURL();
            }
            this.serviceURL = this.spConfiguration.getServiceURL();
            this.canonicalizationMethod = this.spConfiguration.getCanonicalizationMethod();
            logger.samlSPSettingCanonicalizationMethod(this.canonicalizationMethod);
            XMLSignatureUtil.setCanonicalizationMethodType((String)this.canonicalizationMethod);
            logger.trace("Identity Provider URL=" + this.identityURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void processIDPMetadataFile(String idpMetadataFile) {
        List keyDescriptors;
        InputStream is = this.theServletContext.getResourceAsStream(idpMetadataFile);
        if (is == null) {
            return;
        }
        Object metadata = null;
        try {
            Document samlDocument = DocumentUtil.getDocument((InputStream)is);
            SAMLParser parser = new SAMLParser();
            metadata = parser.parse(DocumentUtil.getNodeAsStream((Node)samlDocument));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IDPSSODescriptorType idpSSO = null;
        if (metadata instanceof EntitiesDescriptorType) {
            EntitiesDescriptorType entities = (EntitiesDescriptorType)metadata;
            idpSSO = this.handleMetadata(entities);
        } else {
            idpSSO = this.handleMetadata((EntityDescriptorType)metadata);
        }
        if (idpSSO == null) {
            logger.samlSPUnableToGetIDPDescriptorFromMetadata();
            return;
        }
        List endpoints = idpSSO.getSingleSignOnService();
        for (EndpointType endpoint : endpoints) {
            String endpointBinding = endpoint.getBinding().toString();
            if (endpointBinding.contains("HTTP-POST")) {
                endpointBinding = "POST";
            } else if (endpointBinding.contains("HTTP-Redirect")) {
                endpointBinding = "REDIRECT";
            }
            if (!this.spConfiguration.getBindingType().equals(endpointBinding)) continue;
            this.identityURL = endpoint.getLocation().toString();
            break;
        }
        if ((keyDescriptors = idpSSO.getKeyDescriptor()).size() > 0) {
            this.idpCertificate = MetaDataExtractor.getCertificate((KeyDescriptorType)((KeyDescriptorType)keyDescriptors.get(0)));
        }
    }

    protected IDPSSODescriptorType handleMetadata(EntitiesDescriptorType entities) {
        Object entityDescriptor;
        IDPSSODescriptorType idpSSO = null;
        List entityDescs = entities.getEntityDescriptor();
        Iterator i$ = entityDescs.iterator();
        while (i$.hasNext() && (idpSSO = (entityDescriptor = i$.next()) instanceof EntitiesDescriptorType ? this.getIDPSSODescriptor(entities) : this.handleMetadata((EntityDescriptorType)entityDescriptor)) == null) {
        }
        return idpSSO;
    }

    protected IDPSSODescriptorType handleMetadata(EntityDescriptorType entityDescriptor) {
        return CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)entityDescriptor);
    }

    protected IDPSSODescriptorType getIDPSSODescriptor(EntitiesDescriptorType entities) {
        List entityDescs = entities.getEntityDescriptor();
        Iterator i$ = entityDescs.iterator();
        if (i$.hasNext()) {
            Object entityDescriptor = i$.next();
            if (entityDescriptor instanceof EntitiesDescriptorType) {
                return this.getIDPSSODescriptor((EntitiesDescriptorType)entityDescriptor);
            }
            return CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)((EntityDescriptorType)entityDescriptor));
        }
        return null;
    }

    protected void initializeHandlerChain() throws ConfigurationException, ProcessingException {
        this.populateChainConfig();
        DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(this.chainConfigOptions);
        Set samlHandlers = this.chain.handlers();
        for (SAML2Handler handler : samlHandlers) {
            handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
        }
    }

    protected void populateChainConfig() throws ConfigurationException, ProcessingException {
        this.chainConfigOptions.put("CONFIGURATION", this.spConfiguration);
        this.chainConfigOptions.put("ROLE_VALIDATOR_IGNORE", "false");
        if (this.doSupportSignature()) {
            this.chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
            String certificateAlias = (String)this.keyManager.getAdditionalOption("X509CERTIFICATE");
            if (certificateAlias != null) {
                this.chainConfigOptions.put("X509CERTIFICATE", this.keyManager.getCertificate(certificateAlias));
            }
        }
    }

    public class JettyRedirectionHandler
    extends ServiceProviderSAMLWorkflow.RedirectionHandler {
        public void sendRedirectForRequestor(String destination, HttpServletResponse response) throws IOException {
            this.common(destination, response);
            response.setHeader("Cache-Control", "no-cache, no-store");
            this.sendRedirect(response, destination);
        }

        public void sendRedirectForResponder(String destination, HttpServletResponse response) throws IOException {
            this.common(destination, response);
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate,private");
            this.sendRedirect(response, destination);
        }

        private void common(String destination, HttpServletResponse response) {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Location", destination);
            response.setHeader("Pragma", "no-cache");
        }

        private void sendRedirect(HttpServletResponse response, String destination) throws IOException {
            response.setStatus(302);
            response.sendRedirect(destination);
        }
    }
}

