/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json;

import java.io.Serializable;
import java.util.Arrays;
import org.picketlink.json.JsonException;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.jose.crypto.Algorithm;

public class JsonMessages_$bundle
implements Serializable,
JsonMessages {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "PLJSON";
    public static final JsonMessages_$bundle INSTANCE = new JsonMessages_$bundle();
    private static final String cryptoSignatureNotPresent = "Signature not present: [%s].";
    private static final String missingHeader = "Missing header [%s].";
    private static final String couldNotCreateToken = "Error creating token instance from type [%s].";
    private static final String cryptoInvalidSignature = "Invalid signature for JSON [%s].";
    private static final String cryptoSignatureFailed = "Could not create signature using algorithm [%s].";
    private static final String invalidFormat = "The given string does not represent a valid JWT token [%s].";
    private static final String cryptoSignatureValidationFailed = "Could not verify signature using algorithm [%s].";
    private static final String cryptoNoSuchAlgorithm = "No such algorithm [%s].";
    private static final String failEncodeToken = "Could not encode token.";
    private static final String invalidNullArgument = "The argument %s cannot be null";

    protected JsonMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final JsonException cryptoSignatureNotPresent(String json) {
        JsonException result = new JsonException(String.format("PLJSON000025: " + this.cryptoSignatureNotPresent$str(), json));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoSignatureNotPresent$str() {
        return cryptoSignatureNotPresent;
    }

    @Override
    public final JsonException missingHeader(String header) {
        JsonException result = new JsonException(String.format("PLJSON000004: " + this.missingHeader$str(), header));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingHeader$str() {
        return missingHeader;
    }

    public final JsonException couldNotCreateToken(Class type, Throwable t) {
        JsonException result = new JsonException(String.format("PLJSON000023: " + this.couldNotCreateToken$str(), type), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateToken$str() {
        return couldNotCreateToken;
    }

    @Override
    public final JsonException cryptoInvalidSignature(String json) {
        JsonException result = new JsonException(String.format("PLJSON000024: " + this.cryptoInvalidSignature$str(), json));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoInvalidSignature$str() {
        return cryptoInvalidSignature;
    }

    @Override
    public final JsonException cryptoSignatureFailed(Algorithm algorithm, Throwable throwable) {
        JsonException result = new JsonException(String.format("PLJSON000022: " + this.cryptoSignatureFailed$str(), new Object[]{algorithm}), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoSignatureFailed$str() {
        return cryptoSignatureFailed;
    }

    @Override
    public final JsonException invalidFormat(String json) {
        JsonException result = new JsonException(String.format("PLJSON000003: " + this.invalidFormat$str(), json));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFormat$str() {
        return invalidFormat;
    }

    @Override
    public final JsonException cryptoSignatureValidationFailed(Algorithm algorithm, Throwable throwable) {
        JsonException result = new JsonException(String.format("PLJSON000021: " + this.cryptoSignatureValidationFailed$str(), new Object[]{algorithm}), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoSignatureValidationFailed$str() {
        return cryptoSignatureValidationFailed;
    }

    @Override
    public final JsonException cryptoNoSuchAlgorithm(String name, Throwable throwable) {
        JsonException result = new JsonException(String.format("PLJSON000020: " + this.cryptoNoSuchAlgorithm$str(), name), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoNoSuchAlgorithm$str() {
        return cryptoNoSuchAlgorithm;
    }

    @Override
    public final JsonException failEncodeToken(Throwable throwable) {
        JsonException result = new JsonException(String.format("PLJSON000002: " + this.failEncodeToken$str(), new Object[0]), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failEncodeToken$str() {
        return failEncodeToken;
    }

    @Override
    public final JsonException invalidNullArgument(String argName) {
        JsonException result = new JsonException(String.format("PLJSON000001: " + this.invalidNullArgument$str(), argName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullArgument$str() {
        return invalidNullArgument;
    }
}

