/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose.crypto;

import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.jose.crypto.Algorithm;
import org.picketlink.json.jose.crypto.SignatureProvider;

public class HMACSignatureProvider
implements SignatureProvider {
    private static HMACSignatureProvider instance;

    private HMACSignatureProvider() {
    }

    static final SignatureProvider instance() {
        if (instance == null) {
            instance = new HMACSignatureProvider();
        }
        return instance;
    }

    @Override
    public byte[] sign(byte[] data, Algorithm algorithm, byte[] key) {
        try {
            Mac mac = Mac.getInstance(algorithm.getAlgorithm());
            SecretKeySpec keySpec = new SecretKeySpec(key, mac.getAlgorithm());
            mac.init(keySpec);
            mac.update(data);
            return mac.doFinal();
        }
        catch (Exception e) {
            throw JsonMessages.MESSAGES.cryptoSignatureFailed(algorithm, e);
        }
    }

    @Override
    public boolean verify(byte[] data, Algorithm algorithm, byte[] signature, byte[] key) {
        try {
            return Arrays.equals(this.sign(data, algorithm, key), signature);
        }
        catch (Exception e) {
            throw JsonMessages.MESSAGES.cryptoSignatureValidationFailed(algorithm, e);
        }
    }
}

