/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.picketlink.json.util.JsonUtil;

public class JWE {
    private JsonObject headers;

    protected JWE(JsonObject headers) {
        this.headers = headers;
    }

    public String encode() {
        return JsonUtil.b64Encode(this.getPlainHeaders());
    }

    public String geType() {
        return this.getHeader("typ");
    }

    public String getContentType() {
        return this.getHeader("cty");
    }

    public String getAlgorithm() {
        return this.getHeader("alg");
    }

    public String getEncryptionAlgorithm() {
        return this.getHeader("enc");
    }

    public String getCEKBitLength() {
        return this.getHeader("cek_bitlength");
    }

    public String getKeyIdentifier() {
        return this.getHeader("kid");
    }

    public String getCompressionAlgorithm() {
        return this.getHeader("zip");
    }

    public String getJWKSet() {
        return this.getHeader("jku");
    }

    public String getJWK() {
        return this.getHeader("keys");
    }

    public String getX509Url() {
        return this.getHeader("x5u");
    }

    public List<String> getX509CertificateChain() {
        return this.getHeaderValues("x5c");
    }

    public String getX509SHA1CertificateThumbprint() {
        return this.getHeader("x5t");
    }

    public String getX509SHA256CertificateThumbprint() {
        return this.getHeader("x5t#S256");
    }

    public List<String> getCriticalHeader() {
        return this.getHeaderValues("crit");
    }

    public String toString() {
        return this.getPlainHeaders();
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.getValue(name, this.headers);
    }

    public List<String> getHeaderValues(String name) {
        return this.getValues(name, this.headers);
    }

    public JsonObject getJsonObject() {
        return this.headers;
    }

    private String getPlainHeaders() {
        StringWriter keyParameterWriter = new StringWriter();
        Json.createWriter((Writer)keyParameterWriter).writeObject(this.headers);
        return keyParameterWriter.getBuffer().toString();
    }

    private List<String> getValues(String name, JsonObject jsonObject) {
        JsonValue headerValue = (JsonValue)jsonObject.get((Object)name);
        ArrayList<String> values = new ArrayList<String>();
        if (headerValue != null) {
            if (JsonArray.class.isInstance(headerValue)) {
                JsonArray array = (JsonArray)headerValue;
                for (JsonValue value : array.getValuesAs(JsonValue.class)) {
                    values.add(this.getValue(value).toString());
                }
            } else {
                values.add(this.getValue(name, jsonObject).toString());
            }
        }
        return values;
    }

    private <R> R getValue(JsonValue value) {
        if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
            JsonArray array = (JsonArray)value;
            Iterator i$ = array.iterator();
            if (i$.hasNext()) {
                JsonValue jsonValue = (JsonValue)i$.next();
                return this.getValue(jsonValue);
            }
        } else {
            if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
                return (R)((JsonString)value).getString();
            }
            if (JsonValue.ValueType.NUMBER.equals((Object)value.getValueType())) {
                return (R)((JsonNumber)value).bigDecimalValue().toPlainString();
            }
            if (JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) || JsonValue.ValueType.FALSE.equals((Object)value.getValueType())) {
                return (R)Boolean.valueOf(value.toString());
            }
        }
        return null;
    }

    private String getValue(String name, JsonObject jsonObject) {
        JsonValue value = (JsonValue)jsonObject.get((Object)name);
        if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
            JsonArray array = (JsonArray)value;
            Iterator i$ = array.iterator();
            if (i$.hasNext()) {
                JsonValue jsonValue = (JsonValue)i$.next();
                return (String)this.getValue(jsonValue);
            }
        } else {
            if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
                return ((JsonString)value).getString();
            }
            if (JsonValue.ValueType.NUMBER.equals((Object)value.getValueType())) {
                return ((JsonNumber)value).bigDecimalValue().toPlainString();
            }
            if (JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) || JsonValue.ValueType.FALSE.equals((Object)value.getValueType())) {
                return value.toString();
            }
        }
        return null;
    }
}

