/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.jose.JWE;
import org.picketlink.json.jose.JWK;
import org.picketlink.json.jose.JWKSet;
import org.picketlink.json.util.JsonUtil;

public class JWEBuilder<T extends JWE, B extends JWEBuilder<?, ?>> {
    private final JsonObjectBuilder headerBuilder;
    private final Class<T> tokenType;

    public JWEBuilder() {
        this(JWE.class);
    }

    protected JWEBuilder(Class<T> tokenType) {
        this.tokenType = tokenType;
        this.headerBuilder = Json.createObjectBuilder();
    }

    public JWEBuilder<T, B> type(String type) {
        this.header("typ", type);
        return this;
    }

    public JWEBuilder<T, B> contentType(String contentType) {
        this.header("cty", contentType);
        return this;
    }

    public JWEBuilder<T, B> algorithm(String algorithm) {
        this.header("alg", algorithm);
        return this;
    }

    public JWEBuilder<T, B> encryptionAlgorithm(String encAlgorithm, int cekBitLength) {
        this.header("enc", encAlgorithm);
        this.header("cek_bitlength", cekBitLength);
        return this;
    }

    public JWEBuilder<T, B> keyIdentifier(String keyId) {
        this.header("kid", keyId);
        return this;
    }

    public JWEBuilder<T, B> compressionAlgorithm(String zipAlgorithm) {
        this.header("zip", zipAlgorithm);
        return this;
    }

    public JWEBuilder<T, B> keys(JWKSet keySet) {
        this.header("keys", keySet.getJsonObject().getJsonArray("keys"));
        return this;
    }

    public JWEBuilder<T, B> keys(JWK ... keys) {
        JWKSet jwkSet = new JWKSet(keys);
        return this.keys(jwkSet);
    }

    public JWEBuilder<T, B> JWKSet(String jwkSetURL) {
        this.header("jku", jwkSetURL);
        return this;
    }

    public JWEBuilder<T, B> X509URL(String x509URL) {
        this.header("x5u", x509URL);
        return this;
    }

    public JWEBuilder<T, B> X509CertificateChain(String ... certificates) {
        if (certificates.length == 1) {
            this.header("x5c", certificates[0]);
        } else if (certificates.length > 1) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String operation : certificates) {
                arrayBuilder.add(operation);
            }
            this.headerBuilder.add("x5c", arrayBuilder);
        }
        return this;
    }

    public JWEBuilder<T, B> X509CertificateSHA1Thumbprint(String sha1Thumbprint) {
        this.header("x5t", sha1Thumbprint);
        return this;
    }

    public JWEBuilder<T, B> X509CertificateSHA256Thumbprint(String sha256Thumbprint) {
        this.header("x5t#S256", sha256Thumbprint);
        return this;
    }

    public JWEBuilder<T, B> header(String name, String ... value) {
        this.setString(this.headerBuilder, name, value);
        return this;
    }

    public JWEBuilder<T, B> header(String name, int ... value) {
        this.setInt(this.headerBuilder, name, value);
        return this;
    }

    public JWEBuilder<T, B> header(String name, List<JsonObject> value) {
        this.setJsonObject(this.headerBuilder, name, value);
        return this;
    }

    public JWEBuilder<T, B> header(String name, JsonArray value) {
        this.setJsonObject(this.headerBuilder, name, value);
        return this;
    }

    public T build() {
        return this.build(this.headerBuilder.build());
    }

    public T build(String json) {
        byte[] keyParameters = JsonUtil.b64Decode(json);
        return this.build(Json.createReader((InputStream)new ByteArrayInputStream(keyParameters)).readObject());
    }

    protected JsonObjectBuilder getHeaderBuilder() {
        return this.headerBuilder;
    }

    protected Class<T> getTokenType() {
        return this.tokenType;
    }

    protected T build(JsonObject headersObject) {
        try {
            Constructor<T> constructor = this.tokenType.getDeclaredConstructor(JsonObject.class);
            constructor.setAccessible(true);
            return (T)((JWE)constructor.newInstance(headersObject));
        }
        catch (Exception e) {
            throw JsonMessages.MESSAGES.couldNotCreateToken(this.tokenType, e);
        }
    }

    private JWEBuilder<T, B> setString(JsonObjectBuilder builder, String name, String ... values) {
        if (values.length == 1) {
            builder.add(name, values[0]);
        } else if (values.length > 1) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String value : values) {
                arrayBuilder.add(value.toString());
            }
            builder.add(name, arrayBuilder);
        }
        return this;
    }

    private JWEBuilder<T, B> setInt(JsonObjectBuilder builder, String name, int ... values) {
        if (values.length == 1) {
            builder.add(name, values[0]);
        } else if (values.length > 1) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (int value : values) {
                arrayBuilder.add(value);
            }
            builder.add(name, arrayBuilder);
        }
        return this;
    }

    private JWEBuilder<T, B> setJsonObject(JsonObjectBuilder builder, String name, List<JsonObject> values) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        Iterator<JsonObject> iterator = values.iterator();
        while (iterator.hasNext()) {
            arrayBuilder.add((JsonValue)iterator.next());
        }
        builder.add(name, arrayBuilder);
        return this;
    }

    private JWEBuilder<T, B> setJsonObject(JsonObjectBuilder builder, String name, JsonArray values) {
        builder.add(name, (JsonValue)values);
        return this;
    }
}

