/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.util.JsonUtil;

public class JWK {
    private JsonObject keyParameters;

    protected JWK(JsonObject keyParameters) {
        this.keyParameters = keyParameters;
    }

    public String getKeyType() {
        return this.getKeyParameter("kty");
    }

    public String getKeyUse() {
        return this.getKeyParameter("use");
    }

    public List<String> getKeyOperations() {
        return this.getKeyParameterValues("key_ops");
    }

    public String getKeyAlgorithm() {
        return this.getKeyParameter("alg");
    }

    public String getKeyIdentifier() {
        return this.getKeyParameter("kid");
    }

    public String getX509Url() {
        return this.getKeyParameter("x5u");
    }

    public List<String> getX509CertificateChain() {
        return this.getKeyParameterValues("x5c");
    }

    public String getX509SHA1CertificateThumbprint() {
        return this.getKeyParameter("x5t");
    }

    public String getX509SHA256CertificateThumbprint() {
        return this.getKeyParameter("x5t#S256");
    }

    public String getModulus() {
        return this.getKeyParameter("n");
    }

    public String getPublicExponent() {
        return this.getKeyParameter("e");
    }

    public String getPrivateExponent() {
        return this.getKeyParameter("d");
    }

    public String getPrimeP() {
        return this.getKeyParameter("p");
    }

    public String getPrimeQ() {
        return this.getKeyParameter("q");
    }

    public String getPrimeExponentP() {
        return this.getKeyParameter("dp");
    }

    public String getPrimeExponentQ() {
        return this.getKeyParameter("dq");
    }

    public String getCRTCoefficient() {
        return this.getKeyParameter("qi");
    }

    public String toString() {
        return this.getPlainkeyParameters();
    }

    private String getKeyParameter(String name) {
        return this.getValue(name, this.keyParameters);
    }

    public List<String> getKeyParameterValues(String name) {
        return this.getValues(name, this.keyParameters);
    }

    private String getPlainkeyParameters() {
        StringWriter keyParameterWriter = new StringWriter();
        Json.createWriter((Writer)keyParameterWriter).writeObject(this.keyParameters);
        return keyParameterWriter.getBuffer().toString();
    }

    private List<String> getValues(String name, JsonObject jsonObject) {
        JsonValue headerValue = (JsonValue)jsonObject.get((Object)name);
        ArrayList<String> values = new ArrayList<String>();
        if (headerValue != null) {
            if (JsonArray.class.isInstance(headerValue)) {
                JsonArray array = (JsonArray)headerValue;
                for (JsonValue value : array.getValuesAs(JsonValue.class)) {
                    values.add(this.getValue(value).toString());
                }
            } else {
                values.add(this.getValue(name, jsonObject).toString());
            }
        }
        return values;
    }

    private <R> R getValue(JsonValue value) {
        if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
            JsonArray array = (JsonArray)value;
            Iterator i$ = array.iterator();
            if (i$.hasNext()) {
                JsonValue jsonValue = (JsonValue)i$.next();
                return this.getValue(jsonValue);
            }
        } else {
            if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
                return (R)((JsonString)value).getString();
            }
            if (JsonValue.ValueType.NUMBER.equals((Object)value.getValueType())) {
                return (R)((JsonNumber)value).bigDecimalValue().toPlainString();
            }
            if (JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) || JsonValue.ValueType.FALSE.equals((Object)value.getValueType())) {
                return (R)Boolean.valueOf(value.toString());
            }
        }
        return null;
    }

    private String getValue(String name, JsonObject jsonObject) {
        JsonValue value = (JsonValue)jsonObject.get((Object)name);
        if (value != null) {
            if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
                JsonArray array = (JsonArray)value;
                Iterator i$ = array.iterator();
                if (i$.hasNext()) {
                    JsonValue jsonValue = (JsonValue)i$.next();
                    return (String)this.getValue(jsonValue);
                }
            } else {
                if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
                    return ((JsonString)value).getString();
                }
                if (JsonValue.ValueType.NUMBER.equals((Object)value.getValueType())) {
                    return ((JsonNumber)value).bigDecimalValue().toPlainString();
                }
                if (JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) || JsonValue.ValueType.FALSE.equals((Object)value.getValueType())) {
                    return value.toString();
                }
            }
        }
        return null;
    }

    public RSAPublicKey toRSAPublicKey() {
        if (this.getModulus() == null) {
            throw JsonMessages.MESSAGES.invalidNullArgument("Modulus");
        }
        if (this.getPublicExponent() == null) {
            throw JsonMessages.MESSAGES.invalidNullArgument("Public Exponent");
        }
        try {
            BigInteger modulus = new BigInteger(JsonUtil.b64Decode(this.getModulus()));
            BigInteger publicExponent = new BigInteger(JsonUtil.b64Decode(this.getPublicExponent()));
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, publicExponent);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)factory.generatePublic(spec);
        }
        catch (Exception e) {
            throw JsonMessages.MESSAGES.cryptoCouldNotParseKey(this.toString(), e);
        }
    }

    public JsonObject getJsonObject() {
        return this.keyParameters;
    }
}

