/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose.crypto;

import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import org.picketlink.json.jose.JWE;
import org.picketlink.json.jose.crypto.AES;
import org.picketlink.json.jose.crypto.AESCBC;
import org.picketlink.json.jose.crypto.AESGCM;
import org.picketlink.json.jose.crypto.AuthenticatedCipherText;
import org.picketlink.json.jose.crypto.DeflateUtils;
import org.picketlink.json.jose.crypto.RSA1_5;
import org.picketlink.json.jose.crypto.RSA_OAEP;
import org.picketlink.json.jose.crypto.RSA_OAEP_256;
import org.picketlink.json.util.JsonUtil;

public class JWEEncrypter {
    private final RSAPublicKey publicKey;

    public JWEEncrypter(RSAPublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public String encrypt(JWE jweHeader, byte[] bytes) {
        AuthenticatedCipherText authCipherText;
        byte[] iv;
        byte[] encryptedKey;
        String alg = jweHeader.getAlgorithm();
        String enc = jweHeader.getEncryptionAlgorithm();
        SecureRandom randomGen = new SecureRandom();
        SecretKey cek = AES.generateKey(Integer.parseInt(jweHeader.getCEKBitLength()), randomGen);
        if (alg.equals("RSA1_5")) {
            encryptedKey = RSA1_5.encryptCEK(this.publicKey, cek);
        } else if (alg.equals("RSA-OAEP")) {
            encryptedKey = RSA_OAEP.encryptCEK(this.publicKey, cek);
        } else if (alg.equals("RSA-OAEP-256")) {
            encryptedKey = RSA_OAEP_256.encryptCEK(this.publicKey, cek);
        } else {
            throw new RuntimeException("Unsupported JWE algorithm, must be RSA1_5, RSA-OAEP, or RSA-OAEP-256");
        }
        byte[] plainText = bytes;
        if (jweHeader.getCompressionAlgorithm().equals("DEF")) {
            try {
                plainText = DeflateUtils.compress(bytes);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to compress plainText");
            }
        }
        byte[] aad = JsonUtil.b64Encode(jweHeader.toString()).getBytes(Charset.forName("UTF-8"));
        if (enc.equals("A128CBC-HS256") || enc.equals("A192CBC-HS384") || enc.equals("A256CBC-HS512")) {
            iv = AESCBC.generateIV(randomGen);
            authCipherText = AESCBC.encryptAuthenticated(cek, iv, plainText, aad);
        } else if (enc.equals("A128GCM") || enc.equals("A192GCM") || enc.equals("A256GCM")) {
            iv = AESGCM.generateIV(randomGen);
            authCipherText = AESGCM.encrypt(cek, iv, plainText, aad);
        } else {
            throw new RuntimeException("Unsupported encryption method, must be A128CBC_HS256, A192CBC_HS384, A256CBC_HS512, A128GCM, A192GCM or A256GCM");
        }
        String serializedJWE = JsonUtil.b64Encode(jweHeader.toString()) + "." + JsonUtil.b64Encode(encryptedKey) + "." + JsonUtil.b64Encode(iv) + "." + JsonUtil.b64Encode(authCipherText.getCipherText()) + "." + JsonUtil.b64Encode(authCipherText.getAuthenticationTag());
        return serializedJWE;
    }
}

