/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.util.Base64;

public class JsonUtil {
    public static String b64Encode(String str) {
        try {
            return JsonUtil.b64Encode(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw JsonMessages.MESSAGES.failEncodeToken(e);
        }
    }

    public static String b64Encode(byte[] bytes) {
        String s = Base64.encodeBytes(bytes);
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public static byte[] b64Decode(String s) {
        s = s.replace('-', '+');
        s = s.replace('_', '/');
        switch (s.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = s + "==";
                break;
            }
            case 3: {
                s = s + "=";
                break;
            }
            default: {
                throw new RuntimeException("Illegal base64url string!");
            }
        }
        try {
            return Base64.decode(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean constantTimeAreEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result |= a[i] ^ b[i];
        }
        return result == 0;
    }

    public static String[] split(String s) throws ParseException {
        int dot1 = s.indexOf(".");
        if (dot1 == -1) {
            throw new ParseException("Invalid serialized plain/JWS/JWE object: Missing part delimiters", 0);
        }
        int dot2 = s.indexOf(".", dot1 + 1);
        if (dot2 == -1) {
            throw new ParseException("Invalid serialized plain/JWS/JWE object: Missing second delimiter", 0);
        }
        int dot3 = s.indexOf(".", dot2 + 1);
        if (dot3 == -1) {
            String[] parts = new String[]{new String(s.substring(0, dot1)), new String(s.substring(dot1 + 1, dot2)), new String(s.substring(dot2 + 1))};
            return parts;
        }
        int dot4 = s.indexOf(".", dot3 + 1);
        if (dot4 == -1) {
            throw new ParseException("Invalid serialized JWE object: Missing fourth delimiter", 0);
        }
        if (dot4 != -1 && s.indexOf(".", dot4 + 1) != -1) {
            throw new ParseException("Invalid serialized plain/JWS/JWE object: Too many part delimiters", 0);
        }
        String[] parts = new String[]{new String(s.substring(0, dot1)), new String(s.substring(dot1 + 1, dot2)), new String(s.substring(dot2 + 1, dot3)), new String(s.substring(dot3 + 1, dot4)), new String(s.substring(dot4 + 1))};
        return parts;
    }
}

