/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose.crypto;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.SecretKey;
import org.picketlink.json.jose.JWE;
import org.picketlink.json.jose.crypto.AES;
import org.picketlink.json.jose.crypto.AESCBC;
import org.picketlink.json.jose.crypto.AESGCM;
import org.picketlink.json.jose.crypto.DeflateUtils;
import org.picketlink.json.jose.crypto.RSA1_5;
import org.picketlink.json.jose.crypto.RSA_OAEP;
import org.picketlink.json.jose.crypto.RSA_OAEP_256;
import org.picketlink.json.util.Base64Util;

public class JWEDecrypter {
    private final RSAPrivateKey privateKey;

    public JWEDecrypter(RSAPrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private RSA key must not be null");
        }
        this.privateKey = privateKey;
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public byte[] decrypt(JWE jweHeader, String encryptedKey, String iv, String cipherText, String authTag) {
        byte[] plainText;
        SecretKey cek;
        if (encryptedKey == null) {
            throw new RuntimeException("The encrypted key must not be null");
        }
        if (iv == null) {
            throw new RuntimeException("The initialization vector (IV) must not be null");
        }
        if (authTag == null) {
            throw new RuntimeException("The authentication tag must not be null");
        }
        String alg = jweHeader.getAlgorithm();
        if (alg.equals("RSA1_5")) {
            int keyLength = Integer.parseInt(jweHeader.getCEKBitLength());
            SecureRandom randomGen = new SecureRandom();
            SecretKey randomCEK = AES.generateKey(keyLength, randomGen);
            try {
                cek = RSA1_5.decryptCEK(this.privateKey, Base64Util.b64Decode(encryptedKey), keyLength);
                if (cek == null) {
                    cek = randomCEK;
                }
            }
            catch (Exception e) {
                cek = randomCEK;
            }
        } else if (alg.equals("RSA-OAEP")) {
            cek = RSA_OAEP.decryptCEK(this.privateKey, Base64Util.b64Decode(encryptedKey));
        } else if (alg.equals("RSA-OAEP-256")) {
            cek = RSA_OAEP_256.decryptCEK(this.privateKey, Base64Util.b64Decode(encryptedKey));
        } else {
            throw new RuntimeException("Unsupported JWE algorithm, must be RSA1_5 or RSA_OAEP");
        }
        byte[] aad = Base64Util.b64Encode(jweHeader.toString()).getBytes(Charset.forName("UTF-8"));
        String enc = jweHeader.getEncryptionAlgorithm();
        if (enc.equals("A128CBC-HS256") || enc.equals("A192CBC-HS384") || enc.equals("A256CBC-HS512")) {
            plainText = AESCBC.decryptAuthenticated(cek, Base64Util.b64Decode(iv), Base64Util.b64Decode(cipherText), aad, Base64Util.b64Decode(authTag));
        } else if (enc.equals("A128GCM") || enc.equals("A192GCM") || enc.equals("A256GCM")) {
            plainText = AESGCM.decrypt(cek, Base64Util.b64Decode(iv), Base64Util.b64Decode(cipherText), aad, Base64Util.b64Decode(authTag));
        } else {
            throw new RuntimeException("Unsupported encryption method, must be A128CBC_HS256, A192CBC_HS384, A256CBC_HS512, A128GCM, A192GCM or A256GCM");
        }
        try {
            return DeflateUtils.decompress(plainText);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decompress plainText");
        }
    }
}

