/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HMAC {
    public static byte[] compute(String alg, byte[] secret, byte[] message) {
        return HMAC.compute(new SecretKeySpec(secret, alg), message);
    }

    public static byte[] compute(SecretKey secretKey, byte[] message) {
        Mac mac;
        try {
            mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unsupported HMAC algorithm: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Invalid HMAC key: " + e.getMessage(), e);
        }
        mac.update(message);
        return mac.doFinal();
    }
}

