/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonUtil {
    public static List<String> getValues(String name, JsonObject jsonObject) {
        JsonValue headerValue = (JsonValue)jsonObject.get((Object)name);
        ArrayList<String> values = new ArrayList<String>();
        if (headerValue != null) {
            if (JsonArray.class.isInstance(headerValue)) {
                JsonArray array = (JsonArray)headerValue;
                for (JsonValue aud : array.getValuesAs(JsonValue.class)) {
                    values.add(JsonUtil.getValue(aud).toString());
                }
            } else {
                values.add(JsonUtil.getValue(name, jsonObject).toString());
            }
        }
        return values;
    }

    public static <R> R getValue(JsonValue value) {
        if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
            JsonArray array = (JsonArray)value;
            Iterator i$ = array.iterator();
            if (i$.hasNext()) {
                JsonValue jsonValue = (JsonValue)i$.next();
                return JsonUtil.getValue(jsonValue);
            }
        } else {
            if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
                return (R)((JsonString)value).getString();
            }
            if (JsonValue.ValueType.NUMBER.equals((Object)value.getValueType())) {
                return (R)((JsonNumber)value).bigDecimalValue().toPlainString();
            }
            if (JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) || JsonValue.ValueType.FALSE.equals((Object)value.getValueType())) {
                return (R)Boolean.valueOf(value.toString());
            }
        }
        return null;
    }

    public static String getValue(String name, JsonObject jsonObject) {
        JsonValue value = (JsonValue)jsonObject.get((Object)name);
        if (value != null) {
            if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
                JsonArray array = (JsonArray)value;
                Iterator i$ = array.iterator();
                if (i$.hasNext()) {
                    JsonValue jsonValue = (JsonValue)i$.next();
                    return (String)JsonUtil.getValue(jsonValue);
                }
            } else {
                if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
                    return ((JsonString)value).getString();
                }
                if (JsonValue.ValueType.NUMBER.equals((Object)value.getValueType())) {
                    return ((JsonNumber)value).bigDecimalValue().toPlainString();
                }
                if (JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) || JsonValue.ValueType.FALSE.equals((Object)value.getValueType())) {
                    return value.toString();
                }
            }
        }
        return null;
    }
}

