/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.util.Base64Util;
import org.picketlink.json.util.JsonUtil;

public class JWK {
    private JsonObject keyParameters;

    protected JWK(JsonObject keyParameters) {
        this.keyParameters = keyParameters;
    }

    public String encode() {
        return this.format(Base64Util.b64Encode(this.getPlainkeyParameters())).toString();
    }

    public String getKeyType() {
        return this.getKeyParameter("kty");
    }

    public String getKeyUse() {
        return this.getKeyParameter("use");
    }

    public List<String> getKeyOperations() {
        return this.getKeyParameterValues("key_ops");
    }

    public String getKeyAlgorithm() {
        return this.getKeyParameter("alg");
    }

    public String getKeyIdentifier() {
        return this.getKeyParameter("kid");
    }

    public String getX509Url() {
        return this.getKeyParameter("x5u");
    }

    public List<String> getX509CertificateChain() {
        return this.getKeyParameterValues("x5c");
    }

    public String getX509SHA1CertificateThumbprint() {
        return this.getKeyParameter("x5t");
    }

    public String getX509SHA256CertificateThumbprint() {
        return this.getKeyParameter("x5t#S256");
    }

    public String getModulus() {
        return this.getKeyParameter("n");
    }

    public String getPublicExponent() {
        return this.getKeyParameter("e");
    }

    public String getPrivateExponent() {
        return this.getKeyParameter("d");
    }

    public String getPrimeP() {
        return this.getKeyParameter("p");
    }

    public String getPrimeQ() {
        return this.getKeyParameter("q");
    }

    public String getPrimeExponentP() {
        return this.getKeyParameter("dp");
    }

    public String getPrimeExponentQ() {
        return this.getKeyParameter("dq");
    }

    public String getCRTCoefficient() {
        return this.getKeyParameter("qi");
    }

    public String toString() {
        return this.getPlainkeyParameters();
    }

    private String getKeyParameter(String name) {
        return JsonUtil.getValue(name, this.keyParameters);
    }

    public List<String> getKeyParameterValues(String name) {
        return JsonUtil.getValues(name, this.keyParameters);
    }

    private StringBuilder format(String keyParameters) {
        return new StringBuilder().append(keyParameters);
    }

    private String getPlainkeyParameters() {
        StringWriter keyParameterWriter = new StringWriter();
        Json.createWriter((Writer)keyParameterWriter).writeObject(this.keyParameters);
        return keyParameterWriter.getBuffer().toString();
    }

    public RSAPublicKey toRSAPublicKey() {
        if (this.getModulus() == null) {
            throw JsonMessages.MESSAGES.invalidNullArgument("Modulus");
        }
        if (this.getPublicExponent() == null) {
            throw JsonMessages.MESSAGES.invalidNullArgument("Public Exponent");
        }
        try {
            BigInteger modulus = new BigInteger(Base64Util.b64Decode(this.getModulus()));
            BigInteger publicExponent = new BigInteger(Base64Util.b64Decode(this.getPublicExponent()));
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, publicExponent);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)factory.generatePublic(spec);
        }
        catch (Exception e) {
            throw JsonMessages.MESSAGES.cryptoCouldNotParseKey(this.toString(), e);
        }
    }

    public JsonObject getJsonObject() {
        return this.keyParameters;
    }
}

