/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.contexts.SessionContext;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.util.Base64;
import org.jboss.seam.web.AbstractFilter;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.federation.web.util.HTTPRedirectUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.seam.federation.RelayStates;
import org.picketlink.identity.seam.federation.SamlIdentity;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.picketlink.identity.seam.federation.samlAuthenticationFilter")
@BypassInterceptors
@Filter(within={"org.jboss.seam.web.exceptionFilter"})
public class SamlAuthenticationFilter
extends AbstractFilter {
    private String identityProviderURL;
    private String singleSignOnServiceURL;
    private String keyStoreURL;
    private String keyStorePass;
    private String idpCertificateAlias;
    private PublicKey publicKeyOfIDP;
    private Binding binding = Binding.HTTP_Post;
    private boolean signatureRequired = true;
    @Logger
    private Log log;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.signatureRequired) {
            this.publicKeyOfIDP = this.getPublicKeyOfIDP();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (request.getParameter("SAMLResponse") != null) {
            AuthenticatedUser user = this.processIDPResponse((HttpServletRequest)request);
            if (user != null) {
                this.loginUser(httpRequest, httpResponse, user);
            }
        } else if (request.getParameter("newRelayState") != null) {
            this.sendRequestToIDP(httpRequest, httpResponse);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void loginUser(HttpServletRequest httpRequest, HttpServletResponse httpResponse, AuthenticatedUser user) throws ServletException, IOException {
        httpRequest.getSession();
        SessionContext ctx = new SessionContext((Map)new ServletRequestSessionMap(httpRequest));
        Credentials credentials = (Credentials)ctx.get(Credentials.class);
        Identity identity = (Identity)ctx.get(Identity.class);
        if (identity.isLoggedIn()) {
            throw new RuntimeException("User is already logged in.");
        }
        credentials.setPassword("");
        this.authenticate(httpRequest, user);
        RelayStates relayStates = (RelayStates)ctx.get(RelayStates.class);
        String relayState = httpRequest.getParameter("RelayState");
        if (relayState == null) {
            throw new RuntimeException("RelayState parameter is missing");
        }
        relayStates.restoreState(Integer.parseInt(relayState), httpResponse);
    }

    private void authenticate(HttpServletRequest request, final AuthenticatedUser user) throws ServletException, IOException {
        new ContextualHttpServletRequest(request){

            public void process() throws ServletException, IOException, LoginException {
                SamlIdentity identity = (SamlIdentity)Identity.instance();
                identity.getCredentials().setUsername(user.userName);
                identity.setAttributes(user.attributes);
                identity.authenticate();
            }
        }.run();
    }

    private AuthenticatedUser processIDPResponse(HttpServletRequest request) {
        ResponseType responseType;
        String samlResponse = request.getParameter("SAMLResponse");
        byte[] base64DecodedResponse = Base64.decode((String)samlResponse);
        ByteArrayInputStream is = new ByteArrayInputStream(base64DecodedResponse);
        SAML2Response saml2Response = new SAML2Response();
        try {
            responseType = saml2Response.getResponseType((InputStream)is);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        if (this.signatureRequired && !this.validateSignature(saml2Response.getSamlDocumentHolder())) {
            this.log.error((Object)"Invalid signature", new Object[0]);
            throw new RuntimeException("Validity Checks failed");
        }
        StatusType statusType = responseType.getStatus();
        if (statusType == null) {
            throw new RuntimeException("Status Type from the IDP is null");
        }
        String statusValue = statusType.getStatusCode().getValue();
        if (!JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusValue)) {
            throw new RuntimeException("IDP forbid the user");
        }
        List assertions = responseType.getAssertionOrEncryptedAssertion();
        if (assertions.size() == 0) {
            throw new RuntimeException("IDP response does not contain assertions");
        }
        AuthenticatedUser user = null;
        for (Object assertion : responseType.getAssertionOrEncryptedAssertion()) {
            if (assertion instanceof AssertionType) {
                AuthenticatedUser userInAssertion = this.handleAssertion((AssertionType)assertion);
                if (user == null) {
                    user = userInAssertion;
                    continue;
                }
                this.log.warn((Object)"Multiple authenticated users found in assertions. Using the first one.", new Object[0]);
                continue;
            }
            this.log.warn((Object)"Encountered encrypted assertion. Skipping it because decryption is not yet supported.", new Object[0]);
        }
        if (user == null) {
            this.log.warn((Object)"No authenticated users found in assertions.", new Object[0]);
        }
        return user;
    }

    private AuthenticatedUser handleAssertion(AssertionType assertion) {
        try {
            if (AssertionUtil.hasExpired((AssertionType)assertion)) {
                this.log.warn((Object)"Received assertion will not be processed because it has expired.", new Object[0]);
                return null;
            }
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        AuthenticatedUser user = null;
        for (JAXBElement contentElement : assertion.getSubject().getContent()) {
            if (!contentElement.getName().getLocalPart().equals("NameID")) continue;
            user = new AuthenticatedUser();
            user.userName = ((NameIDType)contentElement.getValue()).getValue();
        }
        if (user != null) {
            for (StatementAbstractType statement : assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
                if (!(statement instanceof AttributeStatementType)) continue;
                AttributeStatementType attributeStatement = (AttributeStatementType)statement;
                for (Object object : attributeStatement.getAttributeOrEncryptedAttribute()) {
                    if (object instanceof AttributeType) {
                        AttributeType attr = (AttributeType)object;
                        List<String> values = user.attributes.get(attr.getName());
                        if (values == null) {
                            values = new LinkedList<String>();
                        }
                        for (Object value : attr.getAttributeValue()) {
                            values.add((String)value);
                        }
                        user.attributes.put(attr.getName(), values);
                        continue;
                    }
                    this.log.warn((Object)"Encrypted attributes are not supported. Ignoring the attribute.", new Object[0]);
                }
            }
        } else {
            this.log.warn((Object)"Subject is not specified using the NameID element. Ignoring the assertion.", new Object[0]);
        }
        return user;
    }

    private boolean validateSignature(SAMLDocumentHolder documentHolder) {
        try {
            Document samlDocument = documentHolder.getSamlDocument();
            return XMLSignatureUtil.validate((Document)samlDocument, (Key)this.publicKeyOfIDP);
        }
        catch (MarshalException e) {
            throw new RuntimeException(e);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private PublicKey getPublicKeyOfIDP() {
        String classPathPrefix = "classpath:";
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream keyStoreStream = this.keyStoreURL.startsWith("classpath:") ? ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.keyStoreURL.substring("classpath:".length())) : new URL(this.keyStoreURL).openStream();
            keyStore.load(keyStoreStream, this.keyStorePass != null ? this.keyStorePass.toCharArray() : null);
            return keyStore.getCertificate(this.idpCertificateAlias).getPublicKey();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendRequestToIDP(HttpServletRequest request, HttpServletResponse response) {
        Integer relayState = Integer.parseInt(request.getParameter("newRelayState"));
        try {
            String serviceProviderURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/SamlAuthenticationFilter.seam";
            AuthnRequestType authnRequest = this.createSAMLRequest(serviceProviderURL, this.identityProviderURL);
            SAML2Request saml2Request = new SAML2Request();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            saml2Request.marshall((RequestAbstractType)authnRequest, (OutputStream)baos);
            String samlMessage = PostBindingUtil.base64Encode((String)baos.toString());
            if (this.binding == Binding.HTTP_Redirect) {
                String deflatedRequest = RedirectBindingUtil.deflateBase64URLEncode((byte[])baos.toByteArray());
                StringBuilder sb = new StringBuilder();
                sb.append("?SAMLRequest=").append(deflatedRequest);
                sb.append("&RelayState=").append(relayState);
                HTTPRedirectUtil.sendRedirectForRequestor((String)(this.singleSignOnServiceURL + sb.toString()), (HttpServletResponse)response);
            } else {
                DestinationInfoHolder destinationInfoHolder = new DestinationInfoHolder(this.singleSignOnServiceURL, samlMessage, Integer.toString(relayState));
                PostBindingUtil.sendPost((DestinationInfoHolder)destinationInfoHolder, (HttpServletResponse)response, (boolean)true);
            }
        }
        catch (ConfigurationException e) {
            throw new RuntimeException();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AuthnRequestType createSAMLRequest(String serviceURL, String identityURL) throws ConfigurationException {
        if (serviceURL == null) {
            throw new IllegalArgumentException("serviceURL is null");
        }
        if (identityURL == null) {
            throw new IllegalArgumentException("identityURL is null");
        }
        SAML2Request saml2Request = new SAML2Request();
        String id = IDGenerator.create((String)"ID_");
        return saml2Request.createAuthnRequestType(id, serviceURL, identityURL, serviceURL);
    }

    protected static class AuthenticatedUser {
        String userName;
        Map<String, List<String>> attributes = new HashMap<String, List<String>>();

        protected AuthenticatedUser() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Binding {
        HTTP_Redirect,
        HTTP_Post;

    }
}

