/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.log.Log;

@Scope(value=ScopeType.SESSION)
@Name(value="org.picketlink.identity.seam.federation.relayStates")
@Startup
public class RelayStates {
    private Map<Integer, String> states = new HashMap<Integer, String>();
    private int nextIndex = 0;
    @Logger
    private Log log;

    public int saveState(HttpServletRequest request) {
        int index = this.nextIndex++;
        StringBuffer requestURL = request.getRequestURL();
        if (request.getQueryString() != null) {
            requestURL.append("?" + request.getQueryString());
        }
        this.states.put(index, requestURL.toString());
        return index;
    }

    public void restoreState(int index, HttpServletResponse response) {
        String requestURL = this.states.get(index);
        if (requestURL == null) {
            throw new RuntimeException("Couldn't find URL for relayState " + index + " in the session");
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Redirecting to {0}", new Object[]{requestURL});
            }
            response.sendRedirect(requestURL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.states.remove(index);
    }
}

