/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.IOException;
import java.io.OutputStream;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.web.AbstractFilter;
import org.picketlink.identity.seam.federation.ExternalAuthenticationService;
import org.picketlink.identity.seam.federation.InvalidRequestException;
import org.picketlink.identity.seam.federation.OpenIdSingleLoginReceiver;
import org.picketlink.identity.seam.federation.OpenIdSingleLoginSender;
import org.picketlink.identity.seam.federation.SamlMessageReceiver;
import org.picketlink.identity.seam.federation.SamlMetaDataProvider;
import org.picketlink.identity.seam.federation.SamlPrincipal;
import org.picketlink.identity.seam.federation.SamlProfile;
import org.picketlink.identity.seam.federation.SamlSingleLogoutSender;
import org.picketlink.identity.seam.federation.SamlSingleSignOnSender;
import org.picketlink.identity.seam.federation.configuration.Configuration;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.picketlink.identity.seam.federation.externalAuthenticationFilter")
@BypassInterceptors
@Filter(within={"org.jboss.seam.web.exceptionFilter"})
@Install(value=true)
public class ExternalAuthenticationFilter
extends AbstractFilter {
    public static final String IDP_ENTITY_ID_PARAMETER = "idpEntityId";
    public static final String RETURN_URL_PARAMETER = "returnUrl";
    public static final String OPEN_ID_PARAMETER = "openId";
    @Logger
    private Log log;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        Configuration.instance().setContextRoot(filterConfig.getServletContext().getContextPath());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests");
        }
        final HttpServletRequest httpRequest = (HttpServletRequest)request;
        final HttpServletResponse httpResponse = (HttpServletResponse)response;
        final ExternalAuthenticationService service = this.determineService(httpRequest);
        if (service != null) {
            try {
                new ContextualHttpServletRequest(httpRequest){

                    public void process() throws ServletException, IOException, LoginException {
                        block2: {
                            try {
                                ExternalAuthenticationFilter.this.doFilter(httpRequest, httpResponse, service);
                            }
                            catch (InvalidRequestException e) {
                                httpResponse.setStatus(400);
                                if (!ExternalAuthenticationFilter.this.log.isInfoEnabled()) break block2;
                                ExternalAuthenticationFilter.this.log.info((Object)"Bad request received from {0} ({1})", (Throwable)e.getCause(), new Object[]{httpRequest.getRemoteHost(), e.getDescription()});
                            }
                        }
                    }
                }.run();
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    private void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ExternalAuthenticationService service) throws InvalidRequestException, IOException, ServletException {
        SamlMessageReceiver samlMessageReceiver = (SamlMessageReceiver)Component.getInstance(SamlMessageReceiver.class);
        OpenIdSingleLoginReceiver openIdSingleLoginReceiver = (OpenIdSingleLoginReceiver)Component.getInstance(OpenIdSingleLoginReceiver.class);
        switch (service) {
            case OPEN_ID_SERVICE: {
                openIdSingleLoginReceiver.handleIncomingMessage(httpRequest, httpResponse);
                break;
            }
            case SAML_SINGLE_LOGOUT_SERVICE: {
                samlMessageReceiver.handleIncomingSamlMessage(SamlProfile.SINGLE_LOGOUT, httpRequest, httpResponse);
                break;
            }
            case SAML_ASSERTION_CONSUMER_SERVICE: {
                samlMessageReceiver.handleIncomingSamlMessage(SamlProfile.SINGLE_SIGN_ON, httpRequest, httpResponse);
                break;
            }
            case AUTHENTICATION_SERVICE: {
                String returnUrl = httpRequest.getParameter(RETURN_URL_PARAMETER);
                String providerName = httpRequest.getParameter(IDP_ENTITY_ID_PARAMETER);
                if (providerName != null) {
                    SamlIdentityProvider identityProvider = Configuration.instance().getServiceProvider().getSamlConfiguration().getSamlIdentityProviderByEntityId(providerName);
                    if (identityProvider instanceof SamlIdentityProvider) {
                        SamlSingleSignOnSender samlSingleSignOnSender = (SamlSingleSignOnSender)Component.getInstance(SamlSingleSignOnSender.class);
                        samlSingleSignOnSender.sendAuthenticationRequestToIDP(httpRequest, httpResponse, identityProvider, returnUrl);
                        break;
                    }
                    throw new RuntimeException("Only SAML identity providers are supported in this version");
                }
                OpenIdSingleLoginSender openIdSingleLoginSender = (OpenIdSingleLoginSender)Component.getInstance(OpenIdSingleLoginSender.class);
                String openId = httpRequest.getParameter(OPEN_ID_PARAMETER);
                openIdSingleLoginSender.sendAuthRequest(openId, returnUrl, httpResponse);
                break;
            }
            case LOGOUT_SERVICE: {
                Identity identity = (Identity)Component.getInstance(Identity.class);
                if (!identity.isLoggedIn()) {
                    throw new RuntimeException("User not logged in.");
                }
                SamlPrincipal principal = (SamlPrincipal)identity.getPrincipal();
                SamlIdentityProvider idp = principal.getIdentityProvider();
                if (!(idp instanceof SamlIdentityProvider)) {
                    throw new RuntimeException("Only SAML identity providers are supported in this version");
                }
                SamlSingleLogoutSender samlSingleLogoutSender = (SamlSingleLogoutSender)Component.getInstance(SamlSingleLogoutSender.class);
                samlSingleLogoutSender.sendSingleLogoutRequestToIDP(httpRequest, httpResponse, identity);
                break;
            }
            case SAML_META_DATA_SERVICE: {
                SamlMetaDataProvider samlMetaDataProvider = (SamlMetaDataProvider)Component.getInstance(SamlMetaDataProvider.class);
                samlMetaDataProvider.writeMetaData((OutputStream)httpResponse.getOutputStream());
                httpResponse.setCharacterEncoding("UTF-8");
                httpResponse.setContentType("application/xml");
                httpResponse.flushBuffer();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported service " + (Object)((Object)service));
            }
        }
    }

    private ExternalAuthenticationService determineService(HttpServletRequest httpRequest) {
        String path = httpRequest.getRequestURI().replace(".seam", "");
        for (ExternalAuthenticationService service : ExternalAuthenticationService.values()) {
            if (!path.endsWith("/" + service.getName())) continue;
            return service;
        }
        return null;
    }
}

