/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.security.Identity;
import org.picketlink.identity.seam.federation.ExternalAuthenticationService;
import org.picketlink.identity.seam.federation.SeamSamlPrincipal;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.picketlink.identity.seam.federation.externalAuthenticator")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
@Scope(value=ScopeType.PAGE)
public class ExternalAuthenticator {
    private String returnUrl;
    private String openId;
    @In
    private ServiceProvider serviceProvider;
    @In
    private Identity identity;

    public void samlSignOn(String idpEntityId) {
        if (this.serviceProvider.getSamlConfiguration() == null) {
            throw new RuntimeException("SAML is not configured.");
        }
        SamlIdentityProvider idp = this.serviceProvider.getSamlConfiguration().getSamlIdentityProviderByEntityId(idpEntityId);
        if (idp == null) {
            throw new RuntimeException("Identity provider " + idpEntityId + " not found");
        }
        String authenticationServiceURL = this.serviceProvider.getServiceURL(ExternalAuthenticationService.AUTHENTICATION_SERVICE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("idpEntityId", idpEntityId);
        params.put("returnUrl", this.returnUrl);
        this.redirect(authenticationServiceURL, params);
    }

    public void openIdSignOn() {
        this.openIdSignOn(this.openId);
    }

    public void openIdSignOn(String openId) {
        if (this.serviceProvider.getOpenIdConfiguration() == null) {
            throw new RuntimeException("OpenID is not configured.");
        }
        String authenticationServiceURL = this.serviceProvider.getServiceURL(ExternalAuthenticationService.AUTHENTICATION_SERVICE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("returnUrl", this.returnUrl);
        params.put("openId", openId);
        this.redirect(authenticationServiceURL, params);
    }

    public void singleLogout() {
        if (!this.identity.isLoggedIn()) {
            throw new RuntimeException("Not logged in");
        }
        if (!(this.identity.getPrincipal() instanceof SeamSamlPrincipal)) {
            throw new RuntimeException("Single logout is only supported for SAML");
        }
        String logoutServiceURL = this.serviceProvider.getServiceURL(ExternalAuthenticationService.LOGOUT_SERVICE);
        this.redirect(logoutServiceURL, null);
    }

    private void redirect(String urlBase, Map<String, String> params) {
        StringBuilder url = new StringBuilder();
        url.append(urlBase);
        if (params != null && params.size() > 0) {
            url.append("?");
            boolean first = true;
            for (Map.Entry<String, String> paramEntry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    url.append("&");
                }
                url.append(paramEntry.getKey());
                url.append("=");
                try {
                    String paramValue = paramEntry.getValue();
                    if (paramValue == null || paramValue == "") {
                        throw new RuntimeException("Param Key:" + paramEntry.getKey() + " has value that is null");
                    }
                    url.append(URLEncoder.encode(paramValue, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        FacesManager.instance().redirectToExternalURL(url.toString());
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getOpenId() {
        return this.openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }
}

