/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.auth;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.social.auth.SecurityActions;
import org.picketlink.social.facebook.FacebookProcessor;
import org.picketlink.social.openid.auth.OpenIDProcessor;

public class ExternalAuthenticator
extends FormAuthenticator {
    protected static Logger log = Logger.getLogger(ExternalAuthenticator.class);
    protected boolean trace = log.isTraceEnabled();
    public static final String AUTH_TYPE = "authType";
    protected FacebookProcessor facebookProcessor;
    protected OpenIDProcessor openidProcessor;
    protected String returnURL;
    protected String clientID;
    protected String clientSecret;
    protected String facebookScope = "email";
    private String requiredAttributes = "name,email,ax_firstName,ax_lastName,ax_fullName,ax_email";
    private String optionalAttributes = null;
    protected boolean saveRestoreRequest = true;
    private Method theSuperRegisterMethod = null;
    protected List<String> roles = new ArrayList<String>();

    public void setRoleString(String roleStr) {
        if (roleStr == null) {
            throw new RuntimeException("Role String is null in configuration");
        }
        StringTokenizer st = new StringTokenizer(StringUtil.getSystemPropertyAsString((String)roleStr), ",");
        while (st.hasMoreElements()) {
            this.roles.add(st.nextToken());
        }
    }

    public void setSaveRestoreRequest(boolean saveRestoreRequest) {
        this.saveRestoreRequest = saveRestoreRequest;
    }

    public void setReturnURL(String returnURL) {
        this.returnURL = StringUtil.getSystemPropertyAsString((String)returnURL);
    }

    public void setClientID(String clientID) {
        this.clientID = StringUtil.getSystemPropertyAsString((String)clientID);
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = StringUtil.getSystemPropertyAsString((String)clientSecret);
    }

    public void setFacebookScope(String facebookScope) {
        this.facebookScope = StringUtil.getSystemPropertyAsString((String)facebookScope);
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response, LoginConfig loginConfig) throws IOException {
        if (!(request instanceof Request)) {
            throw new IOException("Not of type Catalina request");
        }
        if (!(response instanceof Response)) {
            throw new IOException("Not of type Catalina response");
        }
        return this.authenticate((Request)request, (Response)response, loginConfig);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (response instanceof Response) {
            Response catalinaResponse = (Response)response;
            return this.authenticate(request, catalinaResponse, config);
        }
        throw new RuntimeException("Wrong type of response:" + response);
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        if (this.trace) {
            log.trace((Object)"authenticate");
        }
        if (this.facebookProcessor == null) {
            this.facebookProcessor = new FacebookProcessor(this.clientID, this.clientSecret, this.facebookScope, this.returnURL, this.roles);
        }
        if (this.openidProcessor == null) {
            this.openidProcessor = new OpenIDProcessor(this.returnURL, this.requiredAttributes, this.optionalAttributes);
        }
        HttpSession session = request.getSession();
        String authType = request.getParameter(AUTH_TYPE);
        if (authType != null && authType.length() > 0) {
            session.setAttribute(AUTH_TYPE, (Object)authType);
        }
        if (authType == null || authType.length() == 0) {
            authType = (String)session.getAttribute(AUTH_TYPE);
        }
        if (authType == null) {
            authType = AUTH_PROVIDERS.FACEBOOK.name();
        }
        if (authType != null && authType.equals(AUTH_PROVIDERS.FACEBOOK.name())) {
            return this.processFacebook(request, response);
        }
        return this.processOpenID(request, response);
    }

    protected boolean processFacebook(Request request, Response response) throws IOException {
        HttpSession session = request.getSession();
        String state = (String)session.getAttribute("STATE");
        if (this.trace) {
            log.trace((Object)("state=" + state));
        }
        if (STATES.FINISH.name().equals(state)) {
            Principal principal = request.getPrincipal();
            if (principal == null) {
                principal = this.facebookProcessor.getPrincipal(request, response, this.context.getRealm());
            }
            if (principal == null) {
                response.sendError(403);
                return false;
            }
            return this.dealWithFacebookPrincipal(request, response, principal);
        }
        if (state == null || state.isEmpty()) {
            if (this.saveRestoreRequest) {
                this.saveRequest(request, request.getSessionInternal());
            }
            return this.facebookProcessor.initialInteraction(request, response);
        }
        if (state.equals(STATES.AUTH.name())) {
            return this.facebookProcessor.handleAuthStage((HttpServletRequest)request, (HttpServletResponse)response);
        }
        if (state.equals(STATES.AUTHZ.name())) {
            Principal principal = this.facebookProcessor.getPrincipal(request, response, this.context.getRealm());
            if (principal == null) {
                log.error((Object)"Principal was null. Maybe login modules need to be configured properly. Or user chose no data");
                response.sendError(403);
                return false;
            }
            return this.dealWithFacebookPrincipal(request, response, principal);
        }
        return false;
    }

    protected boolean processOpenID(Request request, Response response) throws IOException {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null) {
            if (this.trace) {
                log.trace((Object)("Logged in as:" + userPrincipal));
            }
            return true;
        }
        if (!this.openidProcessor.isInitialized()) {
            try {
                this.openidProcessor.initialize(this.roles);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HttpSession httpSession = request.getSession();
        String state = (String)httpSession.getAttribute("STATE");
        if (this.trace) {
            log.trace((Object)("state=" + state));
        }
        if (STATES.FINISH.name().equals(state)) {
            httpSession.setAttribute("STATE", (Object)STATES.AUTH.name());
            return this.openidProcessor.prepareAndSendAuthRequest(request, response);
        }
        if (state == null || state.isEmpty()) {
            return this.openidProcessor.prepareAndSendAuthRequest(request, response);
        }
        if (state.equals(STATES.AUTH.name())) {
            Principal principal = this.openidProcessor.processIncomingAuthResult(request, response, this.context.getRealm());
            if (principal == null) {
                log.error((Object)"Principal was null. Maybe login modules need to be configured properly. Or user chose no data");
                return false;
            }
            return this.dealWithOpenIDPrincipal(request, response, principal);
        }
        return false;
    }

    protected void registerWithAuthenticatorBase(Request request, Response response, Principal principal, String userName) {
        block5: {
            try {
                this.register(request, response, principal, "FORM", userName, "");
            }
            catch (NoSuchMethodError nse) {
                if (this.theSuperRegisterMethod == null) {
                    Class[] args = new Class[]{Request.class, HttpServletResponse.class, Principal.class, String.class, String.class, String.class};
                    Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
                    this.theSuperRegisterMethod = SecurityActions.getMethod(superClass, "register", args);
                }
                if (this.theSuperRegisterMethod == null) break block5;
                Object[] objectArgs = new Object[]{request, response.getResponse(), principal, "FORM", userName, FacebookProcessor.EMPTY_PASSWORD};
                try {
                    this.theSuperRegisterMethod.invoke((Object)this, objectArgs);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to register:", (Throwable)e);
                }
            }
        }
    }

    private boolean dealWithFacebookPrincipal(Request request, Response response, Principal principal) throws IOException {
        String userName = principal.getName();
        request.getSessionInternal().setNote("org.apache.catalina.session.USERNAME", (Object)userName);
        request.getSessionInternal().setNote("org.apache.catalina.session.PASSWORD", (Object)"");
        request.setUserPrincipal(principal);
        if (this.saveRestoreRequest) {
            this.restoreRequest(request, request.getSessionInternal());
        }
        this.registerWithAuthenticatorBase(request, response, principal, userName);
        request.getSession().setAttribute("STATE", (Object)STATES.FINISH.name());
        return true;
    }

    private boolean dealWithOpenIDPrincipal(Request request, Response response, Principal principal) throws IOException {
        HttpSession httpSession = request.getSession();
        String principalName = principal.getName();
        request.getSessionInternal().setNote("org.apache.catalina.session.USERNAME", (Object)principalName);
        request.getSessionInternal().setNote("org.apache.catalina.session.PASSWORD", (Object)"");
        request.setUserPrincipal(principal);
        if (this.saveRestoreRequest) {
            this.restoreRequest(request, request.getSessionInternal());
        }
        if (this.trace) {
            log.trace((Object)("Logged in as:" + principal));
        }
        this.registerWithAuthenticatorBase(request, response, principal, principalName);
        httpSession.setAttribute("STATE", (Object)STATES.FINISH.name());
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum STATES {
        AUTH,
        AUTHZ,
        FINISH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AUTH_PROVIDERS {
        FACEBOOK,
        OPENID;

    }
}

