/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.reg;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.picketlink.social.facebook.FacebookPrincipal;
import org.picketlink.social.openid.OpenIdPrincipal;
import org.picketlink.social.reg.UserRegistration;

public class RegistrationValve
extends ValveBase {
    public void invoke(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!(request instanceof Request)) {
            throw new IOException("Not of type Catalina request");
        }
        if (!(response instanceof Response)) {
            throw new IOException("Not of type Catalina response");
        }
        this.invoke((Request)request, (Response)response);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Principal principal = (Principal)session.getAttribute("PRINCIPAL");
        if (principal != null) {
            UserRegistration user = null;
            if (principal instanceof OpenIdPrincipal) {
                user = this.processOpenIDPrincipal((OpenIdPrincipal)principal);
            } else if (principal instanceof FacebookPrincipal) {
                user = this.processFacebookPrincipal((FacebookPrincipal)principal);
            } else {
                throw new ServletException("Unknown principal type:" + principal);
            }
            if (user != null) {
                session.setAttribute("user", (Object)user);
            }
        }
        this.getNext().invoke(request, response);
    }

    private UserRegistration processOpenIDPrincipal(OpenIdPrincipal openIDPrincipal) {
        UserRegistration user = new UserRegistration();
        Map attributes = openIDPrincipal.getAttributes();
        user.setIdentifier(openIDPrincipal.getIdentifier());
        if (attributes != null) {
            List values = (List)attributes.get("ax_firstName");
            if (values != null && values.size() > 0) {
                user.setFirstName((String)values.get(0));
            }
            if ((values = (List)attributes.get("ax_lastName")) != null && values.size() > 0) {
                user.setLastName((String)values.get(0));
            }
            if ((values = (List)attributes.get("ax_fullName")) != null && values.size() > 0) {
                user.setFullName((String)values.get(0));
            }
            if ((values = (List)attributes.get("fullname")) != null && values.size() > 0) {
                user.setFullName((String)values.get(0));
            }
            if ((values = (List)attributes.get("ax_email")) != null && values.size() > 0) {
                user.setEmail((String)values.get(0));
            }
        }
        return user;
    }

    private UserRegistration processFacebookPrincipal(FacebookPrincipal facebookPrincipal) {
        UserRegistration user = new UserRegistration();
        user.setEmail(facebookPrincipal.getEmail());
        user.setFirstName(facebookPrincipal.getFirstName());
        user.setLastName(facebookPrincipal.getLastName());
        user.setIdentifier(facebookPrincipal.getId());
        return user;
    }
}

