/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.auth;

import javax.servlet.http.HttpSession;
import org.picketlink.authentication.AuthenticationException;
import org.picketlink.authentication.Authenticator;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.social.auth.AbstractSocialAuthenticator;
import org.picketlink.social.auth.TwitterPrincipal;
import org.picketlink.social.auth.conf.TwitterConfiguration;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

public class TwitterAuthenticator
extends AbstractSocialAuthenticator {
    protected static final String TWIT_REQUEST_TOKEN_SESSION_ATTRIBUTE = "TWIT_REQUEST_TOKEN_SESSION_ATTRIBUTE";
    protected TwitterConfiguration configuration;

    public void setConfiguration(TwitterConfiguration configuration) {
        this.configuration = configuration;
    }

    public void authenticate() {
        if (this.httpServletRequest == null) {
            throw new IllegalStateException("http request not available");
        }
        if (this.httpServletResponse == null) {
            throw new IllegalStateException("http response not available");
        }
        if (this.configuration == null) {
            throw new IllegalStateException("configuration not available");
        }
        HttpSession session = this.httpServletRequest.getSession();
        String clientID = this.configuration.getClientID();
        String clientSecret = this.configuration.getClientSecret();
        String returnURL = this.configuration.getReturnURL();
        TwitterPrincipal principal = null;
        Twitter twitter = new TwitterFactory().getInstance();
        twitter.setOAuthConsumer(clientID, clientSecret);
        String verifier = this.httpServletRequest.getParameter("oauth_verifier");
        RequestToken requestToken = (RequestToken)session.getAttribute(TWIT_REQUEST_TOKEN_SESSION_ATTRIBUTE);
        if (requestToken != null || verifier != null) {
            try {
                if (verifier == null) {
                    throw new IllegalStateException("OAuth Verifier is null");
                }
                AccessToken accessToken = twitter.getOAuthAccessToken(requestToken, verifier);
                session.setAttribute("accessToken", (Object)accessToken);
                session.removeAttribute("requestToken");
            }
            catch (TwitterException e) {
                throw new AuthenticationException("Twitter Login:", (Throwable)e);
            }
            try {
                principal = new TwitterPrincipal(twitter.verifyCredentials());
                this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
                this.setAgent((Agent)new SimpleUser(principal.getName()));
                return;
            }
            catch (TwitterException e) {
                throw new AuthenticationException("Twitter Login:", (Throwable)e);
            }
        }
        try {
            requestToken = twitter.getOAuthRequestToken(returnURL);
            session.setAttribute(TWIT_REQUEST_TOKEN_SESSION_ATTRIBUTE, (Object)requestToken);
            this.httpServletResponse.sendRedirect(requestToken.getAuthenticationURL());
        }
        catch (Exception e) {
            throw new AuthenticationException("Twitter Login:", (Throwable)e);
        }
        if (principal != null) {
            this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
            this.setAgent((Agent)new SimpleUser(principal.getName()));
        }
    }
}

