/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.auth;

import com.google.api.services.oauth2.model.Userinfo;
import org.picketlink.authentication.AuthenticationException;
import org.picketlink.authentication.Authenticator;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.basic.User;
import org.picketlink.social.auth.AbstractSocialAuthenticator;
import org.picketlink.social.auth.conf.GoogleConfiguration;
import org.picketlink.social.standalone.google.GoogleAccessTokenContext;
import org.picketlink.social.standalone.google.GoogleProcessor;
import org.picketlink.social.standalone.google.InteractionState;

public class GoogleAuthenticator
extends AbstractSocialAuthenticator {
    private GoogleConfiguration configuration;
    private GoogleProcessor googleProcessor;

    public void setConfiguration(GoogleConfiguration configuration) {
        this.configuration = configuration;
    }

    public void authenticate() {
        InteractionState interactionState;
        if (this.httpServletRequest == null) {
            throw new IllegalStateException("http request not available");
        }
        if (this.httpServletResponse == null) {
            throw new IllegalStateException("http response not available");
        }
        if (this.configuration == null) {
            throw new IllegalStateException("configuration not available");
        }
        Userinfo userInfo = null;
        try {
            interactionState = this.getGoogleProcessor().processOAuthInteraction(this.httpServletRequest, this.httpServletResponse);
        }
        catch (Exception e) {
            this.httpServletRequest.getSession().removeAttribute("_authState");
            throw new AuthenticationException("Google+ login failed due to error", (Throwable)e);
        }
        if (interactionState.getState().equals((Object)InteractionState.State.FINISH)) {
            GoogleAccessTokenContext accessTokenContext = interactionState.getAccessTokenContext();
            userInfo = this.getGoogleProcessor().obtainUserInfo(accessTokenContext);
            this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
            this.setAccount((Account)new User(userInfo.getEmail()));
        }
    }

    protected GoogleProcessor getGoogleProcessor() {
        if (this.googleProcessor == null) {
            this.googleProcessor = new GoogleProcessor(this.configuration.getClientID(), this.configuration.getClientSecret(), this.configuration.getReturnURL(), this.configuration.getAccessType(), this.configuration.getApplicationName(), this.configuration.getRandomAlgorithm(), this.configuration.getScope());
        }
        return this.googleProcessor;
    }
}

