/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.standalone.login;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.picketlink.social.standalone.fb.FacebookPrincipal;
import org.picketlink.social.standalone.fb.FacebookProcessor;
import org.picketlink.social.standalone.login.SecurityActions;
import org.picketlink.social.standalone.login.SocialRequestWrapper;
import org.picketlink.social.standalone.oauth.OpenIDProcessor;
import org.picketlink.social.standalone.oauth.OpenIdPrincipal;
import org.picketlink.social.standalone.oauth.StringUtil;

public class ExternalAuthentication {
    protected static Logger log = Logger.getLogger(ExternalAuthentication.class);
    protected boolean trace = log.isTraceEnabled();
    private ConsumerManager openIdConsumerManager;
    private FetchRequest fetchRequest;
    private String openIdServiceUrl = null;
    public static final String AUTH_TYPE = "authType";
    protected FacebookProcessor facebookProcessor;
    protected OpenIDProcessor openidProcessor;
    protected String returnURL;
    protected String clientID;
    protected String clientSecret;
    protected String facebookScope = "email";
    private String requiredAttributes = "name,email,ax_firstName,ax_lastName,ax_fullName,ax_email";
    private String optionalAttributes = null;
    protected boolean saveRestoreRequest = true;
    protected List<String> roles = new ArrayList<String>();

    public void setRoleString(String roleStr) {
        if (roleStr == null) {
            throw new RuntimeException("Role String is null in configuration");
        }
        StringTokenizer st = new StringTokenizer(this.getSystemPropertyAsString(roleStr), ",");
        while (st.hasMoreElements()) {
            this.roles.add(st.nextToken());
        }
    }

    public void setSaveRestoreRequest(boolean saveRestoreRequest) {
        this.saveRestoreRequest = saveRestoreRequest;
    }

    public void setReturnURL(String returnURL) {
        this.returnURL = this.getSystemPropertyAsString(returnURL);
    }

    public void setClientID(String clientID) {
        this.clientID = this.getSystemPropertyAsString(clientID);
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = this.getSystemPropertyAsString(clientSecret);
    }

    public void setFacebookScope(String facebookScope) {
        this.facebookScope = this.getSystemPropertyAsString(facebookScope);
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.facebookProcessor == null) {
            this.facebookProcessor = new FacebookProcessor(this.clientID, this.clientSecret, this.facebookScope, this.returnURL, this.roles);
        }
        if (this.openidProcessor == null) {
            this.openidProcessor = new OpenIDProcessor(this.returnURL, this.requiredAttributes, this.optionalAttributes);
        }
        HttpSession session = request.getSession();
        String authType = request.getParameter(AUTH_TYPE);
        if (authType != null && authType.length() > 0) {
            session.setAttribute(AUTH_TYPE, (Object)authType);
        }
        if (authType == null || authType.length() == 0) {
            authType = (String)session.getAttribute(AUTH_TYPE);
        }
        if (authType == null) {
            authType = AUTH_PROVIDERS.FACEBOOK.name();
        }
        if (authType != null && authType.equals(AUTH_PROVIDERS.FACEBOOK.name())) {
            return this.processFacebook(request, response);
        }
        return this.processOpenID(request, response);
    }

    protected boolean processFacebook(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String state = (String)session.getAttribute("STATE");
        if (STATES.FINISH.name().equals(state)) {
            Principal principal = request.getUserPrincipal();
            if (principal == null) {
                principal = this.getFacebookPrincipal(request, response);
            }
            if (principal == null) {
                response.sendError(403);
                return false;
            }
            return this.dealWithFacebookPrincipal(request, response, principal);
        }
        if (state == null || state.isEmpty()) {
            return this.initialFacebookInteraction(request, response);
        }
        if (state.equals(STATES.AUTH.name())) {
            return this.facebookProcessor.handleAuthStage(request, response);
        }
        if (state.equals(STATES.AUTHZ.name())) {
            Principal principal = this.getFacebookPrincipal(request, response);
            if (principal == null) {
                log.error((Object)"Principal was null. Maybe login modules need to be configured properly. Or user chose no data");
                response.sendError(403);
                return false;
            }
            return this.dealWithFacebookPrincipal(request, response, principal);
        }
        return false;
    }

    protected boolean processOpenID(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null) {
            if (this.trace) {
                log.trace((Object)("Logged in as:" + userPrincipal));
            }
            return true;
        }
        if (!this.openidProcessor.isInitialized()) {
            try {
                this.openidProcessor.initialize(this.roles);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HttpSession httpSession = request.getSession();
        String state = (String)httpSession.getAttribute("STATE");
        if (this.trace) {
            log.trace((Object)("state=" + state));
        }
        if (STATES.FINISH.name().equals(state)) {
            httpSession.setAttribute("STATE", (Object)STATES.AUTH.name());
            return this.prepareAndSendAuthRequest(request, response);
        }
        if (state == null || state.isEmpty()) {
            return this.prepareAndSendAuthRequest(request, response);
        }
        if (state.equals(STATES.AUTH.name())) {
            Principal principal = this.processIncomingAuthResult(request, response);
            if (principal == null) {
                log.error((Object)"Principal was null. Maybe login modules need to be configured properly. Or user chose no data");
                return false;
            }
            return this.dealWithOpenIDPrincipal(request, response, principal);
        }
        return false;
    }

    public boolean initialFacebookInteraction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("redirect_uri", this.returnURL);
        params.put("client_id", this.clientID);
        if (this.facebookScope != null) {
            params.put("scope", this.facebookScope);
        }
        String location = "https://www.facebook.com/dialog/oauth" + "?" + this.createFacebookQueryString(params);
        try {
            session.setAttribute("STATE", (Object)STATES.AUTH.name());
            if (this.trace) {
                log.trace((Object)("Redirect:" + location));
            }
            response.sendRedirect(location);
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean dealWithFacebookPrincipal(HttpServletRequest request, HttpServletResponse response, Principal principal) throws IOException {
        SocialRequestWrapper requestWrapper = (SocialRequestWrapper)request;
        requestWrapper.setUserPrincipal(principal);
        request.getSession().setAttribute("STATE", (Object)STATES.FINISH.name());
        return true;
    }

    private boolean dealWithOpenIDPrincipal(HttpServletRequest request, HttpServletResponse response, Principal principal) throws IOException {
        HttpSession httpSession = request.getSession();
        SocialRequestWrapper requestWrapper = (SocialRequestWrapper)request;
        requestWrapper.setUserPrincipal(principal);
        if (this.trace) {
            log.trace((Object)("Logged in as:" + principal));
        }
        httpSession.setAttribute("STATE", (Object)STATES.FINISH.name());
        return true;
    }

    public Principal getFacebookPrincipal(HttpServletRequest request, HttpServletResponse response) {
        Principal facebookPrincipal = this.handleFacebookAuthenticationResponse(request, response);
        if (facebookPrincipal == null) {
            return null;
        }
        request.getSession().setAttribute("PRINCIPAL", (Object)facebookPrincipal);
        return facebookPrincipal;
    }

    protected Principal handleFacebookAuthenticationResponse(HttpServletRequest request, HttpServletResponse response) {
        String error = request.getParameter("error");
        if (error != null) {
            throw new RuntimeException("error:" + error);
        }
        String returnUrl = this.returnURL;
        String authorizationCode = request.getParameter("code");
        if (authorizationCode == null) {
            log.error((Object)"Authorization code parameter not found");
            return null;
        }
        URLConnection connection = this.sendFacebookAccessTokenRequest(returnUrl, authorizationCode, response);
        Map<String, String> params = this.formUrlDecode(this.readUrlContent(connection));
        String accessToken = params.get("access_token");
        String expires = params.get("expires");
        if (this.trace) {
            log.trace((Object)("Access Token=" + accessToken + " :: Expires=" + expires));
        }
        if (accessToken == null) {
            throw new RuntimeException("No access token found");
        }
        return this.readInIdentity(request, response, accessToken, returnUrl);
    }

    protected URLConnection sendFacebookAccessTokenRequest(String returnUrl, String authorizationCode, HttpServletResponse response) {
        String returnUri = this.returnURL;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("redirect_uri", returnUri);
        params.put("client_id", this.clientID);
        params.put("client_secret", this.clientSecret);
        params.put("code", authorizationCode);
        String location = "https://graph.facebook.com/oauth/access_token" + "?" + this.createFacebookQueryString(params);
        try {
            if (this.trace) {
                log.trace((Object)("AccessToken Request=" + location));
            }
            URL url = new URL(location);
            URLConnection connection = url.openConnection();
            return connection;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean prepareAndSendAuthRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String authType = request.getParameter(AUTH_TYPE);
        if (authType == null || authType.length() == 0) {
            authType = (String)request.getSession().getAttribute(AUTH_TYPE);
        }
        this.determineServiceUrl(authType);
        String openId = this.openIdServiceUrl;
        HttpSession session = request.getSession(true);
        if (openId != null) {
            List discoveries;
            session.setAttribute("openid", (Object)openId);
            try {
                discoveries = this.openIdConsumerManager.discover(openId);
            }
            catch (DiscoveryException e) {
                throw new RuntimeException(e);
            }
            DiscoveryInformation discovered = this.openIdConsumerManager.associate(discoveries);
            session.setAttribute("discovery", (Object)discovered);
            try {
                AuthRequest authReq = this.openIdConsumerManager.authenticate(discovered, this.returnURL);
                authReq.addExtension((MessageExtension)this.fetchRequest);
                String url = authReq.getDestinationUrl(true);
                response.sendRedirect(url);
                request.getSession().setAttribute("STATE", (Object)STATES.AUTH.name());
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void determineServiceUrl(String service) {
        this.openIdServiceUrl = Providers.GOOGLE.get();
        if (StringUtil.isNotNull(service)) {
            if ("google".equals(service)) {
                this.openIdServiceUrl = Providers.GOOGLE.get();
            } else if ("yahoo".equals(service)) {
                this.openIdServiceUrl = Providers.YAHOO.get();
            } else if ("myspace".equals(service)) {
                this.openIdServiceUrl = Providers.MYSPACE.get();
            } else if ("myopenid".equals(service)) {
                this.openIdServiceUrl = Providers.MYOPENID.get();
            }
        }
    }

    private String createFacebookQueryString(Map<String, String> params) {
        StringBuilder queryString = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String encodedParamValue;
            String paramName = entry.getKey();
            String paramValue = entry.getValue();
            if (first) {
                first = false;
            } else {
                queryString.append("&");
            }
            queryString.append(paramName).append("=");
            try {
                if (paramValue == null) {
                    throw new RuntimeException("paramValue is null");
                }
                encodedParamValue = URLEncoder.encode(paramValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            queryString.append(encodedParamValue);
        }
        return queryString.toString();
    }

    private Principal readInIdentity(HttpServletRequest request, HttpServletResponse response, String accessToken, String returnUrl) {
        FacebookPrincipal facebookPrincipal = null;
        try {
            String urlString = "https://graph.facebook.com/me" + "?access_token=" + URLEncoder.encode(accessToken, "UTF-8");
            if (this.trace) {
                log.trace((Object)("Profile read:" + urlString));
            }
            URL profileUrl = new URL(urlString);
            String profileContent = this.readUrlContent(profileUrl.openConnection());
            JSONObject jsonObject = new JSONObject(profileContent);
            facebookPrincipal = new FacebookPrincipal();
            facebookPrincipal.setAccessToken(accessToken);
            facebookPrincipal.setId(jsonObject.getString("id"));
            facebookPrincipal.setName(jsonObject.getString("name"));
            facebookPrincipal.setFirstName(jsonObject.getString("first_name"));
            facebookPrincipal.setLastName(jsonObject.getString("last_name"));
            facebookPrincipal.setGender(jsonObject.getString("gender"));
            facebookPrincipal.setTimezone(jsonObject.getString("timezone"));
            facebookPrincipal.setLocale(jsonObject.getString("locale"));
            if (jsonObject.getString("email") != null) {
                facebookPrincipal.setEmail(jsonObject.getString("email"));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return facebookPrincipal;
    }

    private String readUrlContent(URLConnection connection) {
        StringBuilder result = new StringBuilder();
        InputStreamReader reader = null;
        try {
            int nrOfChars;
            reader = new InputStreamReader(connection.getInputStream());
            char[] buffer = new char[50];
            while ((nrOfChars = reader.read(buffer)) != -1) {
                result.append(buffer, 0, nrOfChars);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
            catch (IOException ignore) {}
        }
        return result.toString();
    }

    private Map<String, String> formUrlDecode(String encodedData) {
        String[] elements;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String element : elements = encodedData.split("&")) {
            String paramValue;
            String paramName;
            String[] pair = element.split("=");
            if (pair.length == 2) {
                paramName = pair[0];
                try {
                    paramValue = URLDecoder.decode(pair[1], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new RuntimeException("Unexpected name-value pair in response: " + element);
            }
            params.put(paramName, paramValue);
        }
        return params;
    }

    private String getSystemPropertyAsString(String str) {
        if (str.contains("${")) {
            Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
            Matcher matcher = pattern.matcher(str);
            StringBuffer buffer = new StringBuffer();
            String sysPropertyValue = null;
            while (matcher.find()) {
                String subString = matcher.group(1);
                String defaultValue = "";
                if (subString.contains("::")) {
                    int index = subString.indexOf("::");
                    defaultValue = subString.substring(index + 2);
                    subString = subString.substring(0, index);
                }
                sysPropertyValue = SecurityActions.getSystemProperty(subString, defaultValue);
                matcher.appendReplacement(buffer, sysPropertyValue);
            }
            matcher.appendTail(buffer);
            str = buffer.toString();
        }
        return str;
    }

    public Principal processIncomingAuthResult(HttpServletRequest request, HttpServletResponse response) throws IOException {
        VerificationResult verification;
        OpenIdPrincipal principal = null;
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new RuntimeException("wrong lifecycle: session was null");
        }
        ParameterList responseParamList = new ParameterList(request.getParameterMap());
        DiscoveryInformation discovered = (DiscoveryInformation)session.getAttribute("discovery");
        if (discovered == null) {
            throw new RuntimeException("discovered information was null");
        }
        StringBuffer receivingURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            receivingURL.append("?").append(request.getQueryString());
        }
        try {
            verification = this.openIdConsumerManager.verify(receivingURL.toString(), responseParamList, discovered);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Identifier identifier = verification.getVerifiedId();
        if (identifier != null) {
            AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
            Map attributes = null;
            if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                FetchResponse fetchResp;
                try {
                    fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                }
                catch (MessageException e) {
                    throw new RuntimeException(e);
                }
                attributes = fetchResp.getAttributes();
            }
            principal = this.createOpenIDPrincipal(identifier.getIdentifier(), discovered.getOPEndpoint(), attributes);
            request.getSession().setAttribute("PRINCIPAL", (Object)principal);
            if (this.trace) {
                log.trace((Object)("Logged in as:" + principal));
            }
        } else {
            response.sendError(403);
        }
        return principal;
    }

    private OpenIdPrincipal createOpenIDPrincipal(String identifier, URL openIdProvider, Map<String, List<String>> attributes) {
        return new OpenIdPrincipal(identifier, openIdProvider, attributes);
    }

    private static enum Providers {
        GOOGLE("https://www.google.com/accounts/o8/id"),
        YAHOO("https://me.yahoo.com/"),
        MYSPACE("myspace.com"),
        MYOPENID("https://myopenid.com/");

        private String name;

        private Providers(String name) {
            this.name = name;
        }

        String get() {
            return this.name;
        }
    }

    private static enum STATES {
        AUTH,
        AUTHZ,
        FINISH;

    }

    private static enum AUTH_PROVIDERS {
        FACEBOOK,
        OPENID;

    }
}

