/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.bindings.tomcat.sp.BaseFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPUtil;
import org.picketlink.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.picketlink.identity.federation.bindings.util.ValveUtil;
import org.picketlink.identity.federation.core.config.TrustType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLRequestProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLResponseProcessor;
import org.picketlink.identity.federation.web.util.HTTPRedirectUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.federation.web.util.ServerDetector;
import org.w3c.dom.Document;

public class SPRedirectFormAuthenticator
extends BaseFormAuthenticator {
    protected static Logger log = Logger.getLogger(SPRedirectFormAuthenticator.class);
    protected boolean jbossEnv = false;
    protected boolean idpPostBinding = false;

    public void setIdpPostBinding(Boolean idpPostBinding) {
        this.idpPostBinding = idpPostBinding;
    }

    public SPRedirectFormAuthenticator() {
        ServerDetector detector = new ServerDetector();
        this.jbossEnv = detector.isJboss();
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (response instanceof Response) {
            Response catalinaResponse = (Response)response;
            return this.authenticate(request, catalinaResponse, config);
        }
        throw new RuntimeException("PL00026: Response was not of type catalina response");
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        boolean localLogout;
        Session session = request.getSessionInternal(true);
        String lloStr = request.getParameter("LLO");
        boolean bl = localLogout = StringUtil.isNotNull((String)lloStr) && "true".equalsIgnoreCase(lloStr);
        if (localLogout) {
            try {
                this.sendToLogoutPage(request, response, session);
            }
            catch (ServletException e) {
                log.error((Object)"Exception in logout::", (Throwable)e);
                throw new IOException(e);
            }
            return false;
        }
        String gloStr = request.getParameter("GLO");
        boolean logOutRequest = StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
        String samlRequest = request.getParameter("SAMLRequest");
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        if (!(principal == null || logOutRequest || StringUtil.isNotNull((String)samlRequest) || StringUtil.isNotNull((String)samlResponse))) {
            return true;
        }
        if (!StringUtil.isNotNull((String)samlRequest) && !StringUtil.isNotNull((String)samlResponse)) {
            return this.generalUserRequest(request, response, loginConfig);
        }
        if (StringUtil.isNotNull((String)samlResponse)) {
            return this.handleSAMLResponse(request, response, loginConfig);
        }
        if (StringUtil.isNotNull((String)samlRequest)) {
            return this.handleSAMLRequest(request, response, loginConfig);
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected boolean handleSAMLRequest(Request request, Response response, LoginConfig loginConfig) throws IOException {
        String samlRequest = request.getParameter("SAMLRequest");
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        try {
            ServiceProviderSAMLRequestProcessor requestProcessor = new ServiceProviderSAMLRequestProcessor(false, this.serviceURL);
            boolean result = requestProcessor.process(samlRequest, httpContext, handlers, this.chainLock);
            if (response.isCommitted() || response.isAppCommitted()) {
                return false;
            }
            if (result) {
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)"Server Exception:", (Throwable)e);
            throw new IOException("PL00032: Service Provider :: Server Exception");
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected boolean handleSAMLResponse(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Session session = request.getSessionInternal(true);
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        String relayState = request.getParameter("RelayState");
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        boolean isValid = false;
        try {
            isValid = this.validate(request);
        }
        catch (Exception e) {
            log.error((Object)"Exception:", (Throwable)e);
            throw new IOException();
        }
        if (!isValid) {
            throw new IOException("PL00019: Validation check failed");
        }
        try {
            ServiceProviderSAMLResponseProcessor responseProcessor = new ServiceProviderSAMLResponseProcessor(false, this.serviceURL);
            if (this.idpPostBinding) {
                responseProcessor.setIdpPostBinding(true);
            }
            this.initializeSAMLProcessor((ServiceProviderBaseProcessor)responseProcessor);
            SAML2HandlerResponse saml2HandlerResponse = null;
            try {
                saml2HandlerResponse = responseProcessor.process(samlResponse, httpContext, handlers, this.chainLock);
            }
            catch (ProcessingException pe) {
                Throwable te = pe.getCause();
                if (te instanceof AssertionExpiredException) {
                    ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(false, this.serviceURL);
                    this.initializeSAMLProcessor(baseProcessor);
                    saml2HandlerResponse = baseProcessor.process(httpContext, handlers, this.chainLock);
                    saml2HandlerResponse.setDestination(this.identityURL);
                }
                throw pe;
            }
            Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
            relayState = saml2HandlerResponse.getRelayState();
            String destination = saml2HandlerResponse.getDestination();
            if (destination == null || samlResponseDocument == null) {
                boolean sessionValidity = session.isValid();
                if (!sessionValidity) {
                    this.sendToLogoutPage(request, response, session);
                    return false;
                }
                List roles = saml2HandlerResponse.getRoles();
                if (principal == null) {
                    principal = (Principal)session.getSession().getAttribute("picketlink.principal");
                }
                String username = principal.getName();
                String password = "EMPTY_STR";
                if (new ServerDetector().isJboss() || this.jbossEnv) {
                    ServiceProviderSAMLContext.push((String)username, (List)roles);
                    principal = this.context.getRealm().authenticate(username, password);
                    ServiceProviderSAMLContext.clear();
                } else {
                    SPUtil spUtil = new SPUtil();
                    principal = spUtil.createGenericPrincipal(request, principal.getName(), roles);
                }
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
                request.setUserPrincipal(principal);
                if (this.saveRestoreRequest) {
                    this.restoreRequest(request, session);
                }
                this.register(request, response, principal, "FORM", username, password);
                return true;
            }
            boolean areWeSendingRequest = saml2HandlerResponse.getSendRequest();
            String samlMsg = DocumentUtil.getDocumentAsString((Document)samlResponseDocument);
            String base64Request = RedirectBindingUtil.deflateBase64URLEncode((byte[])samlMsg.getBytes("UTF-8"));
            String destinationQuery = this.getDestinationQueryString(base64Request, relayState, areWeSendingRequest);
            RedirectBindingUtil.RedirectBindingUtilDestHolder holder = new RedirectBindingUtil.RedirectBindingUtilDestHolder();
            holder.setDestination(destination).setDestinationQueryString(destinationQuery);
            String destinationURL = RedirectBindingUtil.getDestinationURL((RedirectBindingUtil.RedirectBindingUtilDestHolder)holder);
            HTTPRedirectUtil.sendRedirectForRequestor((String)destinationURL, (HttpServletResponse)response);
        }
        catch (ProcessingException pe) {
            Throwable t = pe.getCause();
            if (t != null && t instanceof AssertionExpiredException) {
                log.error((Object)"Assertion has expired. Asking IDP for reissue");
                return this.generalUserRequest(request, response, loginConfig);
            }
            log.error((Object)"Server Exception:", (Throwable)pe);
            throw new IOException("PL00032: Service Provider :: Server Exception" + pe.getLocalizedMessage());
        }
        catch (Exception e) {
            log.error((Object)"Server Exception:", (Throwable)e);
            throw new IOException("PL00032: Service Provider :: Server Exception" + e.getLocalizedMessage());
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected boolean generalUserRequest(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Session session = request.getSessionInternal(true);
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        String relayState = request.getParameter("RelayState");
        if (StringUtil.isNotNull((String)relayState)) {
            relayState = this.spConfiguration.getRelayState();
        }
        SAML2HandlerResponse saml2HandlerResponse = null;
        try {
            ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(false, this.serviceURL);
            this.initializeSAMLProcessor(baseProcessor);
            saml2HandlerResponse = baseProcessor.process(httpContext, handlers, this.chainLock);
            saml2HandlerResponse.setDestination(this.identityURL);
        }
        catch (ProcessingException pe) {
            log.error((Object)"Processing Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ParsingException pe) {
            log.error((Object)"Parsing Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ConfigurationException pe) {
            log.error((Object)"Config Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
        relayState = saml2HandlerResponse.getRelayState();
        String destination = saml2HandlerResponse.getDestination();
        if (destination != null && samlResponseDocument != null) {
            try {
                String samlMsg = DocumentUtil.getDocumentAsString((Document)samlResponseDocument);
                if (this.trace) {
                    log.trace((Object)("SAML Document=" + samlMsg));
                }
                boolean areWeSendingRequest = saml2HandlerResponse.getSendRequest();
                String base64Request = RedirectBindingUtil.deflateBase64URLEncode((byte[])samlMsg.getBytes("UTF-8"));
                String destinationQuery = this.getDestinationQueryString(base64Request, relayState, areWeSendingRequest);
                RedirectBindingUtil.RedirectBindingUtilDestHolder holder = new RedirectBindingUtil.RedirectBindingUtilDestHolder();
                holder.setDestination(destination).setDestinationQueryString(destinationQuery);
                String destinationURL = RedirectBindingUtil.getDestinationURL((RedirectBindingUtil.RedirectBindingUtilDestHolder)holder);
                if (this.trace) {
                    log.trace((Object)("URL used for sending:" + destinationURL));
                }
                if (this.saveRestoreRequest) {
                    this.saveRequest(request, session);
                }
                HTTPRedirectUtil.sendRedirectForRequestor((String)destinationURL, (HttpServletResponse)response);
                return false;
            }
            catch (Exception e) {
                log.error((Object)"Server Exception:", (Throwable)e);
                throw new IOException("PL00032: Service Provider :: Server Exception");
            }
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected String createSAMLRequestMessage(String relayState, Response response) throws ServletException, ConfigurationException, IOException, ProcessingException {
        if (this.serviceURL == null) {
            throw new ServletException("PL00092: Null Value:serviceURL");
        }
        SAML2Request saml2Request = new SAML2Request();
        SPUtil spUtil = new SPUtil();
        AuthnRequestType authnRequest = spUtil.createSAMLRequest(this.serviceURL, this.identityURL);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall((RequestAbstractType)authnRequest, (OutputStream)baos);
        String base64Request = RedirectBindingUtil.deflateBase64URLEncode((byte[])baos.toByteArray());
        String destination = authnRequest.getDestination().toASCIIString();
        String destinationQueryString = this.getDestinationQueryString(base64Request, relayState, true);
        RedirectBindingUtil.RedirectBindingUtilDestHolder holder = new RedirectBindingUtil.RedirectBindingUtilDestHolder();
        holder.setDestinationQueryString(destinationQueryString).setDestination(destination);
        return RedirectBindingUtil.getDestinationURL((RedirectBindingUtil.RedirectBindingUtilDestHolder)holder);
    }

    protected String getBinding() {
        return JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get();
    }

    protected String getDestinationQueryString(String urlEncodedRequest, String urlEncodedRelayState, boolean sendRequest) {
        return RedirectBindingUtil.getDestinationQueryString((String)urlEncodedRequest, (String)urlEncodedRelayState, (boolean)sendRequest);
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String issuerDomain = ValveUtil.getDomain((String)issuer);
            TrustType spTrust = this.spConfiguration.getTrust();
            if (spTrust != null) {
                String domainsTrusted = spTrust.getDomains();
                if (this.trace) {
                    log.trace((Object)("Domains that SP trusts=" + domainsTrusted + " and issuer domain=" + issuerDomain));
                }
                if (domainsTrusted.indexOf(issuerDomain) < 0) {
                    StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                    while (st != null && st.hasMoreTokens()) {
                        String uriBit = st.nextToken();
                        if (this.trace) {
                            log.trace((Object)("Matching uri bit=" + uriBit));
                        }
                        if (issuerDomain.indexOf(uriBit) <= 0) continue;
                        if (this.trace) {
                            log.trace((Object)("Matched " + uriBit + " trust for " + issuerDomain));
                        }
                        return;
                    }
                    throw new IssuerNotTrustedException(issuer);
                }
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void initializeSAMLProcessor(ServiceProviderBaseProcessor processor) {
        if (this.issuerID != null) {
            processor.setIssuer(this.issuerID);
        }
        processor.setConfiguration(this.spConfiguration);
    }

    protected ResponseType decryptAssertion(ResponseType responseType) throws IOException, GeneralSecurityException, ConfigurationException, ParsingException {
        throw new RuntimeException("PL00027: Authenticator does not handle encryption");
    }
}

