/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.bindings.tomcat.sp.BaseFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPUtil;
import org.picketlink.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.picketlink.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLRequestProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLResponseProcessor;
import org.picketlink.identity.federation.web.util.ServerDetector;
import org.w3c.dom.Document;

public abstract class AbstractSPFormAuthenticator
extends BaseFormAuthenticator {
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    protected final boolean trace = this.log.isTraceEnabled();
    protected boolean jbossEnv = false;

    public AbstractSPFormAuthenticator() {
        ServerDetector detector = new ServerDetector();
        this.jbossEnv = detector.isJboss();
    }

    protected void processStart() throws LifecycleException {
        super.processStart();
        this.initKeyProvider(this.context);
    }

    protected void initKeyProvider(Context context) throws LifecycleException {
        if (!this.doSupportSignature()) {
            return;
        }
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null && this.doSupportSignature()) {
            throw new LifecycleException("PL00092: Null Value:KeyProvider is null for context=" + context.getName());
        }
        try {
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("PL00092: Null Value:KeyManager class name");
            }
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), keyManagerClassName);
            if (clazz == null) {
                throw new ClassNotFoundException("PL00085: Class Not Loaded:" + keyManagerClassName);
            }
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            String identityURL = this.spConfiguration.getIdentityURL();
            this.keyManager.addAdditionalOption("idp.key", (Object)new URL(identityURL).getHost());
        }
        catch (Exception e) {
            this.log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        if (this.trace) {
            this.log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
        }
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (response instanceof Response) {
            Response catalinaResponse = (Response)response;
            return this.authenticate(request, catalinaResponse, config);
        }
        throw new RuntimeException("PL00026: Response was not of type catalina response");
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        try {
            Session session = request.getSessionInternal(true);
            boolean localLogout = this.isLocalLogout(request);
            if (localLogout) {
                try {
                    this.sendToLogoutPage(request, response, session);
                }
                catch (ServletException e) {
                    this.log.error((Object)"Exception in logout::", (Throwable)e);
                    throw new IOException(e);
                }
                return false;
            }
            String samlRequest = request.getParameter("SAMLRequest");
            String samlResponse = request.getParameter("SAMLResponse");
            Principal principal = request.getUserPrincipal();
            if (!(principal == null || this.isGlobalLogout(request) || StringUtil.isNotNull((String)samlRequest) || StringUtil.isNotNull((String)samlResponse))) {
                return true;
            }
            if (!StringUtil.isNotNull((String)samlRequest) && !StringUtil.isNotNull((String)samlResponse)) {
                return this.generalUserRequest(request, response, loginConfig);
            }
            if (StringUtil.isNotNull((String)samlResponse)) {
                return this.handleSAMLResponse(request, response, loginConfig);
            }
            if (StringUtil.isNotNull((String)samlRequest)) {
                return this.handleSAMLRequest(request, response, loginConfig);
            }
            return this.localAuthentication(request, response, loginConfig);
        }
        catch (IOException e) {
            if (StringUtil.isNotNull((String)this.spConfiguration.getErrorPage())) {
                try {
                    request.getRequestDispatcher(this.spConfiguration.getErrorPage()).forward((ServletRequest)request.getRequest(), (ServletResponse)response);
                }
                catch (ServletException e1) {
                    this.log.error((Object)"PL00075: File could not be located :", (Throwable)e1);
                }
                return false;
            }
            throw e;
        }
    }

    private boolean isGlobalLogout(Request request) {
        String gloStr = request.getParameter("GLO");
        return StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
    }

    private boolean isLocalLogout(Request request) {
        String lloStr = request.getParameter("LLO");
        return StringUtil.isNotNull((String)lloStr) && "true".equalsIgnoreCase(lloStr);
    }

    private boolean handleSAMLRequest(Request request, Response response, LoginConfig loginConfig) throws IOException {
        String samlRequest = request.getParameter("SAMLRequest");
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        try {
            ServiceProviderSAMLRequestProcessor requestProcessor = new ServiceProviderSAMLRequestProcessor(this.isPOSTBindingResponse(), this.serviceURL);
            requestProcessor.setTrustKeyManager(this.keyManager);
            requestProcessor.setSupportSignatures(this.doSupportSignature());
            boolean result = requestProcessor.process(samlRequest, httpContext, handlers, this.chainLock);
            if (response.isCommitted() || response.isAppCommitted()) {
                return false;
            }
            if (result) {
                return result;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Server Exception:", (Throwable)e);
            throw new IOException("PL00032: Service Provider :: Server Exception");
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    private boolean handleSAMLResponse(Request request, Response response, LoginConfig loginConfig) throws IOException {
        SPUtil spUtil = new SPUtil();
        Session session = request.getSessionInternal(true);
        String samlResponse = request.getParameter("SAMLResponse");
        String relayState = request.getParameter("RelayState");
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        Principal principal = request.getUserPrincipal();
        if (!super.validate(request)) {
            throw new IOException("PL00019: Validation check failed");
        }
        try {
            ServiceProviderSAMLResponseProcessor responseProcessor = new ServiceProviderSAMLResponseProcessor(this.isPOSTBindingResponse(), this.serviceURL);
            responseProcessor.setConfiguration(this.spConfiguration);
            responseProcessor.setValidateSignature(this.doSupportSignature());
            responseProcessor.setTrustKeyManager(this.keyManager);
            SAML2HandlerResponse saml2HandlerResponse = responseProcessor.process(samlResponse, httpContext, handlers, this.chainLock);
            Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
            relayState = saml2HandlerResponse.getRelayState();
            String destination = saml2HandlerResponse.getDestination();
            willSendRequest = saml2HandlerResponse.getSendRequest();
            if (destination == null || samlResponseDocument == null) {
                boolean sessionValidity = session.isValid();
                if (!sessionValidity) {
                    this.sendToLogoutPage(request, response, session);
                    return false;
                }
                List roles = saml2HandlerResponse.getRoles();
                if (principal == null) {
                    principal = (Principal)session.getSession().getAttribute("picketlink.principal");
                }
                String username = principal.getName();
                String password = "EMPTY_STR";
                if (this.trace) {
                    this.log.trace((Object)("Roles determined for username=" + username + "=" + Arrays.toString(roles.toArray())));
                }
                if (new ServerDetector().isJboss() || this.jbossEnv) {
                    ServiceProviderSAMLContext.push((String)username, (List)roles);
                    principal = this.context.getRealm().authenticate(username, password);
                    ServiceProviderSAMLContext.clear();
                } else {
                    principal = spUtil.createGenericPrincipal(request, username, roles);
                }
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
                request.setUserPrincipal(principal);
                if (this.saveRestoreRequest) {
                    this.restoreRequest(request, session);
                }
                this.register(request, response, principal, "FORM", username, password);
                return true;
            }
            this.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest);
        }
        catch (ProcessingException pe) {
            Throwable t = pe.getCause();
            if (t != null && t instanceof AssertionExpiredException) {
                this.log.error((Object)"Assertion has expired. Asking IDP for reissue");
                return this.generalUserRequest(request, response, loginConfig);
            }
            this.log.error((Object)"Server Exception:", (Throwable)pe);
            throw new IOException("PL00032: Service Provider :: Server Exception" + pe.getLocalizedMessage());
        }
        catch (Exception e) {
            this.log.error((Object)"Server Exception:", (Throwable)e);
            throw new IOException("PL00032: Service Provider :: Server Exception");
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected boolean isPOSTBindingResponse() {
        return this.spConfiguration.isIdpUsesPostBinding();
    }

    protected abstract void sendRequestToIDP(String var1, Document var2, String var3, Response var4, boolean var5) throws ProcessingException, ConfigurationException, IOException;

    protected String getBinding() {
        return this.spConfiguration.getBindingType();
    }

    private boolean generalUserRequest(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Session session = request.getSessionInternal(true);
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        String relayState = request.getParameter("RelayState");
        if (StringUtil.isNotNull((String)relayState)) {
            relayState = this.spConfiguration.getRelayState();
        }
        boolean postBinding = this.spConfiguration.getBindingType().equals("POST");
        SAML2HandlerResponse saml2HandlerResponse = null;
        try {
            ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(postBinding, this.serviceURL);
            if (this.issuerID != null) {
                baseProcessor.setIssuer(this.issuerID);
            }
            baseProcessor.setIdentityURL(this.identityURL);
            saml2HandlerResponse = baseProcessor.process(httpContext, handlers, this.chainLock);
        }
        catch (ProcessingException pe) {
            this.log.error((Object)"Processing Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ParsingException pe) {
            this.log.error((Object)"Parsing Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ConfigurationException pe) {
            this.log.error((Object)"Config Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        willSendRequest = saml2HandlerResponse.getSendRequest();
        Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
        relayState = saml2HandlerResponse.getRelayState();
        String destination = saml2HandlerResponse.getDestination();
        if (destination != null && samlResponseDocument != null) {
            try {
                if (this.saveRestoreRequest) {
                    this.saveRequest(request, session);
                }
                this.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest);
                return false;
            }
            catch (Exception e) {
                this.log.error((Object)"Server Exception:", (Throwable)e);
                throw new IOException("PL00032: Service Provider :: Server Exception");
            }
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected boolean isHttpPostBinding() {
        return this.getBinding().equalsIgnoreCase("POST");
    }
}

