/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPRedirectFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPUtil;
import org.picketlink.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.federation.web.util.ServerDetector;

public class SAML11SPRedirectFormAuthenticator
extends SPRedirectFormAuthenticator {
    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            return true;
        }
        Session session = request.getSessionInternal(true);
        if (StringUtil.isNotNull((String)samlResponse)) {
            boolean isValid = false;
            try {
                isValid = this.validate(request);
            }
            catch (Exception e) {
                this.log.error((Object)"Exception:", (Throwable)e);
                throw new IOException();
            }
            if (!isValid) {
                throw new IOException("PL00019: Validation check failed");
            }
            try {
                InputStream base64DecodedResponse = RedirectBindingUtil.base64DeflateDecode((String)samlResponse);
                SAMLParser parser = new SAMLParser();
                SAML11ResponseType saml11Response = (SAML11ResponseType)parser.parse(base64DecodedResponse);
                List assertions = saml11Response.get();
                if (assertions.size() > 1 && this.trace) {
                    this.log.trace((Object)"More than one assertion from IDP. Considering the first one.");
                }
                String username = null;
                ArrayList<String> roles = new ArrayList();
                SAML11AssertionType assertion = (SAML11AssertionType)assertions.get(0);
                if (assertion != null) {
                    List statements = assertion.getStatements();
                    for (SAML11StatementAbstractType statement : statements) {
                        if (!(statement instanceof SAML11AuthenticationStatementType)) continue;
                        SAML11AuthenticationStatementType subStat = (SAML11AuthenticationStatementType)statement;
                        SAML11SubjectType subject = subStat.getSubject();
                        username = subject.getChoice().getNameID().getValue();
                    }
                    roles = AssertionUtil.getRoles((SAML11AssertionType)assertion, null);
                }
                String password = "EMPTY_STR";
                if (new ServerDetector().isJboss() || this.jbossEnv) {
                    ServiceProviderSAMLContext.push(username, roles);
                    principal = this.context.getRealm().authenticate(username, password);
                    ServiceProviderSAMLContext.clear();
                } else {
                    SPUtil spUtil = new SPUtil();
                    principal = spUtil.createGenericPrincipal(request, username, roles);
                }
                session.setNote("org.apache.catalina.session.USERNAME", username);
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
                request.setUserPrincipal(principal);
                if (this.saveRestoreRequest) {
                    this.restoreRequest(request, session);
                }
                this.register(request, response, principal, "FORM", username, password);
                return true;
            }
            catch (Exception e) {
                this.log.error((Object)"Processing Exception:", (Throwable)e);
            }
        }
        this.log.error((Object)"Falling back on local Form Authentication if available");
        return super.authenticate(request, response, loginConfig);
    }
}

