/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.io.InputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.trust.jbossws.handler.AbstractPicketLinkTrustHandler;
import org.picketlink.trust.jbossws.handler.SecurityActions;
import org.picketlink.trust.jbossws.util.JBossWSNativeStackUtil;
import org.picketlink.trust.jbossws.util.JBossWSSERoleExtractor;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAuthorizationHandler
extends AbstractPicketLinkTrustHandler {
    public static final String UNCHECKED = "unchecked";
    protected Map<String, List<String>> cache = new HashMap<String, List<String>>();

    protected boolean handleInbound(MessageContext msgContext) {
        ServletContext context;
        InputStream is;
        if (this.trace) {
            this.log.trace((Object)"Handling Inbound Message");
            this.trace(msgContext);
        }
        if ((is = this.getWSSE(context = (ServletContext)msgContext.get((Object)"javax.xml.ws.servlet.context"))) == null) {
            throw new RuntimeException("PL00018: Resource not found:unable to load jboss-wsse.xml");
        }
        QName portName = (QName)msgContext.get((Object)"javax.xml.ws.wsdl.port");
        QName opName = (QName)msgContext.get((Object)"javax.xml.ws.wsdl.operation");
        if (portName == null) {
            portName = JBossWSNativeStackUtil.getPortNameViaReflection(((Object)((Object)this)).getClass(), msgContext);
        }
        if (portName == null) {
            throw new RuntimeException("PL00092: Null Value:Unable to determine port name from the message context");
        }
        if (opName == null) {
            opName = this.getOperationName(msgContext);
        }
        if (opName == null) {
            throw new RuntimeException("PL00092: Null Value:Unable to determine operation name from the message context");
        }
        List<String> roles = null;
        String key = portName.getLocalPart() + "_" + opName.toString();
        if (this.cache.containsKey(key)) {
            roles = this.cache.get(key);
        } else {
            try {
                roles = JBossWSSERoleExtractor.getRoles(is, portName.getLocalPart(), opName.toString());
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            this.cache.put(key, roles);
        }
        if (!roles.contains(UNCHECKED)) {
            AuthorizationManager authorizationManager = this.getAuthorizationManager();
            SecurityAdaptor securityAdaptor = this.secAdapterfactory.newSecurityAdapter();
            Principal principal = securityAdaptor.getPrincipal();
            Subject subject = SecurityActions.getAuthenticatedSubject();
            Set<Principal> expectedRoles = this.rolesSet(roles);
            if (!authorizationManager.doesUserHaveRole(principal, expectedRoles)) {
                SecurityContext sc = SecurityActions.getSecurityContext();
                StringBuilder builder = new StringBuilder("Authorization Failed:Principal=");
                builder.append(principal).append(":Expected Roles=").append(expectedRoles);
                SecurityContextCallbackHandler scbh = new SecurityContextCallbackHandler(sc);
                builder.append("::Actual Roles=").append(authorizationManager.getSubjectRoles(subject, (CallbackHandler)scbh));
                this.log.error((Object)builder.toString());
                throw new RuntimeException("PL00102: Processing Exception:Authorization Failed");
            }
        }
        return true;
    }

    protected Set<Principal> rolesSet(List<String> roles) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String role : roles) {
            principals.add((Principal)new SimplePrincipal(role));
        }
        return principals;
    }

    protected InputStream getWSSE(ServletContext context) {
        if (context == null) {
            throw new RuntimeException("PL00092: Null Value:Servlet Context is null");
        }
        InputStream is = context.getResourceAsStream("/WEB-INF/jboss-wsse.xml");
        return is;
    }

    protected InputStream load(ClassLoader cl) {
        InputStream is = null;
        is = cl.getResourceAsStream("WEB-INF/jboss-wsse.xml");
        if (is == null) {
            is = cl.getResourceAsStream("/WEB-INF/jboss-wsse.xml");
        }
        return is;
    }

    private QName getOperationName(MessageContext msgContext) {
        SOAPMessageContext soapMessageContext = (SOAPMessageContext)msgContext;
        SOAPMessage soapMessage = soapMessageContext.getMessage();
        try {
            SOAPBody soapBody = soapMessage.getSOAPBody();
            Node child = soapBody.getFirstChild();
            String childNamespace = child.getNamespaceURI();
            String childName = child.getLocalName();
            return new QName(childNamespace, childName);
        }
        catch (SOAPException e) {
            if (this.trace) {
                this.log.trace((Object)"Exception using backup method to get op name=", (Throwable)e);
            }
            return null;
        }
    }
}

