/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.web.util.SecurityActions;
import org.xml.sax.SAXException;

public class ConfigurationUtil {
    public static IDPType getIDPConfiguration(InputStream is) throws JAXBException, SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String schema = "schema/config/picketlink-fed.xsd";
        Unmarshaller un = ConfigurationUtil.getUnmarshaller(schema);
        JAXBElement jaxbSp = (JAXBElement)un.unmarshal(is);
        return (IDPType)jaxbSp.getValue();
    }

    public static SPType getSPConfiguration(InputStream is) throws JAXBException, SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String schema = "schema/config/picketlink-fed.xsd";
        Unmarshaller un = ConfigurationUtil.getUnmarshaller(schema);
        JAXBElement jaxbSp = (JAXBElement)un.unmarshal(is);
        return (SPType)jaxbSp.getValue();
    }

    public static Handlers getHandlers(InputStream is) throws JAXBException, SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String[] schemas = new String[]{"schema/config/picketlink-fed.xsd", "schema/config/picketlink-fed-handler.xsd"};
        Unmarshaller un = ConfigurationUtil.getUnmarshaller(schemas);
        JAXBElement handlers = (JAXBElement)un.unmarshal(is);
        return (Handlers)handlers.getValue();
    }

    private static Unmarshaller getUnmarshaller(String ... schema) throws JAXBException, SAXException, IOException {
        String key = "org.picketlink.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        String[] pkgName = new String[]{IDPType.class.getPackage().getName(), Handlers.class.getPackage().getName()};
        Unmarshaller un = null;
        un = validate ? JAXBUtil.getValidatingUnmarshaller((String[])pkgName, (String[])schema) : JAXBUtil.getUnmarshaller((String[])pkgName);
        return un;
    }
}

