/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.servlets.saml;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.picketlink.identity.federation.api.saml.v2.metadata.MetaDataBuilder;
import org.picketlink.identity.federation.core.saml.v2.metadata.store.FileBasedMetadataConfigurationStore;
import org.picketlink.identity.federation.core.saml.v2.metadata.store.IMetadataConfigurationStore;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.web.servlets.saml.SecurityActions;

public class CircleOfTrustServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient IMetadataConfigurationStore configProvider = new FileBasedMetadataConfigurationStore();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String cstr = config.getInitParameter("configProvider");
        if (StringUtil.isNotNull((String)cstr)) {
            try {
                ClassLoader tcl = SecurityActions.getContextClassLoader();
                this.configProvider = (IMetadataConfigurationStore)tcl.loadClass(cstr).newInstance();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        String type = req.getParameter("type");
        if (action == null) {
            throw new ServletException("action is null");
        }
        if (type == null) {
            throw new ServletException("type is null");
        }
        if ("sp".equalsIgnoreCase(type)) {
            if ("add".equalsIgnoreCase(action)) {
                try {
                    this.addIDP(req, resp);
                    req.getRequestDispatcher("/addedIDP.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if ("display_trusted_providers".equalsIgnoreCase(action)) {
                try {
                    this.displayTrustedProvidersForSP(req, resp);
                    req.getRequestDispatcher("/spTrustedProviders.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        } else if ("idp".equalsIgnoreCase(type)) {
            if ("add".equalsIgnoreCase(action)) {
                try {
                    this.addSP(req, resp);
                    req.getRequestDispatcher("/addedSP.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if ("display_trusted_providers".equalsIgnoreCase(action)) {
                try {
                    this.displayTrustedProvidersForIDP(req, resp);
                    req.getRequestDispatcher("/idpTrustedProviders.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
    }

    private void addIDP(HttpServletRequest request, HttpServletResponse response) throws IOException, JAXBException {
        String spName = request.getParameter("spname");
        String idpName = request.getParameter("idpname");
        String metadataURL = request.getParameter("metadataURL");
        EntityDescriptorType edt = this.getMetaData(metadataURL);
        this.configProvider.persist(edt, idpName);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("idp", (Object)edt);
        Map<String, String> trustedProviders = new HashMap<String, String>();
        try {
            trustedProviders = this.configProvider.loadTrustedProviders(spName);
        }
        catch (ClassNotFoundException e) {
            this.log("Error obtaining the trusted providers for " + spName);
            throw new RuntimeException(e);
        }
        finally {
            trustedProviders.put(idpName, metadataURL);
            this.configProvider.persistTrustedProviders(spName, trustedProviders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSP(HttpServletRequest request, HttpServletResponse response) throws JAXBException, IOException {
        String idpName = request.getParameter("idpname");
        String spName = request.getParameter("spname");
        String metadataURL = request.getParameter("metadataURL");
        EntityDescriptorType edt = this.getMetaData(metadataURL);
        this.configProvider.persist(edt, spName);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("sp", (Object)edt);
        Map<String, String> trustedProviders = new HashMap<String, String>();
        try {
            trustedProviders = this.configProvider.loadTrustedProviders(spName);
        }
        catch (Exception e) {
            this.log("Error obtaining the trusted providers for " + spName);
        }
        finally {
            trustedProviders.put(spName, metadataURL);
            this.configProvider.persistTrustedProviders(idpName, trustedProviders);
        }
    }

    private EntityDescriptorType getMetaData(String metadataURL) throws JAXBException, IOException {
        URL md = new URL(metadataURL);
        HttpURLConnection http = (HttpURLConnection)md.openConnection();
        http.setInstanceFollowRedirects(true);
        InputStream is = http.getInputStream();
        Unmarshaller un = MetaDataBuilder.getUnmarshaller();
        JAXBElement j = (JAXBElement)un.unmarshal(is);
        Object obj = j.getValue();
        if (!(obj instanceof EntityDescriptorType)) {
            throw new RuntimeException("Unsupported type:" + obj.getClass());
        }
        EntityDescriptorType edt = (EntityDescriptorType)obj;
        return edt;
    }

    private void displayTrustedProvidersForIDP(HttpServletRequest request, HttpServletResponse response) throws IOException, ClassNotFoundException {
        String idpName = request.getParameter("name");
        Map trustedProviders = this.configProvider.loadTrustedProviders(idpName);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("idpName", (Object)idpName);
        httpSession.setAttribute("providers", (Object)trustedProviders);
    }

    private void displayTrustedProvidersForSP(HttpServletRequest request, HttpServletResponse response) throws IOException, ClassNotFoundException {
        String spName = request.getParameter("name");
        Map trustedProviders = this.configProvider.loadTrustedProviders(spName);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("spName", (Object)spName);
        httpSession.setAttribute("providers", (Object)trustedProviders);
    }
}

