/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.process;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.web.core.HTTPContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderBaseProcessor {
    protected static Logger log = Logger.getLogger(ServiceProviderBaseProcessor.class);
    protected boolean trace = log.isTraceEnabled();
    protected boolean postBinding;
    protected String serviceURL;
    protected String identityURL;
    protected SPType spConfiguration;
    protected TrustKeyManager keyManager;
    protected String issuer = null;
    protected boolean supportSignatures = false;
    public static final String IDP_KEY = "idp.key";

    public ServiceProviderBaseProcessor(boolean postBinding, String serviceURL) {
        this.postBinding = postBinding;
        this.serviceURL = serviceURL;
    }

    public void setConfiguration(SPType sp) {
        this.spConfiguration = sp;
    }

    public void setTrustKeyManager(TrustKeyManager tkm) {
        this.keyManager = tkm;
    }

    public void setIdentityURL(String identityURL) {
        this.identityURL = identityURL;
    }

    public void setSupportSignatures(boolean supportSignatures) {
        this.supportSignatures = supportSignatures;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SAML2HandlerResponse process(HTTPContext httpContext, Set<SAML2Handler> handlers, Lock chainLock) throws ProcessingException, IOException, ParsingException, ConfigurationException {
        if (this.trace) {
            log.trace((Object)("Handlers are:" + handlers));
        }
        SAML2HandlerRequest saml2HandlerRequest = this.getSAML2HandlerRequest(null, httpContext);
        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
        saml2HandlerResponse.setDestination(this.identityURL);
        try {
            try {
                if (this.trace) {
                    log.trace((Object)("Handlers are : " + handlers));
                }
                chainLock.lock();
                for (SAML2Handler handler : handlers) {
                    handler.reset();
                    if (saml2HandlerResponse.isInError()) {
                        httpContext.getResponse().sendError(saml2HandlerResponse.getErrorCode());
                        break;
                    }
                    if (this.isLogOutRequest(httpContext)) {
                        saml2HandlerRequest.setTypeOfRequestToBeGenerated(SAML2HandlerRequest.GENERATE_REQUEST_TYPE.LOGOUT);
                    } else {
                        saml2HandlerRequest.setTypeOfRequestToBeGenerated(SAML2HandlerRequest.GENERATE_REQUEST_TYPE.AUTH);
                    }
                    handler.generateSAMLRequest(saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                    if (!this.trace) continue;
                    log.trace((Object)("Finished Processing handler:" + handler.getClass().getCanonicalName()));
                }
            }
            catch (ProcessingException pe) {
                log.error((Object)"Processing Exception:", (Throwable)pe);
                throw new RuntimeException(pe);
            }
        }
        finally {
            chainLock.unlock();
        }
        return saml2HandlerResponse;
    }

    protected SAML2HandlerRequest getSAML2HandlerRequest(SAMLDocumentHolder documentHolder, HTTPContext httpContext) {
        IssuerInfoHolder holder = null;
        holder = this.issuer == null ? new IssuerInfoHolder(this.serviceURL) : new IssuerInfoHolder(this.issuer);
        return new DefaultSAML2HandlerRequest((ProtocolContext)httpContext, holder.getIssuer(), documentHolder, SAML2Handler.HANDLER_TYPE.SP);
    }

    protected boolean isLogOutRequest(HTTPContext httpContext) {
        HttpServletRequest request = httpContext.getRequest();
        String gloStr = request.getParameter("GLO");
        return StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
    }
}

