/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.SignatureUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RedirectBindingSignatureUtil {
    public static String getSAMLRequestURLWithSignature(AuthnRequestType authRequest, String relayState, PrivateKey signingKey) throws SAXException, IOException, GeneralSecurityException {
        SAML2Request saml2Request = new SAML2Request();
        StringWriter sw = new StringWriter();
        saml2Request.marshall((RequestAbstractType)authRequest, (Writer)sw);
        String urlEncodedRequest = RedirectBindingUtil.deflateBase64URLEncode(sw.toString());
        String urlEncodedRelayState = null;
        if (StringUtil.isNotNull((String)relayState)) {
            urlEncodedRelayState = URLEncoder.encode(relayState, "UTF-8");
        }
        byte[] sigValue = RedirectBindingSignatureUtil.computeSignature("SAMLRequest", urlEncodedRequest, urlEncodedRelayState, signingKey);
        return RedirectBindingSignatureUtil.getRequestRedirectURLWithSignature(urlEncodedRequest, urlEncodedRelayState, sigValue, signingKey.getAlgorithm());
    }

    public static String getSAMLResponseURLWithSignature(ResponseType responseType, String relayState, PrivateKey signingKey) throws IOException, GeneralSecurityException {
        SAML2Response saml2Response = new SAML2Response();
        Document responseDoc = saml2Response.convert((StatusResponseType)responseType);
        String responseString = DocumentUtil.getDocumentAsString((Document)responseDoc);
        String urlEncodedResponse = RedirectBindingUtil.deflateBase64URLEncode(responseString);
        String urlEncodedRelayState = null;
        if (StringUtil.isNotNull((String)relayState)) {
            urlEncodedRelayState = URLEncoder.encode(relayState, "UTF-8");
        }
        byte[] sigValue = RedirectBindingSignatureUtil.computeSignature("SAMLResponse", urlEncodedResponse, urlEncodedRelayState, signingKey);
        return RedirectBindingSignatureUtil.getResponseRedirectURLWithSignature(urlEncodedResponse, urlEncodedRelayState, sigValue, signingKey.getAlgorithm());
    }

    public static String getSAMLRequestURLWithSignature(String urlEncodedRequest, String urlEncodedRelayState, PrivateKey signingKey) throws IOException, GeneralSecurityException {
        byte[] sigValue = RedirectBindingSignatureUtil.computeSignature("SAMLRequest", urlEncodedRequest, urlEncodedRelayState, signingKey);
        return RedirectBindingSignatureUtil.getRequestRedirectURLWithSignature(urlEncodedRequest, urlEncodedRelayState, sigValue, signingKey.getAlgorithm());
    }

    public static String getSAMLResponseURLWithSignature(String urlEncodedResponse, String urlEncodedRelayState, PrivateKey signingKey) throws IOException, GeneralSecurityException {
        byte[] sigValue = RedirectBindingSignatureUtil.computeSignature("SAMLResponse", urlEncodedResponse, urlEncodedRelayState, signingKey);
        return RedirectBindingSignatureUtil.getResponseRedirectURLWithSignature(urlEncodedResponse, urlEncodedRelayState, sigValue, signingKey.getAlgorithm());
    }

    public static AuthnRequestType getRequestFromSignedURL(String signedURL) throws ConfigurationException, ProcessingException, ParsingException, IOException {
        String samlRequestTokenValue = RedirectBindingSignatureUtil.getTokenValue(signedURL, "SAMLRequest");
        SAML2Request saml2Request = new SAML2Request();
        return saml2Request.getAuthnRequestType(RedirectBindingUtil.urlBase64DeflateDecode(samlRequestTokenValue));
    }

    public static byte[] getSignatureValueFromSignedURL(String signedURL) throws IOException {
        String sigValueTokenValue = RedirectBindingSignatureUtil.getTokenValue(signedURL, "Signature");
        if (sigValueTokenValue == null) {
            throw new IllegalArgumentException("PL00092: Null Value:Signature Token is not present");
        }
        return RedirectBindingUtil.urlBase64Decode(sigValueTokenValue);
    }

    public static String getTokenValue(String queryString, String token) {
        return RedirectBindingSignatureUtil.getTokenValue(RedirectBindingSignatureUtil.getToken(queryString, token));
    }

    public static boolean validateSignature(String queryString, PublicKey validatingKey, byte[] sigValue) throws UnsupportedEncodingException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        if (RedirectBindingSignatureUtil.isRequestQueryString(queryString)) {
            RedirectBindingSignatureUtil.addParameter(sb, "SAMLRequest", RedirectBindingSignatureUtil.getTokenValue(queryString, "SAMLRequest"));
        } else {
            RedirectBindingSignatureUtil.addParameter(sb, "SAMLResponse", RedirectBindingSignatureUtil.getTokenValue(queryString, "SAMLResponse"));
        }
        String relayStateFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "RelayState");
        if (StringUtil.isNotNull((String)relayStateFromURL)) {
            RedirectBindingSignatureUtil.addParameter(sb, "RelayState", relayStateFromURL);
        }
        RedirectBindingSignatureUtil.addParameter(sb, "SigAlg", RedirectBindingSignatureUtil.getTokenValue(queryString, "SigAlg"));
        return SignatureUtil.validate((byte[])sb.toString().getBytes("UTF-8"), (byte[])sigValue, (PublicKey)validatingKey);
    }

    private static boolean isRequestQueryString(String queryString) {
        return RedirectBindingSignatureUtil.getTokenValue(queryString, "SAMLRequest") != null;
    }

    private static byte[] computeSignature(String samlParameter, String urlEncoded, String urlEncodedRelayState, PrivateKey signingKey) throws IOException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        RedirectBindingSignatureUtil.addParameter(sb, samlParameter, urlEncoded);
        if (StringUtil.isNotNull((String)urlEncodedRelayState)) {
            RedirectBindingSignatureUtil.addParameter(sb, "RelayState", urlEncodedRelayState);
        }
        String algo = signingKey.getAlgorithm();
        String sigAlg = SignatureUtil.getXMLSignatureAlgorithmURI((String)algo);
        sigAlg = URLEncoder.encode(sigAlg, "UTF-8");
        RedirectBindingSignatureUtil.addParameter(sb, "SigAlg", sigAlg);
        byte[] sigValue = SignatureUtil.sign((String)sb.toString(), (PrivateKey)signingKey);
        return sigValue;
    }

    private static String getRequestRedirectURLWithSignature(String urlEncodedRequest, String urlEncodedRelayState, byte[] signature, String sigAlgo) throws IOException {
        return RedirectBindingSignatureUtil.getRedirectURLWithSignature("SAMLRequest", urlEncodedRequest, urlEncodedRelayState, signature, sigAlgo);
    }

    private static String getResponseRedirectURLWithSignature(String urlEncodedResponse, String urlEncodedRelayState, byte[] signature, String sigAlgo) throws IOException {
        return RedirectBindingSignatureUtil.getRedirectURLWithSignature("SAMLResponse", urlEncodedResponse, urlEncodedRelayState, signature, sigAlgo);
    }

    private static String getRedirectURLWithSignature(String samlParameter, String urlEncoded, String urlEncodedRelayState, byte[] signature, String sigAlgo) throws IOException {
        StringBuilder sb = new StringBuilder();
        RedirectBindingSignatureUtil.addParameter(sb, samlParameter, urlEncoded);
        if (StringUtil.isNotNull((String)urlEncodedRelayState)) {
            RedirectBindingSignatureUtil.addParameter(sb, "RelayState", urlEncodedRelayState);
        }
        String sigAlg = SignatureUtil.getXMLSignatureAlgorithmURI((String)sigAlgo);
        sigAlg = URLEncoder.encode(sigAlg, "UTF-8");
        RedirectBindingSignatureUtil.addParameter(sb, "SigAlg", sigAlg);
        String encodedSig = RedirectBindingUtil.base64URLEncode(signature);
        RedirectBindingSignatureUtil.addParameter(sb, "Signature", encodedSig);
        return sb.toString();
    }

    private static void addParameter(StringBuilder queryString, String paramName, String paramValue) {
        String parameterSeparator = "&";
        if (queryString.length() == 0) {
            parameterSeparator = "";
        }
        queryString.append(parameterSeparator).append(paramName).append("=").append(paramValue);
    }

    private static String getToken(String queryString, String token) {
        if (queryString == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:queryString");
        }
        int start = queryString.indexOf(token = String.valueOf(token) + "=");
        if (start < 0) {
            return null;
        }
        int end = queryString.indexOf("&", start);
        if (end == -1) {
            return queryString.substring(start);
        }
        return queryString.substring(start, end);
    }

    private static String getTokenValue(String token) {
        if (token == null) {
            return token;
        }
        int eq = token.indexOf(61);
        if (eq == -1) {
            return token;
        }
        return token.substring(eq + 1);
    }
}

