/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.InputStream;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.config.SAMLConfigParser;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public abstract class AbstractSAMLConfigurationProvider
implements SAMLConfigurationProvider {
    public static final String VALIDATING_ALIAS = "ValidatingAlias";
    protected IDPType configParsedIDPType = null;
    protected SPType configParsedSPType = null;

    public void setConfigFile(InputStream is) throws ParsingException {
        if (is == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:");
        }
        SAMLConfigParser parser = new SAMLConfigParser();
        Object parsedObject = parser.parse(is);
        if (parsedObject instanceof IDPType) {
            this.configParsedIDPType = (IDPType)parsedObject;
        } else {
            this.configParsedSPType = (SPType)parsedObject;
        }
    }

    public abstract IDPType getIDPConfiguration() throws ProcessingException;

    public abstract SPType getSPConfiguration() throws ProcessingException;
}

