/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.security.Principal;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.impl.EmptyRoleGenerator;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.picketlink.identity.federation.web.handlers.saml2.SecurityActions;

public class RolesGenerationHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(RolesGenerationHandler.class);
    private final boolean trace = log.isTraceEnabled();
    private transient RoleGenerator roleGenerator = new EmptyRoleGenerator();

    public void initChainConfig(SAML2HandlerChainConfig handlerChainConfig) throws ConfigurationException {
        super.initChainConfig(handlerChainConfig);
        Object config = this.handlerChainConfig.getParameter("CONFIGURATION");
        if (config instanceof IDPType) {
            IDPType idpType = (IDPType)config;
            String roleGeneratorString = idpType.getRoleGenerator();
            this.insantiateRoleValidator(roleGeneratorString);
        }
    }

    public void initHandlerConfig(SAML2HandlerConfig handlerConfig) throws ConfigurationException {
        super.initHandlerConfig(handlerConfig);
        String roleGeneratorString = (String)this.handlerConfig.getParameter("ATTRIBUTE_MANAGER");
        this.insantiateRoleValidator(roleGeneratorString);
    }

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof LogoutRequestType) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.SP) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
        List roles = (List)session.getAttribute("picketlink.roles");
        if (roles == null) {
            roles = this.roleGenerator.generateRoles(userPrincipal);
            session.setAttribute("picketlink.roles", (Object)roles);
        }
        response.setRoles(roles);
    }

    private void insantiateRoleValidator(String attribStr) throws ConfigurationException {
        if (attribStr != null && !"".equals(attribStr)) {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), attribStr);
                this.roleGenerator = (RoleGenerator)clazz.newInstance();
                if (this.trace) {
                    log.trace((Object)("RoleGenerator set to " + this.roleGenerator));
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception initializing role generator:", (Throwable)e);
                throw new ConfigurationException();
            }
        }
    }
}

