/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.SerializablePrincipal;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.picketlink.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.StatementUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.util.JAXPValidationUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.core.IdentityServer;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.picketlink.identity.federation.web.interfaces.IRoleValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2AuthenticationHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2AuthenticationHandler.class);
    private final boolean trace = log.isTraceEnabled();
    private final IDPAuthenticationHandler idp = new IDPAuthenticationHandler();
    private final SPAuthenticationHandler sp = new SPAuthenticationHandler();

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof AuthnRequestType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleRequestType(request, response);
        } else {
            this.sp.handleRequestType(request, response);
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof ResponseType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleStatusResponseType(request, response);
        } else {
            this.sp.handleStatusResponseType(request, response);
        }
    }

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (SAML2HandlerRequest.GENERATE_REQUEST_TYPE.AUTH != request.getTypeOfRequestToBeGenerated()) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.generateSAMLRequest(request, response);
            response.setSendRequest(true);
        } else {
            this.sp.generateSAMLRequest(request, response);
            response.setSendRequest(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SPAuthenticationHandler {
        private SPAuthenticationHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            String nameIDFormat;
            String issuerValue = request.getIssuer().getValue();
            SAML2Request samlRequest = new SAML2Request();
            String id = IDGenerator.create((String)"ID_");
            String assertionConsumerURL = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("ASSERTION_CONSUMER_URL");
            if (StringUtil.isNullOrEmpty((String)assertionConsumerURL)) {
                assertionConsumerURL = issuerValue;
            }
            if (StringUtil.isNotNull((String)(nameIDFormat = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("NAMEID_FORMAT")))) {
                samlRequest.setNameIDFormat(nameIDFormat);
            }
            try {
                AuthnRequestType authn = samlRequest.createAuthnRequestType(id, assertionConsumerURL, response.getDestination(), issuerValue);
                response.setResultingDocument(samlRequest.convert((RequestAbstractType)authn));
                response.setSendRequest(true);
                request.addOption("AUTH_REQUEST_ID", (Object)id);
            }
            catch (Exception e) {
                throw new ProcessingException((Throwable)e);
            }
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            ResponseType responseType = (ResponseType)request.getSAML2Object();
            List assertions = responseType.getAssertions();
            if (assertions.size() == 0) {
                throw new IllegalStateException("PL00092: Null Value:No assertions in reply from IDP");
            }
            PrivateKey privateKey = (PrivateKey)request.getOptions().get("DECRYPTING_KEY");
            EncryptedAssertionType assertion = ((ResponseType.RTChoiceType)assertions.get(0)).getEncryptedAssertion();
            if (assertion instanceof EncryptedAssertionType) {
                responseType = this.decryptAssertion(responseType, privateKey);
                assertion = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion();
            }
            if (assertion == null) {
                assertion = ((ResponseType.RTChoiceType)assertions.get(0)).getAssertion();
            }
            request.addOption("ASSERTION", (Object)assertion);
            Principal userPrincipal = this.handleSAMLResponse(responseType, response);
            if (userPrincipal == null) {
                response.setError(403, "User Principal not determined: Forbidden");
            } else {
                HttpSession session = httpContext.getRequest().getSession(false);
                session.setAttribute("picketlink.principal", (Object)userPrincipal);
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        private ResponseType decryptAssertion(ResponseType responseType, PrivateKey privateKey) throws ProcessingException {
            if (privateKey == null) {
                throw new IllegalArgumentException("PL00078: Null Parameter:privateKey");
            }
            SAML2Response saml2Response = new SAML2Response();
            try {
                Document doc = saml2Response.convert((StatusResponseType)responseType);
                Element enc = DocumentUtil.getElement((Document)doc, (QName)new QName(JBossSAMLConstants.ENCRYPTED_ASSERTION.get()));
                if (enc == null) {
                    throw new ProcessingException("PL00092: Null Value:Null encrypted assertion element");
                }
                String oldID = enc.getAttribute(JBossSAMLConstants.ID.get());
                Document newDoc = DocumentUtil.createDocument();
                Node importedNode = newDoc.importNode(enc, true);
                newDoc.appendChild(importedNode);
                Element decryptedDocumentElement = XMLEncryptionUtil.decryptElementInDocument((Document)newDoc, (PrivateKey)privateKey);
                SAMLParser parser = new SAMLParser();
                JAXPValidationUtil.checkSchemaValidation((Node)decryptedDocumentElement);
                AssertionType assertion = (AssertionType)parser.parse(StaxParserUtil.getXMLEventReader((InputStream)DocumentUtil.getNodeAsStream((Node)decryptedDocumentElement)));
                responseType.replaceAssertion(oldID, new ResponseType.RTChoiceType(assertion));
                return responseType;
            }
            catch (Exception e) {
                throw new ProcessingException((Throwable)e);
            }
        }

        private Principal handleSAMLResponse(ResponseType responseType, SAML2HandlerResponse response) throws ProcessingException {
            boolean expiredAssertion;
            if (responseType == null) {
                throw new IllegalArgumentException("PL00078: Null Parameter:response type");
            }
            StatusType statusType = responseType.getStatus();
            if (statusType == null) {
                throw new IllegalArgumentException("PL00078: Null Parameter:Status Type from the IDP");
            }
            String statusValue = statusType.getStatusCode().getValue().toASCIIString();
            if (!JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusValue)) {
                throw new SecurityException("PL00015: IDP Authentication Failed:IDP forbid the user");
            }
            List assertions = responseType.getAssertions();
            if (assertions.size() == 0) {
                throw new IllegalStateException("PL00092: Null Value:No assertions in reply from IDP");
            }
            AssertionType assertion = ((ResponseType.RTChoiceType)assertions.get(0)).getAssertion();
            try {
                String skew = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("CLOCK_SKEW_MILIS");
                if (StringUtil.isNotNull((String)skew)) {
                    long skewMilis = Long.parseLong(skew);
                    expiredAssertion = AssertionUtil.hasExpired((AssertionType)assertion, (long)skewMilis);
                } else {
                    expiredAssertion = AssertionUtil.hasExpired((AssertionType)assertion);
                }
            }
            catch (ConfigurationException e) {
                throw new ProcessingException((Throwable)e);
            }
            if (expiredAssertion) {
                AssertionExpiredException aee = new AssertionExpiredException();
                throw new ProcessingException("PL00079: Assertion has expired:Assertion has expired", (Throwable)aee);
            }
            SubjectType subject = assertion.getSubject();
            if (subject == null) {
                throw new ProcessingException("PL00092: Null Value:Subject in the assertion");
            }
            SubjectType.STSubType subType = subject.getSubType();
            if (subType == null) {
                throw new RuntimeException("PL00092: Null Value:Unable to find subtype via subject");
            }
            NameIDType nameID = (NameIDType)subType.getBaseID();
            if (nameID == null) {
                throw new RuntimeException("PL00092: Null Value:Unable to find username via subject");
            }
            String userName = nameID.getValue();
            ArrayList<String> roles = new ArrayList<String>();
            Set statements = assertion.getStatements();
            for (StatementAbstractType statement : statements) {
                if (!(statement instanceof AttributeStatementType)) continue;
                AttributeStatementType attributeStatement = (AttributeStatementType)statement;
                roles.addAll(this.getRoles(attributeStatement));
            }
            response.setRoles(roles);
            SerializablePrincipal principal = new SerializablePrincipal(userName);
            if (SAML2AuthenticationHandler.this.handlerChainConfig.getParameter("ROLE_VALIDATOR_IGNORE") == null) {
                IRoleValidator roleValidator = (IRoleValidator)SAML2AuthenticationHandler.this.handlerChainConfig.getParameter("ROLE_VALIDATOR");
                if (roleValidator == null) {
                    throw new ProcessingException("PL00092: Null Value:Role Validator not provided");
                }
                boolean validRole = roleValidator.userInRole((Principal)principal, roles);
                if (!validRole) {
                    if (SAML2AuthenticationHandler.this.trace) {
                        log.trace((Object)("Invalid role:" + roles));
                    }
                    principal = null;
                }
            }
            return principal;
        }

        private List<String> getRoles(AttributeStatementType attributeStatement) {
            String roleKey;
            String val;
            ArrayList<String> roles = new ArrayList<String>();
            if (SAML2AuthenticationHandler.this.handlerConfig.containsKey("DISABLE_ROLE_PICKING") && StringUtil.isNotNull((String)(val = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("DISABLE_ROLE_PICKING"))) && "true".equalsIgnoreCase(val)) {
                return roles;
            }
            ArrayList roleKeys = new ArrayList();
            if (SAML2AuthenticationHandler.this.handlerConfig.containsKey("ROLE_KEY") && StringUtil.isNotNull((String)(roleKey = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("ROLE_KEY")))) {
                roleKeys.addAll(StringUtil.tokenize((String)roleKey));
            }
            List attList = attributeStatement.getAttributes();
            for (AttributeStatementType.ASTChoiceType obj : attList) {
                List attributeValues;
                AttributeType attr = obj.getAttribute();
                if (roleKeys.size() > 0 && !roleKeys.contains(attr.getName()) || (attributeValues = attr.getAttributeValue()) == null) continue;
                for (Object attrValue : attributeValues) {
                    if (attrValue instanceof String) {
                        roles.add((String)attrValue);
                        continue;
                    }
                    if (attrValue instanceof Node) {
                        Node roleNode = (Node)attrValue;
                        roles.add(roleNode.getFirstChild().getNodeValue());
                        continue;
                    }
                    throw new RuntimeException("PL00069: Parser: Type not supported:Unknown role object type : " + attrValue);
                }
            }
            return roles;
        }
    }

    private class IDPAuthenticationHandler {
        private IDPAuthenticationHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            ServletContext servletContext = httpContext.getServletContext();
            AuthnRequestType art = (AuthnRequestType)request.getSAML2Object();
            if (art == null) {
                throw new ProcessingException("PL00092: Null Value:AuthnRequest is null");
            }
            String destination = art.getAssertionConsumerServiceURL().toASCIIString();
            if (SAML2AuthenticationHandler.this.trace) {
                log.trace((Object)("Destination=" + destination));
            }
            response.setDestination(destination);
            HttpSession session = BaseSAML2Handler.getHttpSession(request);
            Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
            if (userPrincipal == null) {
                userPrincipal = httpContext.getRequest().getUserPrincipal();
            }
            try {
                Document samlResponse = this.getResponse(request);
                boolean isPost = httpContext.getRequest().getMethod().equalsIgnoreCase("POST");
                IdentityServer identityServer = (IdentityServer)servletContext.getAttribute("IDENTITY_SERVER");
                identityServer.stack().register(session.getId(), destination, isPost);
                response.setResultingDocument(samlResponse);
                response.setRelayState(request.getRelayState());
                response.setPostBindingForResponse(isPost);
            }
            catch (Exception e) {
                log.error((Object)"Exception in processing authentication:", (Throwable)e);
                throw new ProcessingException("PL00102: Processing Exception:authentication issue");
            }
        }

        public Document getResponse(SAML2HandlerRequest request) throws ConfigurationException, ProcessingException {
            Document samlResponseDocument;
            block12: {
                AssertionType latestAssertion;
                HTTPContext httpContext = (HTTPContext)request.getContext();
                AuthnRequestType art = (AuthnRequestType)request.getSAML2Object();
                HttpSession session = BaseSAML2Handler.getHttpSession(request);
                Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
                if (userPrincipal == null) {
                    userPrincipal = httpContext.getRequest().getUserPrincipal();
                }
                String assertionConsumerURL = art.getAssertionConsumerServiceURL().toASCIIString();
                List roles = (List)session.getAttribute("picketlink.roles");
                String identityURL = request.getIssuer().getValue();
                Map attribs = (Map)request.getOptions().get("ATTRIBUTES");
                long assertionValidity = (Long)request.getOptions().get("ASSERTIONS_VALIDITY");
                String requestID = art.getID();
                samlResponseDocument = null;
                String authMethod = (String)request.getOptions().get("LOGIN_TYPE");
                if (SAML2AuthenticationHandler.this.trace) {
                    log.trace((Object)("AssertionConsumerURL=" + assertionConsumerURL + "::assertion validity=" + assertionValidity));
                }
                ResponseType responseType = null;
                SAML2Response saml2Response = new SAML2Response();
                String id = IDGenerator.create((String)"ID_");
                IssuerInfoHolder issuerHolder = new IssuerInfoHolder(identityURL);
                issuerHolder.setStatusCode(JBossSAMLURIConstants.STATUS_SUCCESS.get());
                IDPInfoHolder idp = new IDPInfoHolder();
                idp.setNameIDFormatValue(userPrincipal.getName());
                idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
                String assertionID = (String)session.getAttribute("ASSERTION_ID");
                if (assertionID != null && (latestAssertion = (AssertionType)session.getAttribute("ASSERTION")) != null) {
                    idp.setAssertion(latestAssertion);
                }
                SPInfoHolder sp = new SPInfoHolder();
                sp.setResponseDestinationURI(assertionConsumerURL);
                sp.setRequestID(requestID);
                responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
                AssertionType assertion = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion();
                if (SAML2AuthenticationHandler.this.handlerConfig.getParameter("DISABLE_AUTHN_STATEMENT") == null) {
                    String authContextRef = JBossSAMLURIConstants.AC_PASSWORD.get();
                    if (StringUtil.isNotNull((String)authMethod)) {
                        authContextRef = authMethod;
                    }
                    AuthnStatementType authnStatement = StatementUtil.createAuthnStatement((XMLGregorianCalendar)XMLTimeUtil.getIssueInstant(), (String)authContextRef);
                    assertion.addStatement((StatementAbstractType)authnStatement);
                }
                if (SAML2AuthenticationHandler.this.handlerConfig.getParameter("DISABLE_SENDING_ROLES") == null) {
                    AttributeStatementType attrStatement = StatementUtil.createAttributeStatement((List)roles);
                    assertion.addStatement((StatementAbstractType)attrStatement);
                }
                if (attribs != null && attribs.size() > 0) {
                    AttributeStatementType attStatement = StatementUtil.createAttributeStatement((Map)attribs);
                    assertion.addStatement((StatementAbstractType)attStatement);
                }
                session.setAttribute("ASSERTION", (Object)assertion);
                if (log.isTraceEnabled()) {
                    StringWriter sw = new StringWriter();
                    try {
                        saml2Response.marshall(responseType, (Writer)sw);
                    }
                    catch (ProcessingException e) {
                        log.trace((Object)e);
                    }
                    log.trace((Object)("Response=" + sw.toString()));
                }
                try {
                    samlResponseDocument = saml2Response.convert((StatusResponseType)responseType);
                }
                catch (Exception e) {
                    if (!SAML2AuthenticationHandler.this.trace) break block12;
                    log.trace((Object)e);
                }
            }
            return samlResponseDocument;
        }
    }
}

