/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.TrustType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.util.HTTPRedirectUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

public class IDPWebRequestUtil {
    private static Logger log = Logger.getLogger(IDPWebRequestUtil.class);
    private final boolean trace = log.isTraceEnabled();
    private boolean redirectProfile = false;
    private boolean postProfile = false;
    private final IDPType idpConfiguration;
    private final TrustKeyManager keyManager;
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";

    public IDPWebRequestUtil(HttpServletRequest request, IDPType idp, TrustKeyManager keym) {
        this.idpConfiguration = idp;
        this.keyManager = keym;
        this.redirectProfile = "GET".equals(request.getMethod());
        this.postProfile = "POST".equals(request.getMethod());
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public boolean hasSAMLRequestInRedirectProfile() {
        return this.redirectProfile;
    }

    public boolean hasSAMLRequestInPostProfile() {
        return this.postProfile;
    }

    public SAMLDocumentHolder getSAMLDocumentHolder(String samlMessage) throws ParsingException, ConfigurationException, ProcessingException {
        InputStream is = null;
        SAML2Request saml2Request = new SAML2Request();
        if (this.redirectProfile) {
            is = RedirectBindingUtil.base64DeflateDecode(samlMessage);
        } else {
            try {
                byte[] samlBytes = PostBindingUtil.base64Decode(samlMessage);
                if (this.trace) {
                    log.trace((Object)("SAMLRequest=" + new String(samlBytes)));
                }
                is = new ByteArrayInputStream(samlBytes);
            }
            catch (Exception rte) {
                if (this.trace) {
                    log.trace((Object)("Error in base64 decoding saml message: " + rte));
                }
                throw new ParsingException((Throwable)rte);
            }
        }
        saml2Request.getSAML2ObjectFromStream(is);
        return saml2Request.getSamlDocumentHolder();
    }

    public RequestAbstractType getSAMLRequest(String samlMessage) throws ParsingException, ConfigurationException, ProcessingException {
        InputStream is = null;
        SAML2Request saml2Request = new SAML2Request();
        if (this.redirectProfile) {
            try {
                is = RedirectBindingUtil.base64DeflateDecode(samlMessage);
            }
            catch (Exception e) {
                log.error((Object)"Exception in parsing saml message:", (Throwable)e);
                throw new ParsingException();
            }
        } else {
            byte[] samlBytes = PostBindingUtil.base64Decode(samlMessage);
            if (this.trace) {
                log.trace((Object)("SAMLRequest=" + new String(samlBytes)));
            }
            is = new ByteArrayInputStream(samlBytes);
        }
        return saml2Request.getRequestType(is);
    }

    public void isTrusted(String issuer) throws IssuerNotTrustedException {
        if (this.idpConfiguration == null) {
            throw new IllegalStateException("PL00092: Null Value:IDP Configuration");
        }
        try {
            String issuerDomain = IDPWebRequestUtil.getDomain(issuer);
            TrustType idpTrust = this.idpConfiguration.getTrust();
            if (idpTrust != null) {
                String domainsTrusted = idpTrust.getDomains();
                if (this.trace) {
                    log.trace((Object)("Domains that IDP trusts=" + domainsTrusted + " and issuer domain=" + issuerDomain));
                }
                if (domainsTrusted.indexOf(issuerDomain) < 0) {
                    StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                    while (st != null && st.hasMoreTokens()) {
                        String uriBit = st.nextToken();
                        if (this.trace) {
                            log.trace((Object)("Matching uri bit=" + uriBit));
                        }
                        if (issuerDomain.indexOf(uriBit) <= 0) continue;
                        if (this.trace) {
                            log.trace((Object)("Matched " + uriBit + " trust for " + issuerDomain));
                        }
                        return;
                    }
                    throw new IssuerNotTrustedException(issuer);
                }
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void send(WebRequestUtilHolder holder) throws GeneralSecurityException, IOException {
        Document responseDoc = holder.getResponseDoc();
        if (responseDoc == null) {
            throw new IllegalArgumentException("PL00092: Null Value:responseType is null");
        }
        String destination = holder.getDestination();
        String relayState = holder.getRelayState();
        boolean supportSignature = holder.isSupportSignature();
        boolean sendRequest = holder.isAreWeSendingRequest();
        HttpServletResponse response = holder.getServletResponse();
        if (!holder.isPostBindingRequested() && !holder.isStrictPostBinding()) {
            byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)responseDoc).getBytes("UTF-8");
            String urlEncodedResponse = RedirectBindingUtil.deflateBase64URLEncode(responseBytes);
            if (this.trace) {
                log.trace((Object)("IDP:Destination=" + destination));
            }
            if (StringUtil.isNotNull((String)relayState)) {
                relayState = RedirectBindingUtil.urlEncode(relayState);
            }
            String finalDest = destination + this.getDestination(urlEncodedResponse, relayState, supportSignature, sendRequest);
            if (this.trace) {
                log.trace((Object)("Redirecting to=" + finalDest));
            }
            HTTPRedirectUtil.sendRedirectForResponder(finalDest, response);
        } else {
            if (supportSignature) {
                SAML2Signature samlSignature = new SAML2Signature();
                KeyPair keypair = this.keyManager.getSigningKeyPair();
                samlSignature.signSAMLDocument(responseDoc, keypair);
                if (this.trace) {
                    log.trace((Object)("Sending over to SP:" + DocumentUtil.asString((Document)responseDoc)));
                }
            }
            byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)responseDoc).getBytes("UTF-8");
            String samlResponse = PostBindingUtil.base64Encode(new String(responseBytes));
            PostBindingUtil.sendPost(new DestinationInfoHolder(destination, samlResponse, relayState), response, sendRequest);
        }
    }

    public String getDestination(String urlEncodedResponse, String urlEncodedRelayState, boolean supportSignature, boolean sendRequest) {
        StringBuilder sb = new StringBuilder();
        if (supportSignature) {
            try {
                sb.append("?");
                sb.append(RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature(urlEncodedResponse, urlEncodedRelayState, this.keyManager.getSigningKey()));
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace((Object)e);
                }
            }
        } else {
            if (sendRequest) {
                sb.append("?SAMLRequest=").append(urlEncodedResponse);
            } else {
                sb.append("?SAMLResponse=").append(urlEncodedResponse);
            }
            if (StringUtil.isNotNull((String)urlEncodedRelayState)) {
                sb.append("&RelayState=").append(urlEncodedRelayState);
            }
        }
        return sb.toString();
    }

    public WebRequestUtilHolder getHolder() {
        return new WebRequestUtilHolder();
    }

    public Document getErrorResponse(String responseURL, String status, String identityURL, boolean supportSignature) {
        Document samlResponse;
        block14: {
            samlResponse = null;
            ResponseType responseType = null;
            SAML2Response saml2Response = new SAML2Response();
            String id = IDGenerator.create((String)"ID_");
            IssuerInfoHolder issuerHolder = new IssuerInfoHolder(identityURL);
            issuerHolder.setStatusCode(status);
            IDPInfoHolder idp = new IDPInfoHolder();
            idp.setNameIDFormatValue(null);
            idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
            SPInfoHolder sp = new SPInfoHolder();
            sp.setResponseDestinationURI(responseURL);
            try {
                responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
            }
            catch (ConfigurationException e1) {
                if (this.trace) {
                    log.trace((Object)e1);
                }
                responseType = saml2Response.createResponseType(id);
            }
            catch (ProcessingException e) {
                if (this.trace) {
                    log.trace((Object)e);
                }
                responseType = saml2Response.createResponseType(id);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Error_ResponseType = ");
                StringWriter sw = new StringWriter();
                try {
                    saml2Response.marshall(responseType, (Writer)sw);
                }
                catch (ProcessingException e) {
                    log.trace((Object)e);
                }
                log.trace((Object)("Response=" + sw.toString()));
            }
            if (supportSignature) {
                try {
                    SAML2Signature ss = new SAML2Signature();
                    samlResponse = ss.sign(responseType, this.keyManager.getSigningKeyPair());
                }
                catch (Exception e) {
                    if (this.trace) {
                        log.trace((Object)e);
                    }
                    break block14;
                }
            }
            try {
                samlResponse = saml2Response.convert((StatusResponseType)responseType);
            }
            catch (Exception e) {
                if (!this.trace) break block14;
                log.trace((Object)e);
            }
        }
        return samlResponse;
    }

    private static String getDomain(String domainURL) throws IOException {
        URL url = new URL(domainURL);
        return url.getHost();
    }

    public class WebRequestUtilHolder {
        private Document responseDoc;
        private String relayState;
        private String destination;
        private HttpServletResponse servletResponse;
        private PrivateKey privateKey;
        private boolean supportSignature;
        private boolean postBindingRequested;
        private boolean areWeSendingRequest;
        private boolean strictPostBinding = false;

        public boolean isStrictPostBinding() {
            return this.strictPostBinding;
        }

        public void setStrictPostBinding(boolean strictPostBinding) {
            this.strictPostBinding = strictPostBinding;
        }

        public Document getResponseDoc() {
            return this.responseDoc;
        }

        public WebRequestUtilHolder setResponseDoc(Document responseDoc) {
            this.responseDoc = responseDoc;
            return this;
        }

        public String getRelayState() {
            return this.relayState;
        }

        public WebRequestUtilHolder setRelayState(String relayState) {
            this.relayState = relayState;
            return this;
        }

        public String getDestination() {
            return this.destination;
        }

        public WebRequestUtilHolder setDestination(String destination) {
            this.destination = destination;
            return this;
        }

        public HttpServletResponse getServletResponse() {
            return this.servletResponse;
        }

        public WebRequestUtilHolder setServletResponse(HttpServletResponse servletResponse) {
            this.servletResponse = servletResponse;
            return this;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public WebRequestUtilHolder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public boolean isSupportSignature() {
            return this.supportSignature;
        }

        public WebRequestUtilHolder setSupportSignature(boolean supportSignature) {
            this.supportSignature = supportSignature;
            return this;
        }

        public boolean isPostBindingRequested() {
            return this.postBindingRequested;
        }

        public WebRequestUtilHolder setPostBindingRequested(boolean postBindingRequested) {
            this.postBindingRequested = postBindingRequested;
            return this;
        }

        public boolean isAreWeSendingRequest() {
            return this.areWeSendingRequest;
        }

        public WebRequestUtilHolder setAreWeSendingRequest(boolean areWeSendingRequest) {
            this.areWeSendingRequest = areWeSendingRequest;
            return this;
        }
    }
}

