/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.idp;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.web.filters.IDPFilter;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public class IDPServletExtension
implements ServletExtension {
    private final SAMLConfigurationProvider configurationProvider;
    private final PicketLinkAuditHelper auditHelper;

    public IDPServletExtension(SAMLConfigurationProvider configurationProvider, PicketLinkAuditHelper auditHelper) {
        this.configurationProvider = configurationProvider;
        this.auditHelper = auditHelper;
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        if (!this.hasFilter(deploymentInfo)) {
            this.configureFilter(deploymentInfo);
        }
        servletContext.setAttribute("CONFIG_PROVIDER", (Object)this.configurationProvider);
        servletContext.setAttribute("AUDIT_HELPER", (Object)this.auditHelper);
    }

    private void configureFilter(DeploymentInfo deploymentInfo) {
        String filterName = IDPFilter.class.getSimpleName();
        deploymentInfo.addFilter(new FilterInfo(filterName, IDPFilter.class));
        deploymentInfo.addFilterUrlMapping(filterName, "/*", DispatcherType.REQUEST);
    }

    private boolean hasFilter(DeploymentInfo deploymentInfo) {
        Map filters = deploymentInfo.getFilters();
        for (FilterInfo filterInfo : filters.values()) {
            if (!IDPFilter.class.isAssignableFrom(filterInfo.getFilterClass())) continue;
            return true;
        }
        return false;
    }
}

