/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.jetty.groovy;

import groovy.util.NodeBuilder;
import java.util.Map;
import javax.servlet.Servlet;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.jetty.PicoContext;
import org.picocontainer.jetty.PicoFilterHolder;
import org.picocontainer.jetty.PicoServletHolder;
import org.picocontainer.jetty.groovy.FilterHolderBuilder;
import org.picocontainer.jetty.groovy.ServletHolderBuilder;
import org.picocontainer.jetty.groovy.adapters.NodeBuilderAdapter;
import org.picocontainer.jetty.groovy.adapters.WaffleAdapter;

public class ContextBuilder
extends NodeBuilder {
    private final MutablePicoContainer parentContainer;
    private final PicoContext context;

    public ContextBuilder(MutablePicoContainer parentContainer, PicoContext context) {
        this.parentContainer = parentContainer;
        this.context = context;
    }

    protected Object createNode(Object name, Map map) {
        if (name.equals("filter")) {
            return this.makeFilter(map);
        }
        if (name.equals("servlet")) {
            return this.makeServlet(map);
        }
        if (name.equals("initParam")) {
            this.makeInitParam(map);
            return null;
        }
        if (name.equals("listener")) {
            return this.makeListener(map);
        }
        if (name.equals("virtualHost")) {
            return this.addVirtualHost(map);
        }
        if (name.equals("staticContent")) {
            this.setStaticContent(map);
            return null;
        }
        if (name.equals("adapter")) {
            return this.makeAdapter(map);
        }
        if (name.equals("waffleApp")) {
            return new WaffleAdapter(this.context, this.parentContainer, map).getNodeBuilder();
        }
        return null;
    }

    private void setStaticContent(Map map) {
        if (map.containsKey("welcomePage")) {
            this.context.setStaticContext((String)map.remove("path"), (String)map.remove("welcomePage"));
        } else {
            this.context.setStaticContext((String)map.remove("path"));
        }
    }

    private Object makeAdapter(Map map) {
        return new NodeBuilderAdapter((String)map.remove("nodeBuilder"), this.context, this.parentContainer, map).getNodeBuilder();
    }

    private Object makeListener(Map map) {
        return this.context.addListener((Class)map.remove("class"));
    }

    private Object addVirtualHost(Map map) {
        String virtualhost = (String)map.remove("name");
        this.context.addVirtualHost(virtualhost);
        return virtualhost;
    }

    private Object makeServlet(Map map) {
        if (map.containsKey("class")) {
            PicoServletHolder servlet = this.context.addServletWithMapping((Class)map.remove("class"), (String)map.remove("path"));
            return new ServletHolderBuilder((ServletHolder)servlet);
        }
        Servlet servlet = (Servlet)map.remove("instance");
        this.context.addServletWithMapping(servlet, (String)map.remove("path"));
        return servlet;
    }

    private void makeInitParam(Map map) {
        String name = (String)map.remove("name");
        String value = (String)map.remove("value");
        this.context.addInitParam(name, value);
    }

    private Object makeFilter(Map map) {
        PicoFilterHolder filter = this.context.addFilterWithMappings((Class)map.remove("class"), this.getPaths(map), this.extractDispatchers(map));
        return new FilterHolderBuilder((FilterHolder)filter);
    }

    private String[] getPaths(Map map) {
        String mappings;
        String[] paths = new String[]{};
        String mapping = (String)map.remove("path");
        if (mapping != null) {
            paths = new String[]{mapping};
        }
        if ((mappings = (String)map.remove("paths")) != null) {
            paths = mappings.replaceAll(" ", "").split(",");
        }
        return paths;
    }

    private int extractDispatchers(Map map) {
        Object dispatchers = map.remove("dispatchers");
        if (dispatchers != null) {
            return (Integer)dispatchers;
        }
        return 0;
    }
}

