/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.jmock.MockObjectTestCase;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.ObjectReference;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;
import org.picocontainer.behaviors.CachingBehavior;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.AdaptiveInjectionFactory;
import org.picocontainer.injectors.ConstructorInjectionFactory;
import org.picocontainer.parameters.ConstantParameter;
import org.picocontainer.visitors.AbstractPicoVisitor;

public abstract class AbstractComponentAdapterTestCase
extends MockObjectTestCase {
    public static final int SERIALIZABLE = 1;
    public static final int VERIFYING = 2;
    public static final int INSTANTIATING = 4;
    public static final int RESOLVING = 8;

    protected abstract Class getComponentAdapterType();

    protected int getComponentAdapterNature() {
        return 15;
    }

    protected ComponentFactory createDefaultComponentAdapterFactory() {
        return new AdaptiveInjectionFactory();
    }

    protected abstract ComponentAdapter prepDEF_verifyWithoutDependencyWorks(MutablePicoContainer var1);

    public final void testDEF_verifyWithoutDependencyWorks() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
        ComponentAdapter componentAdapter = this.prepDEF_verifyWithoutDependencyWorks((MutablePicoContainer)picoContainer);
        AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
        componentAdapter.verify((PicoContainer)picoContainer);
    }

    protected abstract ComponentAdapter prepDEF_verifyDoesNotInstantiate(MutablePicoContainer var1);

    public final void testDEF_verifyDoesNotInstantiate() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
        ComponentAdapter componentAdapter = this.prepDEF_verifyDoesNotInstantiate((MutablePicoContainer)picoContainer);
        AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
        NotInstantiatableBehavior notInstantiatablecomponentAdapter = new NotInstantiatableBehavior(componentAdapter);
        PicoContainer wrappedPicoContainer = this.wrapComponentInstances(NotInstantiatableBehavior.class, (PicoContainer)picoContainer, null);
        notInstantiatablecomponentAdapter.verify(wrappedPicoContainer);
    }

    protected abstract ComponentAdapter prepDEF_visitable();

    public final void testDEF_visitable() {
        ComponentAdapter componentAdapter = this.prepDEF_visitable();
        Class type = this.getComponentAdapterType();
        AbstractComponentAdapterTestCase.assertSame((Object)type, componentAdapter.getClass());
        boolean hasParameters = this.supportsParameters(type);
        RecordingVisitor visitor = new RecordingVisitor();
        visitor.traverse(componentAdapter);
        ArrayList visitedElements = new ArrayList(visitor.getVisitedElements());
        AbstractComponentAdapterTestCase.assertSame((Object)componentAdapter, visitedElements.get(0));
        if (hasParameters) {
            hasParameters = false;
            Iterator iter = visitedElements.iterator();
            while (iter.hasNext() && !hasParameters) {
                hasParameters = Parameter.class.isAssignableFrom(iter.next().getClass());
            }
            AbstractComponentAdapterTestCase.assertTrue((String)("ComponentAdapter " + type + " supports parameters, provide some"), (boolean)hasParameters);
        }
    }

    protected ComponentAdapter prepDEF_isAbleToTakeParameters(MutablePicoContainer picoContainer) {
        Class type = this.getComponentAdapterType();
        boolean hasParameters = this.supportsParameters(type);
        if (hasParameters) {
            AbstractComponentAdapterTestCase.fail((String)"You have to overwrite this method for a useful test");
        }
        return null;
    }

    public final void testDEF_isAbleToTakeParameters() {
        Class type = this.getComponentAdapterType();
        boolean hasParameters = this.supportsParameters(type);
        if (hasParameters) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepDEF_isAbleToTakeParameters((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            RecordingVisitor visitor = new RecordingVisitor();
            visitor.traverse(componentAdapter);
            List visitedElements = visitor.getVisitedElements();
            if (hasParameters) {
                hasParameters = false;
                Iterator iter = visitedElements.iterator();
                while (iter.hasNext() && !hasParameters) {
                    hasParameters = Parameter.class.isAssignableFrom(iter.next().getClass());
                }
                AbstractComponentAdapterTestCase.assertTrue((String)("ComponentAdapter " + type + " supports parameters, provide some"), (boolean)hasParameters);
            }
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertNotNull((Object)instance);
        }
    }

    protected ComponentAdapter prepSER_isSerializable(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testSER_isSerializable() throws IOException, ClassNotFoundException {
        if ((this.getComponentAdapterNature() & 1) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepSER_isSerializable((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertNotNull((Object)instance);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
            outputStream.writeObject(componentAdapter);
            outputStream.close();
            ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            ComponentAdapter serializedComponentAdapter = (ComponentAdapter)inputStream.readObject();
            inputStream.close();
            AbstractComponentAdapterTestCase.assertEquals((Object)componentAdapter.getComponentKey(), (Object)serializedComponentAdapter.getComponentKey());
            Object instanceAfterSerialization = serializedComponentAdapter.getComponentInstance((PicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertNotNull((Object)instanceAfterSerialization);
            AbstractComponentAdapterTestCase.assertSame(instance.getClass(), instanceAfterSerialization.getClass());
        }
    }

    protected ComponentAdapter prepSER_isXStreamSerializable(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testSER_isXStreamSerializableWithPureReflection() {
        if ((this.getComponentAdapterNature() & 1) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepSER_isXStreamSerializable((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertNotNull((Object)instance);
            XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new XppDriver());
            String xml = xstream.toXML((Object)componentAdapter);
            ComponentAdapter serializedComponentAdapter = (ComponentAdapter)xstream.fromXML(xml);
            AbstractComponentAdapterTestCase.assertEquals((Object)componentAdapter.getComponentKey(), (Object)serializedComponentAdapter.getComponentKey());
            Object instanceAfterSerialization = serializedComponentAdapter.getComponentInstance((PicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertNotNull((Object)instanceAfterSerialization);
            AbstractComponentAdapterTestCase.assertSame(instance.getClass(), instanceAfterSerialization.getClass());
        }
    }

    public final void testSER_isXStreamSerializable() {
        if ((this.getComponentAdapterNature() & 1) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepSER_isXStreamSerializable((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertNotNull((Object)instance);
            XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver());
            String xml = xstream.toXML((Object)componentAdapter);
            ComponentAdapter serializedComponentAdapter = (ComponentAdapter)xstream.fromXML(xml);
            AbstractComponentAdapterTestCase.assertEquals((Object)componentAdapter.getComponentKey(), (Object)serializedComponentAdapter.getComponentKey());
            Object instanceAfterSerialization = serializedComponentAdapter.getComponentInstance((PicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertNotNull((Object)instanceAfterSerialization);
            AbstractComponentAdapterTestCase.assertSame(instance.getClass(), instanceAfterSerialization.getClass());
        }
    }

    protected ComponentAdapter prepVER_verificationFails(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testVER_verificationFails() {
        if ((this.getComponentAdapterNature() & 2) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepVER_verificationFails((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            try {
                componentAdapter.verify((PicoContainer)picoContainer);
                AbstractComponentAdapterTestCase.fail((String)"PicoCompositionException expected");
            }
            catch (PicoCompositionException e) {
            }
            catch (Exception e) {
                AbstractComponentAdapterTestCase.fail((String)("PicoCompositionException expected, but got " + e.getClass().getName()));
            }
            try {
                componentAdapter.getComponentInstance((PicoContainer)picoContainer);
                AbstractComponentAdapterTestCase.fail((String)"PicoCompositionException or PicoCompositionException expected");
            }
            catch (PicoCompositionException e) {
            }
            catch (Exception e) {
                AbstractComponentAdapterTestCase.fail((String)("PicoCompositionException or PicoCompositionException expected, but got " + e.getClass().getName()));
            }
        }
    }

    protected ComponentAdapter prepINS_createsNewInstances(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testINS_createsNewInstances() {
        if ((this.getComponentAdapterNature() & 4) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepINS_createsNewInstances((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertNotNull((Object)instance);
            AbstractComponentAdapterTestCase.assertNotSame((Object)instance, (Object)componentAdapter.getComponentInstance((PicoContainer)picoContainer));
            AbstractComponentAdapterTestCase.assertSame(instance.getClass(), componentAdapter.getComponentInstance((PicoContainer)picoContainer).getClass());
        }
    }

    protected ComponentAdapter prepINS_errorIsRethrown(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testINS_errorIsRethrown() {
        if ((this.getComponentAdapterNature() & 4) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepINS_errorIsRethrown((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            try {
                componentAdapter.getComponentInstance((PicoContainer)picoContainer);
                AbstractComponentAdapterTestCase.fail((String)"Thrown Error excpected");
            }
            catch (Error e) {
                AbstractComponentAdapterTestCase.assertEquals((String)"test", (String)e.getMessage());
            }
        }
    }

    protected ComponentAdapter prepINS_runtimeExceptionIsRethrown(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testINS_runtimeExceptionIsRethrown() {
        if ((this.getComponentAdapterNature() & 4) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepINS_runtimeExceptionIsRethrown((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            try {
                componentAdapter.getComponentInstance((PicoContainer)picoContainer);
                AbstractComponentAdapterTestCase.fail((String)"Thrown RuntimeException excpected");
            }
            catch (RuntimeException e) {
                AbstractComponentAdapterTestCase.assertEquals((String)"test", (String)e.getMessage());
            }
        }
    }

    protected ComponentAdapter prepINS_normalExceptionIsRethrownInsidePicoInitializationException(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testINS_normalExceptionIsRethrownInsidePicoInitializationException() {
        if ((this.getComponentAdapterNature() & 4) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepINS_normalExceptionIsRethrownInsidePicoInitializationException((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            try {
                componentAdapter.getComponentInstance((PicoContainer)picoContainer);
                AbstractComponentAdapterTestCase.fail((String)"Thrown PicoCompositionException excpected");
            }
            catch (PicoCompositionException e) {
                AbstractComponentAdapterTestCase.assertTrue((boolean)(e.getCause() instanceof Exception));
                AbstractComponentAdapterTestCase.assertTrue((boolean)e.getCause().getMessage().endsWith("test"));
            }
        }
    }

    protected ComponentAdapter prepRES_dependenciesAreResolved(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testRES_dependenciesAreResolved() {
        if ((this.getComponentAdapterNature() & 8) > 0) {
            LinkedList dependencies = new LinkedList();
            Object[] wrapperDependencies = new Object[]{dependencies};
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepRES_dependenciesAreResolved((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            AbstractComponentAdapterTestCase.assertFalse((boolean)picoContainer.getComponentAdapters().contains(componentAdapter));
            PicoContainer wrappedPicoContainer = this.wrapComponentInstances(CollectingBehavior.class, (PicoContainer)picoContainer, wrapperDependencies);
            Object instance = componentAdapter.getComponentInstance(wrappedPicoContainer);
            AbstractComponentAdapterTestCase.assertNotNull((Object)instance);
            AbstractComponentAdapterTestCase.assertTrue((dependencies.size() > 0 ? 1 : 0) != 0);
        }
    }

    protected ComponentAdapter prepRES_failingVerificationWithCyclicDependencyException(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testRES_failingVerificationWithCyclicDependencyException() {
        if ((this.getComponentAdapterNature() & 8) > 0) {
            HashSet cycleInstances = new HashSet();
            CachingBehavior.SimpleReference cycleCheck = new CachingBehavior.SimpleReference();
            Object[] wrapperDependencies = new Object[]{cycleInstances, cycleCheck};
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepRES_failingVerificationWithCyclicDependencyException((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            AbstractComponentAdapterTestCase.assertTrue((boolean)picoContainer.getComponentAdapters().contains(componentAdapter));
            PicoContainer wrappedPicoContainer = this.wrapComponentInstances(CycleDetectorBehavior.class, (PicoContainer)picoContainer, wrapperDependencies);
            try {
                componentAdapter.verify(wrappedPicoContainer);
                AbstractComponentAdapterTestCase.fail((String)"Thrown PicoVerificationException excpected");
            }
            catch (AbstractInjector.CyclicDependencyException cycle) {
                Class[] dependencies = cycle.getDependencies();
                AbstractComponentAdapterTestCase.assertSame((Object)dependencies[0], (Object)dependencies[dependencies.length - 1]);
            }
        }
    }

    protected ComponentAdapter prepRES_failingInstantiationWithCyclicDependencyException(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    public final void testRES_failingInstantiationWithCyclicDependencyException() {
        if ((this.getComponentAdapterNature() & 8) > 0) {
            HashSet cycleInstances = new HashSet();
            CachingBehavior.SimpleReference cycleCheck = new CachingBehavior.SimpleReference();
            Object[] wrapperDependencies = new Object[]{cycleInstances, cycleCheck};
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentAdapterFactory());
            ComponentAdapter componentAdapter = this.prepRES_failingInstantiationWithCyclicDependencyException((MutablePicoContainer)picoContainer);
            AbstractComponentAdapterTestCase.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            AbstractComponentAdapterTestCase.assertTrue((boolean)picoContainer.getComponentAdapters().contains(componentAdapter));
            PicoContainer wrappedPicoContainer = this.wrapComponentInstances(CycleDetectorBehavior.class, (PicoContainer)picoContainer, wrapperDependencies);
            try {
                componentAdapter.getComponentInstance(wrappedPicoContainer);
                AbstractComponentAdapterTestCase.fail((String)"Thrown CyclicDependencyException excpected");
            }
            catch (AbstractInjector.CyclicDependencyException e) {
                Class[] dependencies = e.getDependencies();
                AbstractComponentAdapterTestCase.assertSame((Object)dependencies[0], (Object)dependencies[dependencies.length - 1]);
            }
        }
    }

    protected final PicoContainer wrapComponentInstances(Class decoratingComponentAdapterClass, PicoContainer picoContainer, Object[] wrapperDependencies) {
        AbstractComponentAdapterTestCase.assertTrue((boolean)AbstractBehavior.class.isAssignableFrom(decoratingComponentAdapterClass));
        DefaultPicoContainer mutablePicoContainer = new DefaultPicoContainer();
        int size = (wrapperDependencies != null ? wrapperDependencies.length : 0) + 1;
        Collection allComponentAdapters = picoContainer.getComponentAdapters();
        for (Object allComponentAdapter : allComponentAdapters) {
            Parameter[] parameters = new Parameter[size];
            parameters[0] = new ConstantParameter(allComponentAdapter);
            for (int i = 1; i < parameters.length; ++i) {
                parameters[i] = new ConstantParameter(wrapperDependencies[i - 1]);
            }
            DefaultPicoContainer instantiatingPicoContainer = new DefaultPicoContainer((ComponentFactory)new ConstructorInjectionFactory());
            instantiatingPicoContainer.addComponent((Object)"decorator", (Object)decoratingComponentAdapterClass, parameters);
            mutablePicoContainer.addAdapter((ComponentAdapter)instantiatingPicoContainer.getComponent((Object)"decorator"));
        }
        return mutablePicoContainer;
    }

    private boolean supportsParameters(Class type) {
        boolean hasParameters = false;
        Constructor<?>[] constructors = type.getConstructors();
        block0: for (int i = 0; i < constructors.length && !hasParameters; ++i) {
            Class<?>[] parameterTypes;
            Constructor<?> constructor = constructors[i];
            for (Class<?> parameterType : parameterTypes = constructor.getParameterTypes()) {
                if (!Parameter.class.isAssignableFrom(parameterType) && (!parameterType.isArray() || !Parameter.class.isAssignableFrom(parameterType.getComponentType()))) continue;
                hasParameters = true;
                continue block0;
            }
        }
        return hasParameters;
    }

    public static final class RecordingLifecycleStrategy
    implements LifecycleStrategy {
        private final StringBuffer recorder;

        public RecordingLifecycleStrategy(StringBuffer recorder) {
            this.recorder = recorder;
        }

        public void start(Object component) {
            this.recorder.append("<start");
        }

        public void stop(Object component) {
            this.recorder.append("<stop");
        }

        public void dispose(Object component) {
            this.recorder.append("<dispose");
        }

        public boolean hasLifecycle(Class type) {
            return true;
        }

        public String recording() {
            return this.recorder.toString();
        }
    }

    public static class CycleDetectorBehavior
    extends AbstractBehavior {
        private final Set set;
        private final ObjectReference reference;

        public CycleDetectorBehavior(ComponentAdapter delegate, Set set, ObjectReference reference) {
            super(delegate);
            this.set = set;
            this.reference = reference;
        }

        public Object getComponentInstance(PicoContainer container) {
            if (this.set.contains((Object)this)) {
                this.reference.set((Object)this);
            } else {
                this.set.add(this);
            }
            return super.getComponentInstance(container);
        }
    }

    public static class CollectingBehavior
    extends AbstractBehavior {
        final List list;

        public CollectingBehavior(ComponentAdapter delegate, List list) {
            super(delegate);
            this.list = list;
        }

        public Object getComponentInstance(PicoContainer container) {
            Object result = super.getComponentInstance(container);
            this.list.add(result);
            return result;
        }
    }

    public static class NotInstantiatableBehavior
    extends AbstractBehavior {
        public NotInstantiatableBehavior(ComponentAdapter delegate) {
            super(delegate);
        }

        public Object getComponentInstance(PicoContainer container) {
            Assert.fail((String)"Not instantiatable");
            return null;
        }
    }

    static class RecordingVisitor
    extends AbstractPicoVisitor {
        private final List visitedElements = new LinkedList();

        RecordingVisitor() {
        }

        public void visitContainer(PicoContainer pico) {
            this.visitedElements.add(pico);
        }

        public void visitComponentAdapter(ComponentAdapter componentAdapter) {
            this.visitedElements.add(componentAdapter);
        }

        public void visitParameter(Parameter parameter) {
            this.visitedElements.add(parameter);
        }

        List getVisitedElements() {
            return this.visitedElements;
        }
    }
}

