/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoException;
import org.picocontainer.tck.AbstractPicoContainerTestCase;

public abstract class AbstractImplementationHidingPicoContainerTestCase
extends AbstractPicoContainerTestCase {
    public void testInstanceIsNotAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(Map.class, new HashMap(), new Parameter[0]);
        Map map = (Map)pc.getComponent(Map.class);
        AbstractImplementationHidingPicoContainerTestCase.assertNotNull((Object)map);
        AbstractImplementationHidingPicoContainerTestCase.assertTrue((boolean)(map instanceof HashMap));
    }

    protected abstract MutablePicoContainer createImplementationHidingPicoContainer();

    public void testImplementaionIsAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(Map.class, HashMap.class, new Parameter[0]);
        Map map = (Map)pc.getComponent(Map.class);
        AbstractImplementationHidingPicoContainerTestCase.assertNotNull((Object)map);
        AbstractImplementationHidingPicoContainerTestCase.assertFalse((boolean)(map instanceof HashMap));
    }

    public void testNonInterfaceImplementaionIsAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(HashMap.class, HashMap.class, new Parameter[0]);
        Map map = (Map)pc.getComponent(HashMap.class);
        AbstractImplementationHidingPicoContainerTestCase.assertNotNull((Object)map);
        AbstractImplementationHidingPicoContainerTestCase.assertTrue((boolean)(map instanceof HashMap));
    }

    public void testNonInterfaceImplementaionWithParametersIsAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(HashMap.class, HashMap.class, new Parameter[0]);
        Map map = (Map)pc.getComponent(HashMap.class);
        AbstractImplementationHidingPicoContainerTestCase.assertNotNull((Object)map);
        AbstractImplementationHidingPicoContainerTestCase.assertTrue((boolean)(map instanceof HashMap));
    }

    public void testImplementaionWithParametersIsAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(Map.class, HashMap.class, new Parameter[0]);
        Map map = (Map)pc.getComponent(Map.class);
        AbstractImplementationHidingPicoContainerTestCase.assertNotNull((Object)map);
        AbstractImplementationHidingPicoContainerTestCase.assertFalse((boolean)(map instanceof HashMap));
    }

    public void testSerializedContainerCanRetrieveImplementation() throws PicoException, IOException, ClassNotFoundException {
        try {
            super.testSerializedContainerCanRetrieveImplementation();
            AbstractImplementationHidingPicoContainerTestCase.fail((String)"The ImplementationHidingPicoContainer should not be able to retrieve the component impl");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testExceptionThrowingFromHiddenComponent() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(ActionListener.class, Burp.class, new Parameter[0]);
        try {
            ActionListener ac = (ActionListener)pc.getComponent(ActionListener.class);
            ac.actionPerformed(null);
            AbstractImplementationHidingPicoContainerTestCase.fail((String)"Oh no.");
        }
        catch (RuntimeException e) {
            AbstractImplementationHidingPicoContainerTestCase.assertEquals((String)"woohoo", (String)e.getMessage());
        }
    }

    public static class Burp
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            throw new RuntimeException("woohoo");
        }
    }
}

