/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoException;
import org.picocontainer.tck.AbstractPicoContainerTest;

public abstract class AbstractImplementationHidingPicoContainerTest
extends AbstractPicoContainerTest {
    @Test
    public void testInstanceIsNotAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.as(this.getProperties()).addComponent(Map.class, new HashMap(), new Parameter[0]);
        Map map = (Map)pc.getComponent(Map.class);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)(map instanceof HashMap));
    }

    protected abstract MutablePicoContainer createImplementationHidingPicoContainer();

    @Test
    public void testImplementaionIsAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(Map.class, HashMap.class, new Parameter[0]);
        Map map = (Map)pc.getComponent(Map.class);
        Assert.assertNotNull((Object)map);
        Assert.assertFalse((boolean)(map instanceof HashMap));
    }

    @Test
    public void testNonInterfaceImplementaionIsAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(HashMap.class, HashMap.class, new Parameter[0]);
        Map map = (Map)pc.getComponent(HashMap.class);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)(map instanceof HashMap));
    }

    @Test
    public void testNonInterfaceImplementaionWithParametersIsAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(HashMap.class, HashMap.class, new Parameter[0]);
        Map map = (Map)pc.getComponent(HashMap.class);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)(map instanceof HashMap));
    }

    @Test
    public void testImplementaionWithParametersIsAutomaticallyHidden() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(Map.class, HashMap.class, new Parameter[0]);
        Map map = (Map)pc.getComponent(Map.class);
        Assert.assertNotNull((Object)map);
        Assert.assertFalse((boolean)(map instanceof HashMap));
    }

    @Test
    public void testSerializedContainerCanRetrieveImplementation() throws PicoException, IOException, ClassNotFoundException {
        try {
            super.testSerializedContainerCanRetrieveImplementation();
            Assert.fail((String)"The ImplementationHidingPicoContainer should not be able to retrieve the component impl");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testExceptionThrowingFromHiddenComponent() {
        MutablePicoContainer pc = this.createImplementationHidingPicoContainer();
        pc.addComponent(ActionListener.class, Burp.class, new Parameter[0]);
        try {
            ActionListener ac = (ActionListener)pc.getComponent(ActionListener.class);
            ac.actionPerformed(null);
            Assert.fail((String)"Oh no.");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"woohoo", (Object)e.getMessage());
        }
    }

    public static class Burp
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            throw new RuntimeException("woohoo");
        }
    }
}

