/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.testmodel;

import org.junit.Assert;
import org.picocontainer.Disposable;
import org.picocontainer.PicoContainer;
import org.picocontainer.Startable;

public abstract class RecordingLifecycle
implements Startable,
Disposable {
    private final StringBuffer recording;

    protected RecordingLifecycle(StringBuffer recording) {
        this.recording = recording;
    }

    public void start() {
        this.recording.append("<").append(this.code());
    }

    public void stop() {
        this.recording.append(this.code()).append(">");
    }

    public void dispose() {
        this.recording.append("!").append(this.code());
    }

    public String recording() {
        return this.recording.toString();
    }

    private String code() {
        String name = this.getClass().getName();
        int idx = Math.max(name.lastIndexOf(36), name.lastIndexOf(46));
        return name.substring(idx + 1);
    }

    public static class FiveTriesToBeMalicious
    extends RecordingLifecycle {
        public FiveTriesToBeMalicious(StringBuffer sb, PicoContainer pc) {
            super(sb);
            Assert.assertNotNull((Object)pc);
            sb.append("Whao! Should not get instantiated!!");
        }
    }

    public static class Four
    extends RecordingLifecycle {
        public Four(StringBuffer sb, Two two, Three three, One one) {
            super(sb);
            Assert.assertNotNull((Object)one);
            Assert.assertNotNull((Object)two);
            Assert.assertNotNull((Object)three);
        }
    }

    public static class Three
    extends RecordingLifecycle {
        public Three(StringBuffer sb, One one, Two two) {
            super(sb);
            Assert.assertNotNull((Object)one);
            Assert.assertNotNull((Object)two);
        }
    }

    public static class Two
    extends RecordingLifecycle {
        public Two(StringBuffer sb, One one) {
            super(sb);
            Assert.assertNotNull((Object)one);
        }
    }

    public static class One
    extends RecordingLifecycle
    implements Recorder {
        public One(StringBuffer sb) {
            super(sb);
        }
    }

    public static interface Recorder
    extends Startable,
    Disposable {
        public String recording();
    }
}

