/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.picocontainer.Characteristics;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoException;

public abstract class AbstractLazyInstantiationTest {
    protected abstract MutablePicoContainer createPicoContainer();

    @Test
    public void testLazyInstantiation() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.as(new Properties[]{Characteristics.CACHE}).addComponent(Kilroy.class);
        pico.as(new Properties[]{Characteristics.CACHE}).addComponent(Havana.class);
        Assert.assertSame((Object)pico.getComponent(Havana.class), (Object)pico.getComponent(Havana.class));
        Assert.assertNotNull((Object)pico.getComponent(Havana.class));
        Assert.assertEquals((Object)"Clean wall", (Object)((Havana)pico.getComponent(Havana.class)).paint);
        Assert.assertNotNull((Object)pico.getComponent(Kilroy.class));
        Assert.assertEquals((Object)"Kilroy was here", (Object)((Havana)pico.getComponent(Havana.class)).paint);
    }

    public static class Havana {
        public String paint = "Clean wall";

        public void graffiti(String paint) {
            this.paint = paint;
        }
    }

    public static class Kilroy {
        public Kilroy(Havana havana) {
            havana.graffiti("Kilroy was here");
        }
    }
}

