/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Test;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.ObjectReference;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.AdaptingInjection;
import org.picocontainer.injectors.ConstructorInjection;
import org.picocontainer.parameters.ConstantParameter;
import org.picocontainer.references.SimpleReference;
import org.picocontainer.visitors.AbstractPicoVisitor;

public abstract class AbstractComponentAdapterTest {
    public static final int SERIALIZABLE = 1;
    public static final int VERIFYING = 2;
    public static final int INSTANTIATING = 4;
    public static final int RESOLVING = 8;

    protected abstract Class getComponentAdapterType();

    protected int getComponentAdapterNature() {
        return 15;
    }

    protected ComponentFactory createDefaultComponentFactory() {
        return new AdaptingInjection();
    }

    protected abstract ComponentAdapter prepDEF_verifyWithoutDependencyWorks(MutablePicoContainer var1);

    @Test
    public final void testDEF_verifyWithoutDependencyWorks() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
        ComponentAdapter componentAdapter = this.prepDEF_verifyWithoutDependencyWorks((MutablePicoContainer)picoContainer);
        Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
        componentAdapter.verify((PicoContainer)picoContainer);
    }

    protected abstract ComponentAdapter prepDEF_verifyDoesNotInstantiate(MutablePicoContainer var1);

    @Test
    public final void testDEF_verifyDoesNotInstantiate() {
        DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
        ComponentAdapter componentAdapter = this.prepDEF_verifyDoesNotInstantiate((MutablePicoContainer)picoContainer);
        Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
        NotInstantiatableBehavior notInstantiatablecomponentAdapter = new NotInstantiatableBehavior(componentAdapter);
        PicoContainer wrappedPicoContainer = this.wrapComponentInstances(NotInstantiatableBehavior.class, (PicoContainer)picoContainer, null);
        notInstantiatablecomponentAdapter.verify(wrappedPicoContainer);
    }

    protected abstract ComponentAdapter prepDEF_visitable();

    @Test
    public final void testDEF_visitable() {
        ComponentAdapter componentAdapter = this.prepDEF_visitable();
        Class type = this.getComponentAdapterType();
        Assert.assertSame((Object)type, componentAdapter.getClass());
        boolean hasParameters = this.supportsParameters(type);
        RecordingVisitor visitor = new RecordingVisitor();
        visitor.traverse(componentAdapter);
        ArrayList visitedElements = new ArrayList(visitor.getVisitedElements());
        Assert.assertSame((Object)componentAdapter, visitedElements.get(0));
        if (hasParameters) {
            hasParameters = false;
            Iterator iter = visitedElements.iterator();
            while (iter.hasNext() && !hasParameters) {
                hasParameters = Parameter.class.isAssignableFrom(iter.next().getClass());
            }
            Assert.assertTrue((String)("ComponentAdapter " + type + " supports parameters, provide some"), (boolean)hasParameters);
        }
    }

    protected ComponentAdapter prepDEF_isAbleToTakeParameters(MutablePicoContainer picoContainer) {
        Class type = this.getComponentAdapterType();
        boolean hasParameters = this.supportsParameters(type);
        if (hasParameters) {
            Assert.fail((String)"You have to overwrite this method for a useful test");
        }
        return null;
    }

    @Test
    public final void testDEF_isAbleToTakeParameters() {
        Class type = this.getComponentAdapterType();
        boolean hasParameters = this.supportsParameters(type);
        if (hasParameters) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepDEF_isAbleToTakeParameters((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            RecordingVisitor visitor = new RecordingVisitor();
            visitor.traverse(componentAdapter);
            List visitedElements = visitor.getVisitedElements();
            if (hasParameters) {
                hasParameters = false;
                Iterator iter = visitedElements.iterator();
                while (iter.hasNext() && !hasParameters) {
                    hasParameters = Parameter.class.isAssignableFrom(iter.next().getClass());
                }
                Assert.assertTrue((String)("ComponentAdapter " + type + " supports parameters, provide some"), (boolean)hasParameters);
            }
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
            Assert.assertNotNull((Object)instance);
        }
    }

    protected ComponentAdapter prepSER_isSerializable(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testSER_isSerializable() throws IOException, ClassNotFoundException {
        if ((this.getComponentAdapterNature() & 1) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepSER_isSerializable((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
            Assert.assertNotNull((Object)instance);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
            outputStream.writeObject(componentAdapter);
            outputStream.close();
            ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            ComponentAdapter serializedComponentAdapter = (ComponentAdapter)inputStream.readObject();
            inputStream.close();
            Assert.assertEquals((Object)componentAdapter.getComponentKey(), (Object)serializedComponentAdapter.getComponentKey());
            Object instanceAfterSerialization = serializedComponentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
            Assert.assertNotNull((Object)instanceAfterSerialization);
            Assert.assertSame(instance.getClass(), instanceAfterSerialization.getClass());
        }
    }

    protected ComponentAdapter prepSER_isXStreamSerializable(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testSER_isXStreamSerializableWithPureReflection() {
        if ((this.getComponentAdapterNature() & 1) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepSER_isXStreamSerializable((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
            Assert.assertNotNull((Object)instance);
            XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new XppDriver());
            String xml = xstream.toXML((Object)componentAdapter);
            ComponentAdapter serializedComponentAdapter = (ComponentAdapter)xstream.fromXML(xml);
            Assert.assertEquals((Object)componentAdapter.getComponentKey(), (Object)serializedComponentAdapter.getComponentKey());
            Object instanceAfterSerialization = serializedComponentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
            Assert.assertNotNull((Object)instanceAfterSerialization);
            Assert.assertSame(instance.getClass(), instanceAfterSerialization.getClass());
        }
    }

    @Test
    public final void testSER_isXStreamSerializable() {
        if ((this.getComponentAdapterNature() & 1) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepSER_isXStreamSerializable((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
            Assert.assertNotNull((Object)instance);
            XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver());
            String xml = xstream.toXML((Object)componentAdapter);
            ComponentAdapter serializedComponentAdapter = (ComponentAdapter)xstream.fromXML(xml);
            Assert.assertEquals((Object)componentAdapter.getComponentKey(), (Object)serializedComponentAdapter.getComponentKey());
            Object instanceAfterSerialization = serializedComponentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
            Assert.assertNotNull((Object)instanceAfterSerialization);
            Assert.assertSame(instance.getClass(), instanceAfterSerialization.getClass());
        }
    }

    protected ComponentAdapter prepVER_verificationFails(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testVER_verificationFails() {
        if ((this.getComponentAdapterNature() & 2) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer();
            ComponentAdapter componentAdapter = this.prepVER_verificationFails((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            try {
                componentAdapter.verify((PicoContainer)picoContainer);
                Assert.fail((String)"PicoCompositionException expected");
            }
            catch (PicoCompositionException e) {
            }
            catch (Exception e) {
                Assert.fail((String)("PicoCompositionException expected, but got " + e.getClass().getName()));
            }
            try {
                componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
                Assert.fail((String)"PicoCompositionException or PicoCompositionException expected");
            }
            catch (PicoCompositionException e) {
            }
            catch (Exception e) {
                Assert.fail((String)("PicoCompositionException or PicoCompositionException expected, but got " + e.getClass().getName()));
            }
        }
    }

    protected ComponentAdapter prepINS_createsNewInstances(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testINS_createsNewInstances() {
        if ((this.getComponentAdapterNature() & 4) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepINS_createsNewInstances((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Object instance = componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
            Assert.assertNotNull((Object)instance);
            Assert.assertNotSame((Object)instance, (Object)componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class));
            Assert.assertSame(instance.getClass(), componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class).getClass());
        }
    }

    protected ComponentAdapter prepINS_errorIsRethrown(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testINS_errorIsRethrown() {
        if ((this.getComponentAdapterNature() & 4) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepINS_errorIsRethrown((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            try {
                componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
                Assert.fail((String)"Thrown Error excpected");
            }
            catch (Error e) {
                Assert.assertEquals((Object)"test", (Object)e.getMessage());
            }
        }
    }

    protected ComponentAdapter prepINS_runtimeExceptionIsRethrown(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testINS_runtimeExceptionIsRethrown() {
        if ((this.getComponentAdapterNature() & 4) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepINS_runtimeExceptionIsRethrown((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            try {
                componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
                Assert.fail((String)"Thrown RuntimeException excpected");
            }
            catch (RuntimeException e) {
                Assert.assertEquals((Object)"test", (Object)e.getMessage());
            }
        }
    }

    protected ComponentAdapter prepINS_normalExceptionIsRethrownInsidePicoInitializationException(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testINS_normalExceptionIsRethrownInsidePicoInitializationException() {
        if ((this.getComponentAdapterNature() & 4) > 0) {
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepINS_normalExceptionIsRethrownInsidePicoInitializationException((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            try {
                componentAdapter.getComponentInstance((PicoContainer)picoContainer, ComponentAdapter.NOTHING.class);
                Assert.fail((String)"Thrown PicoCompositionException excpected");
            }
            catch (PicoCompositionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof Exception));
                Assert.assertTrue((boolean)e.getCause().getMessage().endsWith("test"));
            }
        }
    }

    protected ComponentAdapter prepRES_dependenciesAreResolved(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testRES_dependenciesAreResolved() {
        if ((this.getComponentAdapterNature() & 8) > 0) {
            LinkedList dependencies = new LinkedList();
            Object[] wrapperDependencies = new Object[]{dependencies};
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepRES_dependenciesAreResolved((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Assert.assertFalse((boolean)picoContainer.getComponentAdapters().contains(componentAdapter));
            PicoContainer wrappedPicoContainer = this.wrapComponentInstances(CollectingBehavior.class, (PicoContainer)picoContainer, wrapperDependencies);
            Object instance = componentAdapter.getComponentInstance(wrappedPicoContainer, ComponentAdapter.NOTHING.class);
            Assert.assertNotNull((Object)instance);
            Assert.assertTrue((dependencies.size() > 0 ? 1 : 0) != 0);
        }
    }

    protected ComponentAdapter prepRES_failingVerificationWithCyclicDependencyException(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testRES_failingVerificationWithCyclicDependencyException() {
        if ((this.getComponentAdapterNature() & 8) > 0) {
            HashSet cycleInstances = new HashSet();
            SimpleReference cycleCheck = new SimpleReference();
            Object[] wrapperDependencies = new Object[]{cycleInstances, cycleCheck};
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepRES_failingVerificationWithCyclicDependencyException((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Assert.assertTrue((boolean)picoContainer.getComponentAdapters().contains(componentAdapter));
            PicoContainer wrappedPicoContainer = this.wrapComponentInstances(CycleDetectorBehavior.class, (PicoContainer)picoContainer, wrapperDependencies);
            try {
                componentAdapter.verify(wrappedPicoContainer);
                Assert.fail((String)"Thrown PicoVerificationException excpected");
            }
            catch (AbstractInjector.CyclicDependencyException cycle) {
                Class[] dependencies = cycle.getDependencies();
                Assert.assertSame((Object)dependencies[0], (Object)dependencies[dependencies.length - 1]);
            }
        }
    }

    protected ComponentAdapter prepRES_failingInstantiationWithCyclicDependencyException(MutablePicoContainer picoContainer) {
        throw new AssertionFailedError("You have to overwrite this method for a useful test");
    }

    @Test
    public final void testRES_failingInstantiationWithCyclicDependencyException() {
        if ((this.getComponentAdapterNature() & 8) > 0) {
            HashSet cycleInstances = new HashSet();
            SimpleReference cycleCheck = new SimpleReference();
            Object[] wrapperDependencies = new Object[]{cycleInstances, cycleCheck};
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(this.createDefaultComponentFactory());
            ComponentAdapter componentAdapter = this.prepRES_failingInstantiationWithCyclicDependencyException((MutablePicoContainer)picoContainer);
            Assert.assertSame((Object)this.getComponentAdapterType(), componentAdapter.getClass());
            Assert.assertTrue((boolean)picoContainer.getComponentAdapters().contains(componentAdapter));
            PicoContainer wrappedPicoContainer = this.wrapComponentInstances(CycleDetectorBehavior.class, (PicoContainer)picoContainer, wrapperDependencies);
            try {
                componentAdapter.getComponentInstance(wrappedPicoContainer, ComponentAdapter.NOTHING.class);
                Assert.fail((String)"Thrown CyclicDependencyException excpected");
            }
            catch (AbstractInjector.CyclicDependencyException e) {
                Class[] dependencies = e.getDependencies();
                Assert.assertSame((Object)dependencies[0], (Object)dependencies[dependencies.length - 1]);
            }
        }
    }

    protected final PicoContainer wrapComponentInstances(Class decoratingComponentAdapterClass, PicoContainer picoContainer, Object[] wrapperDependencies) {
        Assert.assertTrue((boolean)AbstractBehavior.class.isAssignableFrom(decoratingComponentAdapterClass));
        DefaultPicoContainer mutablePicoContainer = new DefaultPicoContainer();
        int size = (wrapperDependencies != null ? wrapperDependencies.length : 0) + 1;
        Collection allComponentAdapters = picoContainer.getComponentAdapters();
        for (Object allComponentAdapter : allComponentAdapters) {
            Parameter[] parameters = new Parameter[size];
            parameters[0] = new ConstantParameter(allComponentAdapter);
            for (int i = 1; i < parameters.length; ++i) {
                parameters[i] = new ConstantParameter(wrapperDependencies[i - 1]);
            }
            DefaultPicoContainer instantiatingPicoContainer = new DefaultPicoContainer((ComponentFactory)new ConstructorInjection());
            instantiatingPicoContainer.addComponent((Object)"decorator", (Object)decoratingComponentAdapterClass, parameters);
            mutablePicoContainer.addAdapter((ComponentAdapter)instantiatingPicoContainer.getComponent((Object)"decorator"));
        }
        return mutablePicoContainer;
    }

    private boolean supportsParameters(Class type) {
        boolean hasParameters = false;
        Constructor<?>[] constructors = type.getConstructors();
        block0: for (int i = 0; i < constructors.length && !hasParameters; ++i) {
            Class<?>[] parameterTypes;
            Constructor<?> constructor = constructors[i];
            for (Class<?> parameterType : parameterTypes = constructor.getParameterTypes()) {
                if (!Parameter.class.isAssignableFrom(parameterType) && (!parameterType.isArray() || !Parameter.class.isAssignableFrom(parameterType.getComponentType()))) continue;
                hasParameters = true;
                continue block0;
            }
        }
        return hasParameters;
    }

    public static final class RecordingLifecycleStrategy
    implements LifecycleStrategy {
        private final StringBuffer recorder;

        public RecordingLifecycleStrategy(StringBuffer recorder) {
            this.recorder = recorder;
        }

        public void start(Object component) {
            this.recorder.append("<start");
        }

        public void stop(Object component) {
            this.recorder.append("<stop");
        }

        public void dispose(Object component) {
            this.recorder.append("<dispose");
        }

        public boolean hasLifecycle(Class type) {
            return true;
        }

        public String recording() {
            return this.recorder.toString();
        }
    }

    public static class CycleDetectorBehavior
    extends AbstractBehavior {
        private final Set set;
        private final ObjectReference reference;

        public CycleDetectorBehavior(ComponentAdapter delegate, Set set, ObjectReference reference) {
            super(delegate);
            this.set = set;
            this.reference = reference;
        }

        public Object getComponentInstance(PicoContainer container, Type into) {
            if (this.set.contains((Object)this)) {
                this.reference.set((Object)this);
            } else {
                this.set.add(this);
            }
            return super.getComponentInstance(container, into);
        }

        public String getDescriptor() {
            return "xxx";
        }
    }

    public static class CollectingBehavior
    extends AbstractBehavior {
        final List list;

        public CollectingBehavior(ComponentAdapter delegate, List list) {
            super(delegate);
            this.list = list;
        }

        public Object getComponentInstance(PicoContainer container, Type into) {
            Object result = super.getComponentInstance(container, into);
            this.list.add(result);
            return result;
        }

        public String getDescriptor() {
            return "xxx";
        }
    }

    public static class NotInstantiatableBehavior
    extends AbstractBehavior {
        public NotInstantiatableBehavior(ComponentAdapter delegate) {
            super(delegate);
        }

        public Object getComponentInstance(PicoContainer container, Type into) {
            junit.framework.Assert.fail((String)"Not instantiatable");
            return null;
        }

        public String getDescriptor() {
            return null;
        }
    }

    static class RecordingVisitor
    extends AbstractPicoVisitor {
        private final List visitedElements = new LinkedList();

        RecordingVisitor() {
        }

        public boolean visitContainer(PicoContainer pico) {
            this.visitedElements.add(pico);
            return true;
        }

        public void visitComponentAdapter(ComponentAdapter componentAdapter) {
            this.visitedElements.add(componentAdapter);
        }

        public void visitComponentFactory(ComponentFactory componentFactory) {
            this.visitedElements.add(componentFactory);
        }

        public void visitParameter(Parameter parameter) {
            this.visitedElements.add(parameter);
        }

        List getVisitedElements() {
            return this.visitedElements;
        }
    }
}

