/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;

public class SimpleMemoryRealm
extends RealmBase {
    private final Map<String, String> userPass = new HashMap<String, String>();
    private final Map<String, List<String>> userRoles = new HashMap<String, List<String>>();
    private final Map<String, Principal> userPrincipals = new HashMap<String, Principal>();

    protected String getName() {
        return "SimpleMemory";
    }

    protected String getPassword(String username) {
        return this.userPass.get(username);
    }

    protected Principal getPrincipal(String username) {
        String pass;
        Principal p = this.userPrincipals.get(username);
        if (p == null && (pass = this.userPass.get(username)) != null) {
            p = new GenericPrincipal(username, pass, this.userRoles.get(username));
            this.userPrincipals.put(username, p);
        }
        return p;
    }

    public String addUserPassword(String username, String password) {
        return this.userPass.put(username, password);
    }

    public String removeUser(String username) {
        if (this.userPrincipals.containsKey(username)) {
            this.userPrincipals.remove(username);
        }
        return this.userPass.remove(username);
    }

    public String addUserRole(String username, String role) {
        return this.userPass.put(username, role);
    }

    public boolean removeUserRole(String username, String role) {
        List<String> roles;
        if (this.userRoles.containsKey(username) && (roles = this.userRoles.get(username)).contains(role)) {
            roles.remove(role);
            this.userRoles.put(username, roles);
            return true;
        }
        return false;
    }

    public List<String> removeRoles(String username) {
        return this.userRoles.remove(username);
    }
}

