/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.impl;

import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.pidster.tomcat.embed.Builder;
import org.pidster.tomcat.embed.Tomcat;
import org.pidster.tomcat.embed.TomcatContainerBuilder;
import org.pidster.tomcat.embed.impl.AbstractLifecycleBuilder;
import org.pidster.tomcat.embed.impl.InstanceConfigurer;

public abstract class AbstractContainerBuilder<P extends Builder<Tomcat>, T extends Builder<Tomcat>>
extends AbstractLifecycleBuilder<P, T>
implements TomcatContainerBuilder<P, T> {
    private static final Logger logger = Logger.getLogger(AbstractContainerBuilder.class.getName());
    private Container container;

    protected AbstractContainerBuilder(P parent) {
        super(parent);
    }

    protected final void setContainer(Container container) {
        super.setLifecycle((Lifecycle)container);
        this.container = container;
    }

    protected final Container getContainer() {
        return this.container;
    }

    @Override
    public final T addValve(Class<? extends Valve> clazz) {
        Valve instance = InstanceConfigurer.newInstance(clazz);
        return this.addValve(instance);
    }

    @Override
    public final T addValve(Valve valve) {
        logger.log(Level.FINE, "addValve({0})", valve.getClass().getName());
        this.container.getPipeline().addValve(valve);
        return (T)this;
    }

    @Override
    public final T addContainerListener(Class<? extends ContainerListener> clazz) {
        ContainerListener instance = InstanceConfigurer.newInstance(clazz);
        return this.addContainerListener(instance);
    }

    @Override
    public final T addContainerListener(ContainerListener listener) {
        logger.log(Level.FINE, "addContainerListener({0})", listener.getClass().getName());
        this.container.addContainerListener(listener);
        return (T)this;
    }

    @Override
    public final T addPropertyChangeListener(Class<? extends PropertyChangeListener> clazz) {
        PropertyChangeListener instance = InstanceConfigurer.newInstance(clazz);
        return this.addPropertyChangeListener(instance);
    }

    @Override
    public final T addPropertyChangeListener(PropertyChangeListener listener) {
        logger.log(Level.FINE, "addPropertyChangeListener({0})", listener.getClass().getName());
        this.container.addPropertyChangeListener(listener);
        return (T)this;
    }

    @Override
    public final T setCluster(Cluster cluster) {
        logger.log(Level.FINE, "setCluster({0})", cluster.getClass().getName());
        cluster.setContainer(this.getContainer());
        this.container.setCluster(cluster);
        return (T)this;
    }

    @Override
    public final T setRealm(Realm realm) {
        logger.log(Level.FINE, "setRealm({0})", realm.getClass().getName());
        realm.setContainer(this.getContainer());
        this.container.setRealm(realm);
        return (T)this;
    }

    @Override
    public final T setBackgroundProcessorDelay(int delay) {
        this.container.setBackgroundProcessorDelay(delay);
        return (T)this;
    }

    @Override
    public final T setStartStopThreads(int startStopThreads) {
        this.container.setStartStopThreads(startStopThreads);
        return (T)this;
    }
}

