/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.Server;
import org.apache.catalina.core.JasperListener;
import org.apache.catalina.core.JreMemoryLeakPreventionListener;
import org.apache.catalina.core.ThreadLocalLeakPreventionListener;
import org.apache.catalina.mbeans.GlobalResourcesLifecycleListener;
import org.apache.catalina.startup.Catalina;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.pidster.tomcat.embed.CatalinaBuilder;
import org.pidster.tomcat.embed.Tomcat;
import org.pidster.tomcat.embed.TomcatHostBuilder;
import org.pidster.tomcat.embed.TomcatServerBuilder;
import org.pidster.tomcat.embed.TomcatServiceBuilder;
import org.pidster.tomcat.embed.impl.AbstractHierarchicalBuilder;
import org.pidster.tomcat.embed.impl.TomcatRuntimeImpl;
import org.pidster.tomcat.embed.impl.TomcatServerBuilderImpl;

public class CatalinaBuilderImpl
extends AbstractHierarchicalBuilder<CatalinaBuilderImpl, CatalinaBuilderImpl>
implements CatalinaBuilder {
    private final Catalina catalina = new Catalina();
    private final Properties properties = new Properties();

    public CatalinaBuilderImpl() {
        super(null);
        this.properties.setProperty("catalina.useNaming", "false");
    }

    @Override
    public CatalinaBuilder collect(Server child) {
        child.setCatalina(this.catalina);
        this.catalina.setServer(child);
        return this;
    }

    @Override
    public Tomcat build() {
        return new TomcatRuntimeImpl(this.catalina);
    }

    @Override
    public CatalinaBuilder addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    @Override
    public CatalinaBuilder setProperty(String name, String value) {
        this.properties.setProperty(name, value);
        return this;
    }

    @Override
    public CatalinaBuilder useConfig(String file) {
        return this.useConfig(new File(file));
    }

    @Override
    public CatalinaBuilder useConfig(File file) {
        if (!file.exists()) {
            throw new IllegalStateException("Config file does not exist");
        }
        this.catalina.setConfigFile(file.getAbsolutePath());
        return this;
    }

    @Override
    public CatalinaBuilder useClassLoader(ClassLoader classLoader) {
        this.catalina.setParentClassLoader(classLoader);
        return this;
    }

    @Override
    public CatalinaBuilder setUseShutdownHook(boolean useShutdownHook) {
        this.catalina.setUseShutdownHook(useShutdownHook);
        return this;
    }

    @Override
    public CatalinaBuilder setUseNaming(boolean useNaming) {
        this.catalina.setUseNaming(useNaming);
        return this;
    }

    @Override
    public TomcatServerBuilder newServer() {
        return this.newServer(8005);
    }

    @Override
    public TomcatServerBuilder newServer(int port) {
        return this.newServer("localhost", port);
    }

    @Override
    public TomcatServerBuilder newServer(String host, int port) {
        return this.newServer(host, port, "SHUTDOWN");
    }

    @Override
    public TomcatServerBuilder newServer(int port, String password) {
        return this.newServer("localhost", port, password);
    }

    @Override
    public TomcatServerBuilder newServer(String host, int port, String password) {
        System.getProperties().putAll((Map<?, ?>)this.properties);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("address", host);
        config.put("port", String.valueOf(port));
        config.put("shutdown", password);
        return new TomcatServerBuilderImpl(this, config);
    }

    @Override
    public TomcatHostBuilder newStandardServer() {
        return this.newStandardServer(-1, null, 8080, 8009);
    }

    @Override
    public TomcatHostBuilder newStandardServer(File baseDir) {
        return this.newStandardServer(-1, baseDir, 8080, 8009);
    }

    @Override
    public TomcatHostBuilder newStandardServer(File baseDir, int httpPort, int ajpPort) {
        return this.newStandardServer(-1, baseDir, httpPort, ajpPort);
    }

    @Override
    public TomcatHostBuilder newStandardServer(int httpPort, int ajpPort) {
        return this.newStandardServer(-1, null, httpPort, ajpPort);
    }

    @Override
    public TomcatHostBuilder newStandardServer(int port, File baseDir) {
        return this.newStandardServer(port, baseDir, 8080, 8009);
    }

    @Override
    public TomcatHostBuilder newStandardServer(int port, File baseDir, int httpPort, int ajpPort) {
        ContextResource memoryDatabase = new ContextResource();
        TomcatServerBuilder serverBuilder = this.newServer(port);
        if (baseDir != null) {
            serverBuilder.setCatalinaBase(baseDir);
            serverBuilder.setCatalinaHome(baseDir);
        }
        HashMap<String, String> connConfig = new HashMap<String, String>();
        connConfig.put("executorName", "tomcatThreadPool");
        return ((TomcatServiceBuilder)((TomcatServiceBuilder)((TomcatServerBuilder)((TomcatServerBuilder)((TomcatServerBuilder)((TomcatServerBuilder)serverBuilder.enableNaming().addLifecycleListener(JasperListener.class)).addLifecycleListener(GlobalResourcesLifecycleListener.class)).addLifecycleListener(JreMemoryLeakPreventionListener.class)).addLifecycleListener(ThreadLocalLeakPreventionListener.class)).addGlobalResource(memoryDatabase).addService("Catalina").setBackgroundProcessorDelay(0)).setStartStopThreads(0)).addExecutor("tomcatThreadPool", "tomcat-exec-", 200, 5, Tomcat.EMPTY).addConnector("org.apache.coyote.http11.Http11Protocol", httpPort, connConfig).addConnector("org.apache.coyote.ajp.AjpNioProtocol", ajpPort, connConfig).addHost("localhost", "webapps");
    }

    @Override
    public TomcatHostBuilder newMinimalServer() {
        return this.newMinimalServer(-1, null, 8080);
    }

    @Override
    public TomcatHostBuilder newMinimalServer(int http) {
        return this.newMinimalServer(-1, null, http);
    }

    @Override
    public TomcatHostBuilder newMinimalServer(File baseDir) {
        return this.newMinimalServer(-1, baseDir, 8080);
    }

    @Override
    public TomcatHostBuilder newMinimalServer(File baseDir, int http) {
        return this.newMinimalServer(-1, baseDir, http);
    }

    @Override
    public TomcatHostBuilder newMinimalServer(int port, File baseDir) {
        return this.newMinimalServer(port, baseDir, 8080);
    }

    @Override
    public TomcatHostBuilder newMinimalServer(int port, File baseDir, int http) {
        TomcatServerBuilder serverBuilder = this.newServer(port);
        if (baseDir != null) {
            serverBuilder.setCatalinaBase(baseDir);
            serverBuilder.setCatalinaHome(baseDir);
        }
        HashMap<String, String> connConfig = new HashMap<String, String>();
        connConfig.put("executorName", "tomcatThreadPool");
        return ((TomcatServiceBuilder)((TomcatServiceBuilder)serverBuilder.addService("Catalina").setBackgroundProcessorDelay(0)).setStartStopThreads(0)).addExecutor("tomcatThreadPool", "tomcat-exec-", 200, 5, Tomcat.EMPTY).addConnector("org.apache.coyote.http11.Http11Protocol", http, connConfig).addHost("localhost", "webapps");
    }
}

